//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter normX_0_x_w             = 20;

  // Outputs
  parameter normX_0_y_w             = 20;

  // Input control lines
  parameter normX_0_runOut_w        = 1;

  // Output control lines

  // Eregs
  parameter normX_0_amp_w           = 8;
  parameter normX_0_amp_r           = 0;
  parameter normX_0_amp_s           = 0;

  // Parameters
  parameter normX_0_wx              = 10;
  parameter normX_0_wy              = 10;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam normX_0.x_w             = normX_0_x_w;
  defparam normX_0.y_w             = normX_0_y_w;
  defparam normX_0.runOut_w        = normX_0_runOut_w;
  defparam normX_0.amp_w           = normX_0_amp_w;
  defparam normX_0.amp_r           = normX_0_amp_r;
  defparam normX_0.amp_s           = normX_0_amp_s;
  defparam normX_0.wx              = normX_0_wx;
  defparam normX_0.wy              = normX_0_wy;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_normX_0_amp                                                = 0;
  defparam  normX_0.R_amp                                                = R_normX_0_amp;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                   [normX_0_y_w-1:0]  normX_0_y;
  wire                                      normX_0_y_or;
  wire                                      normX_0_y_ff;
  wire                                      normX_0_y_we;

  wire                   [normX_0_x_w-1:0]  normX_0_x;
  wire                                      normX_0_x_ir;
  wire                                      normX_0_x_fe;
  wire                                      normX_0_x_re;

  wire              [normX_0_runOut_w-1:0]  normX_0_runOut;

  wire                                      normX_0_regWe;
  wire                                      normX_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  normX normX_0(normX_0_y, normX_0_y_or, normX_0_y_ff, normX_0_y_we,
                normX_0_x, normX_0_x_ir, normX_0_x_fe, normX_0_x_re, 
                normX_0_runOut, 
                regBus, regWe, regRe, normX_0_regWe, normX_0_regRe, clk, clk2, reset);


//==============================================================================
