//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter normXDivCore_re4_nIn_w           = 11;
  parameter normXDivCore_re4_qIn_w           = 9;
  parameter normXDivCore_re4_dIn_w           = 8;

  // Outputs
  parameter normXDivCore_re4_nOut_w          = 11;
  parameter normXDivCore_re4_qOut_w          = 9;

  // Input control lines

  // Output control lines

  // Eregs

  // Parameters
  parameter normXDivCore_re4_wn              = 11;
  parameter normXDivCore_re4_wd              = 8;
  parameter normXDivCore_re4_wq              = 9;
  parameter normXDivCore_re4_ws              = 2;
  parameter normXDivCore_re4_wy              = 10;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam normXDivCore_re4.nIn_w           = normXDivCore_re4_nIn_w;
  defparam normXDivCore_re4.qIn_w           = normXDivCore_re4_qIn_w;
  defparam normXDivCore_re4.dIn_w           = normXDivCore_re4_dIn_w;
  defparam normXDivCore_re4.nOut_w          = normXDivCore_re4_nOut_w;
  defparam normXDivCore_re4.qOut_w          = normXDivCore_re4_qOut_w;
  defparam normXDivCore_re4.wn              = normXDivCore_re4_wn;
  defparam normXDivCore_re4.wd              = normXDivCore_re4_wd;
  defparam normXDivCore_re4.wq              = normXDivCore_re4_wq;
  defparam normXDivCore_re4.ws              = normXDivCore_re4_ws;
  defparam normXDivCore_re4.wy              = normXDivCore_re4_wy;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire       [normXDivCore_re4_nOut_w-1:0]  normXDivCore_re4_nOut;
  wire                                      normXDivCore_re4_nOut_or;
  wire                                      normXDivCore_re4_nOut_ff;
  wire                                      normXDivCore_re4_nOut_we;

  wire       [normXDivCore_re4_qOut_w-1:0]  normXDivCore_re4_qOut;
  wire                                      normXDivCore_re4_qOut_or;
  wire                                      normXDivCore_re4_qOut_ff;
  wire                                      normXDivCore_re4_qOut_we;

  wire        [normXDivCore_re4_nIn_w-1:0]  normXDivCore_re4_nIn;
  wire                                      normXDivCore_re4_nIn_ir;
  wire                                      normXDivCore_re4_nIn_fe;
  wire                                      normXDivCore_re4_nIn_re;

  wire        [normXDivCore_re4_qIn_w-1:0]  normXDivCore_re4_qIn;
  wire                                      normXDivCore_re4_qIn_ir;
  wire                                      normXDivCore_re4_qIn_fe;
  wire                                      normXDivCore_re4_qIn_re;

  wire        [normXDivCore_re4_dIn_w-1:0]  normXDivCore_re4_dIn;
  wire                                      normXDivCore_re4_dIn_ir;
  wire                                      normXDivCore_re4_dIn_fe;
  wire                                      normXDivCore_re4_dIn_re;

  wire                                      normXDivCore_re4_regWe;
  wire                                      normXDivCore_re4_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  normXDivCore normXDivCore_re4(normXDivCore_re4_nOut, normXDivCore_re4_nOut_or, normXDivCore_re4_nOut_ff, normXDivCore_re4_nOut_we,
                                normXDivCore_re4_qOut, normXDivCore_re4_qOut_or, normXDivCore_re4_qOut_ff, normXDivCore_re4_qOut_we,
                                normXDivCore_re4_nIn, normXDivCore_re4_nIn_ir, normXDivCore_re4_nIn_fe, normXDivCore_re4_nIn_re, 
                                normXDivCore_re4_qIn, normXDivCore_re4_qIn_ir, normXDivCore_re4_qIn_fe, normXDivCore_re4_qIn_re, 
                                normXDivCore_re4_dIn, normXDivCore_re4_dIn_ir, normXDivCore_re4_dIn_fe, normXDivCore_re4_dIn_re, 
                                regBus, regWe, regRe, normXDivCore_re4_regWe, normXDivCore_re4_regRe, clk, clk2, reset);


//==============================================================================
