//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   modQpskZero
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module modQpskZero(y, y_or, y_ff, y_we, 
                   x, x_ir, x_fe, x_re, 
                   run1, 
                   mode1, 
                   regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter x_w               = 0;

  parameter run1_w            = 0;
  parameter mode1_w           = 0;

  parameter numZeros_w        = 0;
  parameter numZeros_r        = 0;
  parameter numZeros_s        = 0;
  parameter R_numZeros        = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  input          [run1_w-1:0]  run1;
  input         [mode1_w-1:0]  mode1;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire       [numZeros_w-1:0]  numZeros_q;
  wire       [numZeros_w-1:0]  numZeros_d;
  wire                         numZeros_weint;
  assign                       numZeros_weint = 0;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg numZeros(numZeros_q, regBus, numZeros_d, numZeros_weint, regWe, regRe, clk, reset);
  defparam numZeros.w    = numZeros_w;
  defparam numZeros.rval = numZeros_r;
  defparam numZeros.sgn  = numZeros_s;
  defparam numZeros.adr  = R_numZeros;

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // -------------------------------------------------------------------------------------
  // Some more defintions
  reg             y_or;           // Registered versions of y and y_or
  reg   [y_w-1:0] y, xMod;
  reg       [2:0] cntZeros;       // Count zeros to append at the end
  
  // -------------------------------------------------------------------------------------
  // Define input and output signals and control
  assign x_ir = run1 & mode1==0 & (~y_or | y_we);
  assign zEn  = cntZeros!=0 & mode1==1 & (~y_or | y_we);
  
  always @(*)                     
    case ({x_re, x})              
      3'b100 :  xMod = 4'b0101;   // Whenever data is read from the input
      3'b101 :  xMod = 4'b0111;   //  -> do QPSK modulation
      3'b110 :  xMod = 4'b1111;   // else
      3'b111 :  xMod = 4'b1101;   //  -> set the output to 0
      default : xMod = 0;
    endcase

  // -------------------------------------------------------------------------------------        
  // Output FSM
  always @(posedge clk) begin
    
    // Reset output FSM
    if (run1==0) begin
      y         <= 0;
      y_or      <= 0;
      cntZeros  <= numZeros_q;
    end else
    
    // Normal output FSM operation            // The output is ready if it has been ready
    begin                                     // before and is not read, or if the input is
      y_or <= (y_or & y_we==0) | x_re | zEn;  // read or if a zero is produced
      if (x_re | zEn) begin                   
        y <= xMod;                 // Provide new output
        if (zEn) begin
          cntZeros <= cntZeros-1;   // Eventually count down zeros
        end
      end
    end // if (run1==0)
  end //always 

endmodule
//=========================================================================================
