//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter mod11bQpsk_0_x_w             = 1;

  // Outputs
  parameter mod11bQpsk_0_y_w             = 2;

  // Input control lines
  parameter mod11bQpsk_0_run1_w          = 1;
  parameter mod11bQpsk_0_phIn_w          = 2;

  // Output control lines
  parameter mod11bQpsk_0_runCck_w        = 1;
  parameter mod11bQpsk_0_phOut_w         = 2;

  // Eregs
  parameter mod11bQpsk_0_numBits_w       = 16;
  parameter mod11bQpsk_0_numBits_r       = 0;
  parameter mod11bQpsk_0_numBits_s       = 0;

  // Parameters

  // Iregs
  parameter mod11bQpsk_0_ph_w            = 2;
  parameter mod11bQpsk_0_ph_n            = 1;
  parameter mod11bQpsk_0_ph_m            = `CLOG2(1);
  parameter mod11bQpsk_0_cntBits_w       = 16;
  parameter mod11bQpsk_0_cntBits_n       = 1;
  parameter mod11bQpsk_0_cntBits_m       = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam mod11bQpsk_0.x_w             = mod11bQpsk_0_x_w;
  defparam mod11bQpsk_0.y_w             = mod11bQpsk_0_y_w;
  defparam mod11bQpsk_0.run1_w          = mod11bQpsk_0_run1_w;
  defparam mod11bQpsk_0.phIn_w          = mod11bQpsk_0_phIn_w;
  defparam mod11bQpsk_0.runCck_w        = mod11bQpsk_0_runCck_w;
  defparam mod11bQpsk_0.phOut_w         = mod11bQpsk_0_phOut_w;
  defparam mod11bQpsk_0.numBits_w       = mod11bQpsk_0_numBits_w;
  defparam mod11bQpsk_0.numBits_r       = mod11bQpsk_0_numBits_r;
  defparam mod11bQpsk_0.numBits_s       = mod11bQpsk_0_numBits_s;
  defparam mod11bQpsk_0.ph_w            = mod11bQpsk_0_ph_w;
  defparam mod11bQpsk_0.ph_n            = mod11bQpsk_0_ph_n;
  defparam mod11bQpsk_0.ph_m            = mod11bQpsk_0_ph_m;
  defparam mod11bQpsk_0.cntBits_w       = mod11bQpsk_0_cntBits_w;
  defparam mod11bQpsk_0.cntBits_n       = mod11bQpsk_0_cntBits_n;
  defparam mod11bQpsk_0.cntBits_m       = mod11bQpsk_0_cntBits_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_mod11bQpsk_0_numBits                                       = 0;
  defparam  mod11bQpsk_0.R_numBits                                       = R_mod11bQpsk_0_numBits;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire              [mod11bQpsk_0_y_w-1:0]  mod11bQpsk_0_y;
  wire                                      mod11bQpsk_0_y_or;
  wire                                      mod11bQpsk_0_y_ff;
  wire                                      mod11bQpsk_0_y_we;

  wire              [mod11bQpsk_0_x_w-1:0]  mod11bQpsk_0_x;
  wire                                      mod11bQpsk_0_x_ir;
  wire                                      mod11bQpsk_0_x_fe;
  wire                                      mod11bQpsk_0_x_re;

  wire         [mod11bQpsk_0_runCck_w-1:0]  mod11bQpsk_0_runCck;
  wire          [mod11bQpsk_0_phOut_w-1:0]  mod11bQpsk_0_phOut;

  wire           [mod11bQpsk_0_run1_w-1:0]  mod11bQpsk_0_run1;
  wire           [mod11bQpsk_0_phIn_w-1:0]  mod11bQpsk_0_phIn;

  wire                                      mod11bQpsk_0_regWe;
  wire                                      mod11bQpsk_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  mod11bQpsk mod11bQpsk_0(mod11bQpsk_0_y, mod11bQpsk_0_y_or, mod11bQpsk_0_y_ff, mod11bQpsk_0_y_we,
                          mod11bQpsk_0_x, mod11bQpsk_0_x_ir, mod11bQpsk_0_x_fe, mod11bQpsk_0_x_re, 
                          mod11bQpsk_0_runCck, 
                          mod11bQpsk_0_phOut, 
                          mod11bQpsk_0_run1, 
                          mod11bQpsk_0_phIn, 
                          regBus, regWe, regRe, mod11bQpsk_0_regWe, mod11bQpsk_0_regRe, clk, clk2, reset);


//==============================================================================
