//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter mod11bBpsk_0_x_w             = 1;

  // Outputs
  parameter mod11bBpsk_0_y_w             = 2;

  // Input control lines
  parameter mod11bBpsk_0_run1_w          = 1;

  // Output control lines
  parameter mod11bBpsk_0_runQpsk_w       = 1;
  parameter mod11bBpsk_0_phOut_w         = 2;

  // Eregs
  parameter mod11bBpsk_0_numBits_w       = 16;
  parameter mod11bBpsk_0_numBits_r       = 0;
  parameter mod11bBpsk_0_numBits_s       = 0;

  // Parameters

  // Iregs
  parameter mod11bBpsk_0_ph_w            = 2;
  parameter mod11bBpsk_0_ph_n            = 1;
  parameter mod11bBpsk_0_ph_m            = `CLOG2(1);
  parameter mod11bBpsk_0_cntBits_w       = 16;
  parameter mod11bBpsk_0_cntBits_n       = 1;
  parameter mod11bBpsk_0_cntBits_m       = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam mod11bBpsk_0.x_w             = mod11bBpsk_0_x_w;
  defparam mod11bBpsk_0.y_w             = mod11bBpsk_0_y_w;
  defparam mod11bBpsk_0.run1_w          = mod11bBpsk_0_run1_w;
  defparam mod11bBpsk_0.runQpsk_w       = mod11bBpsk_0_runQpsk_w;
  defparam mod11bBpsk_0.phOut_w         = mod11bBpsk_0_phOut_w;
  defparam mod11bBpsk_0.numBits_w       = mod11bBpsk_0_numBits_w;
  defparam mod11bBpsk_0.numBits_r       = mod11bBpsk_0_numBits_r;
  defparam mod11bBpsk_0.numBits_s       = mod11bBpsk_0_numBits_s;
  defparam mod11bBpsk_0.ph_w            = mod11bBpsk_0_ph_w;
  defparam mod11bBpsk_0.ph_n            = mod11bBpsk_0_ph_n;
  defparam mod11bBpsk_0.ph_m            = mod11bBpsk_0_ph_m;
  defparam mod11bBpsk_0.cntBits_w       = mod11bBpsk_0_cntBits_w;
  defparam mod11bBpsk_0.cntBits_n       = mod11bBpsk_0_cntBits_n;
  defparam mod11bBpsk_0.cntBits_m       = mod11bBpsk_0_cntBits_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_mod11bBpsk_0_numBits                                       = 0;
  defparam  mod11bBpsk_0.R_numBits                                       = R_mod11bBpsk_0_numBits;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire              [mod11bBpsk_0_y_w-1:0]  mod11bBpsk_0_y;
  wire                                      mod11bBpsk_0_y_or;
  wire                                      mod11bBpsk_0_y_ff;
  wire                                      mod11bBpsk_0_y_we;

  wire              [mod11bBpsk_0_x_w-1:0]  mod11bBpsk_0_x;
  wire                                      mod11bBpsk_0_x_ir;
  wire                                      mod11bBpsk_0_x_fe;
  wire                                      mod11bBpsk_0_x_re;

  wire        [mod11bBpsk_0_runQpsk_w-1:0]  mod11bBpsk_0_runQpsk;
  wire          [mod11bBpsk_0_phOut_w-1:0]  mod11bBpsk_0_phOut;

  wire           [mod11bBpsk_0_run1_w-1:0]  mod11bBpsk_0_run1;

  wire                                      mod11bBpsk_0_regWe;
  wire                                      mod11bBpsk_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  mod11bBpsk mod11bBpsk_0(mod11bBpsk_0_y, mod11bBpsk_0_y_or, mod11bBpsk_0_y_ff, mod11bBpsk_0_y_we,
                          mod11bBpsk_0_x, mod11bBpsk_0_x_ir, mod11bBpsk_0_x_fe, mod11bBpsk_0_x_re, 
                          mod11bBpsk_0_runQpsk, 
                          mod11bBpsk_0_phOut, 
                          mod11bBpsk_0_run1, 
                          regBus, regWe, regRe, mod11bBpsk_0_regWe, mod11bBpsk_0_regRe, clk, clk2, reset);


//==============================================================================
