//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter memReplay_52x20_x_w             = 20;

  // Outputs
  parameter memReplay_52x20_y_w             = 20;

  // Input control lines
  parameter memReplay_52x20_run1_w          = 2;

  // Output control lines

  // Eregs

  // Parameters
  parameter memReplay_52x20_w               = 20;
  parameter memReplay_52x20_n               = 52;
  parameter memReplay_52x20_m               = 6;

  // Iregs

  // Single ported memories
  parameter memReplay_52x20_mem0_w          = 20;
  parameter memReplay_52x20_mem0_n          = 52;
  parameter memReplay_52x20_mem0_m          = `CLOG2(52);

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam memReplay_52x20.x_w             = memReplay_52x20_x_w;
  defparam memReplay_52x20.y_w             = memReplay_52x20_y_w;
  defparam memReplay_52x20.run1_w          = memReplay_52x20_run1_w;
  defparam memReplay_52x20.w               = memReplay_52x20_w;
  defparam memReplay_52x20.n               = memReplay_52x20_n;
  defparam memReplay_52x20.m               = memReplay_52x20_m;
  defparam memReplay_52x20.mem0_w          = memReplay_52x20_mem0_w;
  defparam memReplay_52x20.mem0_n          = memReplay_52x20_mem0_n;
  defparam memReplay_52x20.mem0_m          = memReplay_52x20_mem0_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire           [memReplay_52x20_y_w-1:0]  memReplay_52x20_y;
  wire                                      memReplay_52x20_y_or;
  wire                                      memReplay_52x20_y_ff;
  wire                                      memReplay_52x20_y_we;

  wire           [memReplay_52x20_x_w-1:0]  memReplay_52x20_x;
  wire                                      memReplay_52x20_x_ir;
  wire                                      memReplay_52x20_x_fe;
  wire                                      memReplay_52x20_x_re;

  wire        [memReplay_52x20_run1_w-1:0]  memReplay_52x20_run1;

  wire                                      memReplay_52x20_regWe;
  wire                                      memReplay_52x20_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  memReplay memReplay_52x20(memReplay_52x20_y, memReplay_52x20_y_or, memReplay_52x20_y_ff, memReplay_52x20_y_we,
                            memReplay_52x20_x, memReplay_52x20_x_ir, memReplay_52x20_x_fe, memReplay_52x20_x_re, 
                            memReplay_52x20_run1, 
                            regBus, regWe, regRe, memReplay_52x20_regWe, memReplay_52x20_regRe, clk, clk2, reset);


//==============================================================================
