//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter memReplay_48x9_x_w             = 9;

  // Outputs
  parameter memReplay_48x9_y_w             = 9;

  // Input control lines
  parameter memReplay_48x9_run1_w          = 2;

  // Output control lines

  // Eregs

  // Parameters
  parameter memReplay_48x9_w               = 9;
  parameter memReplay_48x9_n               = 48;
  parameter memReplay_48x9_m               = 6;

  // Iregs

  // Single ported memories
  parameter memReplay_48x9_mem0_w          = 9;
  parameter memReplay_48x9_mem0_n          = 48;
  parameter memReplay_48x9_mem0_m          = `CLOG2(48);

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam memReplay_48x9.x_w             = memReplay_48x9_x_w;
  defparam memReplay_48x9.y_w             = memReplay_48x9_y_w;
  defparam memReplay_48x9.run1_w          = memReplay_48x9_run1_w;
  defparam memReplay_48x9.w               = memReplay_48x9_w;
  defparam memReplay_48x9.n               = memReplay_48x9_n;
  defparam memReplay_48x9.m               = memReplay_48x9_m;
  defparam memReplay_48x9.mem0_w          = memReplay_48x9_mem0_w;
  defparam memReplay_48x9.mem0_n          = memReplay_48x9_mem0_n;
  defparam memReplay_48x9.mem0_m          = memReplay_48x9_mem0_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire            [memReplay_48x9_y_w-1:0]  memReplay_48x9_y;
  wire                                      memReplay_48x9_y_or;
  wire                                      memReplay_48x9_y_ff;
  wire                                      memReplay_48x9_y_we;

  wire            [memReplay_48x9_x_w-1:0]  memReplay_48x9_x;
  wire                                      memReplay_48x9_x_ir;
  wire                                      memReplay_48x9_x_fe;
  wire                                      memReplay_48x9_x_re;

  wire         [memReplay_48x9_run1_w-1:0]  memReplay_48x9_run1;

  wire                                      memReplay_48x9_regWe;
  wire                                      memReplay_48x9_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  memReplay memReplay_48x9(memReplay_48x9_y, memReplay_48x9_y_or, memReplay_48x9_y_ff, memReplay_48x9_y_we,
                           memReplay_48x9_x, memReplay_48x9_x_ir, memReplay_48x9_x_fe, memReplay_48x9_x_re, 
                           memReplay_48x9_run1, 
                           regBus, regWe, regRe, memReplay_48x9_regWe, memReplay_48x9_regRe, clk, clk2, reset);


//==============================================================================
