//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   memReplay
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module memReplay(y, y_or, y_ff, y_we, 
                 x, x_ir, x_fe, x_re, 
                 run1, 
                 regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter x_w               = 0;

  parameter run1_w            = 0;

  parameter w                 = 0;
  parameter n                 = 0;
  parameter m                 = 0;

  parameter mem0_w            = 0;
  parameter mem0_n            = 0;
  parameter mem0_m            = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  input          [run1_w-1:0]  run1;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for internal memories
  wire           [mem0_w-1:0]  mem0_q;
  wire           [mem0_w-1:0]  mem0_d;
  wire           [mem0_m-1:0]  mem0_adr;
  wire                         mem0_we;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  // --------------------------------------------------------------------------------------
  // Internal single ported memories
  spRam1 mem0(mem0_q, mem0_d, mem0_adr, mem0_we, clk);
  defparam mem0.w    = mem0_w;
  defparam mem0.n    = mem0_n;
  defparam mem0.m    = mem0_m;

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Register definitions
  reg          [m-1:0]  adr, adrP1;
  reg          [w-1:0]  mem0QD;
  reg                   y_weD;
  
  // --------------------------------------------------------------------------------------
  // Assign input and output enable
  assign x_ir = run1==2;
  assign y_or = run1==3;
  assign y    = (y_weD==0 & y_we==1) ? mem0QD : mem0_q;
  
  // Assign memory
  assign mem0_d     = x;
  assign mem0_we    = x_re;
  assign mem0_adr   = run1==3 ? adrP1 : adr;
  
  // --------------------------------------------------------------------------------------
  // Signal processing behaviour
  always @(*) begin
        
    if (adr!=n-1) begin
      adrP1 = adr+1;
    end else begin
      adrP1 = 0;
    end
    
  end

  // --------------------------------------------------------------------------------------
  // FSM
  always @(posedge clk) begin
    
    // Delayed control signal
    y_weD <= y_we;
    
    // Reset
    if (run1==0) begin
      adr   <= 0;
      
    // Normal operation
    end else begin
            
      // Register update 1
      if ((run1==2 & x_re==1) | (run1==3 & y_we==1)) begin
        adr <= adrP1;
      end

    end // if (run1_q==0) ... else

    // Output reg update - do this also if run1==0
    if (y_weD==1 | run1!=3) begin
      mem0QD <= mem0_q;
    end

  end // always

endmodule
//=========================================================================================

