//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter main11b_0_bIn_w           = 8;
  parameter main11b_0_rx20_w          = 20;

  // Outputs
  parameter main11b_0_bOut_w          = 8;
  parameter main11b_0_tx20_w          = 20;

  // Input control lines
  parameter main11b_0_ssAcqHalt_w     = 1;

  // Output control lines
  parameter main11b_0_ssDetect_w      = 1;

  // Eregs
  parameter main11b_0_state11b_w      = 8;
  parameter main11b_0_state11b_r      = 0;
  parameter main11b_0_state11b_s      = 0;
  parameter main11b_0_state11bDbg_w   = 8;
  parameter main11b_0_state11bDbg_r   = 0;
  parameter main11b_0_state11bDbg_s   = 0;

  // Parameters
  parameter main11b_0_wt              = 10;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam main11b_0.bIn_w           = main11b_0_bIn_w;
  defparam main11b_0.rx20_w          = main11b_0_rx20_w;
  defparam main11b_0.bOut_w          = main11b_0_bOut_w;
  defparam main11b_0.tx20_w          = main11b_0_tx20_w;
  defparam main11b_0.ssAcqHalt_w     = main11b_0_ssAcqHalt_w;
  defparam main11b_0.ssDetect_w      = main11b_0_ssDetect_w;
  defparam main11b_0.state11b_w      = main11b_0_state11b_w;
  defparam main11b_0.state11b_r      = main11b_0_state11b_r;
  defparam main11b_0.state11b_s      = main11b_0_state11b_s;
  defparam main11b_0.state11bDbg_w   = main11b_0_state11bDbg_w;
  defparam main11b_0.state11bDbg_r   = main11b_0_state11bDbg_r;
  defparam main11b_0.state11bDbg_s   = main11b_0_state11bDbg_s;
  defparam main11b_0.wt              = main11b_0_wt;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_main11b_0_state11b                                         = 0;
  defparam  main11b_0.R_state11b                                         = R_main11b_0_state11b;
  parameter R_main11b_0_state11bDbg                                      = 1;
  defparam  main11b_0.R_state11bDbg                                      = R_main11b_0_state11bDbg;
  parameter R_main11b_0_X16_11b_cmd                                      = 2;
  defparam  main11b_0.R_X16_11b_cmd                                      = R_main11b_0_X16_11b_cmd;
  parameter R_main11b_0_X16_11b_pramAdr                                  = 3;
  defparam  main11b_0.R_X16_11b_pramAdr                                  = R_main11b_0_X16_11b_pramAdr;
  parameter R_main11b_0_X16_11b_pramDat                                  = 4;
  defparam  main11b_0.R_X16_11b_pramDat                                  = R_main11b_0_X16_11b_pramDat;
  parameter R_main11b_0_X16_11b_dramAdr                                  = 5;
  defparam  main11b_0.R_X16_11b_dramAdr                                  = R_main11b_0_X16_11b_dramAdr;
  parameter R_main11b_0_X16_11b_dramDat                                  = 6;
  defparam  main11b_0.R_X16_11b_dramDat                                  = R_main11b_0_X16_11b_dramDat;
  parameter R_main11b_0_irqCtrl_11b_run1                                 = 7;
  defparam  main11b_0.R_irqCtrl_11b_run1                                 = R_main11b_0_irqCtrl_11b_run1;
  parameter R_main11b_0_irqCtrl_11b_irqStat                              = 8;
  defparam  main11b_0.R_irqCtrl_11b_irqStat                              = R_main11b_0_irqCtrl_11b_irqStat;
  parameter R_main11b_0_irqCtrl_11b_irqEdgeLevel                         = 9;
  defparam  main11b_0.R_irqCtrl_11b_irqEdgeLevel                         = R_main11b_0_irqCtrl_11b_irqEdgeLevel;
  parameter R_main11b_0_irqCtrl_11b_irqMaskIn                            = 10;
  defparam  main11b_0.R_irqCtrl_11b_irqMaskIn                            = R_main11b_0_irqCtrl_11b_irqMaskIn;
  parameter R_main11b_0_irqCtrl_11b_irqMaskOut                           = 11;
  defparam  main11b_0.R_irqCtrl_11b_irqMaskOut                           = R_main11b_0_irqCtrl_11b_irqMaskOut;
  parameter R_main11b_0_irqCtrl_11b_irqClr                               = 12;
  defparam  main11b_0.R_irqCtrl_11b_irqClr                               = R_main11b_0_irqCtrl_11b_irqClr;
  parameter R_main11b_0_irqCtrl_11b_irqSet                               = 13;
  defparam  main11b_0.R_irqCtrl_11b_irqSet                               = R_main11b_0_irqCtrl_11b_irqSet;
  parameter R_main11b_0_irqCtrl_11b_irqIdx                               = 14;
  defparam  main11b_0.R_irqCtrl_11b_irqIdx                               = R_main11b_0_irqCtrl_11b_irqIdx;
  parameter R_main11b_0_tx11b_0_run1                                     = 15;
  defparam  main11b_0.R_tx11b_0_run1                                     = R_main11b_0_tx11b_0_run1;
  parameter R_main11b_0_tx11b_0_crc32_0_numBits                          = 16;
  defparam  main11b_0.R_tx11b_0_crc32_0_numBits                          = R_main11b_0_tx11b_0_crc32_0_numBits;
  parameter R_main11b_0_tx11b_0_ppdu11b_0_header                         = 17;
  defparam  main11b_0.R_tx11b_0_ppdu11b_0_header                         = R_main11b_0_tx11b_0_ppdu11b_0_header;
  parameter R_main11b_0_tx11b_0_ppdu11b_0_sfd                            = 18;
  defparam  main11b_0.R_tx11b_0_ppdu11b_0_sfd                            = R_main11b_0_tx11b_0_ppdu11b_0_sfd;
  parameter R_main11b_0_tx11b_0_ppdu11b_0_sigser                         = 19;
  defparam  main11b_0.R_tx11b_0_ppdu11b_0_sigser                         = R_main11b_0_tx11b_0_ppdu11b_0_sigser;
  parameter R_main11b_0_tx11b_0_ppdu11b_0_len                            = 20;
  defparam  main11b_0.R_tx11b_0_ppdu11b_0_len                            = R_main11b_0_tx11b_0_ppdu11b_0_len;
  parameter R_main11b_0_tx11b_0_ppdu11b_0_crc                            = 21;
  defparam  main11b_0.R_tx11b_0_ppdu11b_0_crc                            = R_main11b_0_tx11b_0_ppdu11b_0_crc;
  parameter R_main11b_0_tx11b_0_ppdu11b_0_numBits                        = 22;
  defparam  main11b_0.R_tx11b_0_ppdu11b_0_numBits                        = R_main11b_0_tx11b_0_ppdu11b_0_numBits;
  parameter R_main11b_0_tx11b_0_scrmbl_tx11b_s                           = 23;
  defparam  main11b_0.R_tx11b_0_scrmbl_tx11b_s                           = R_main11b_0_tx11b_0_scrmbl_tx11b_s;
  parameter R_main11b_0_tx11b_0_mod11b_0_mod11bBpsk_0_numBits            = 24;
  defparam  main11b_0.R_tx11b_0_mod11b_0_mod11bBpsk_0_numBits            = R_main11b_0_tx11b_0_mod11b_0_mod11bBpsk_0_numBits;
  parameter R_main11b_0_tx11b_0_mod11b_0_mod11bQpsk_0_numBits            = 25;
  defparam  main11b_0.R_tx11b_0_mod11b_0_mod11bQpsk_0_numBits            = R_main11b_0_tx11b_0_mod11b_0_mod11bQpsk_0_numBits;
  parameter R_main11b_0_tx11b_0_mod11b_0_mod11bCck_0_numBits             = 26;
  defparam  main11b_0.R_tx11b_0_mod11b_0_mod11bCck_0_numBits             = R_main11b_0_tx11b_0_mod11b_0_mod11bCck_0_numBits;
  parameter R_main11b_0_tx11b_0_mod11b_0_mod11bCck_0_mode1               = 27;
  defparam  main11b_0.R_tx11b_0_mod11b_0_mod11bCck_0_mode1               = R_main11b_0_tx11b_0_mod11b_0_mod11bCck_0_mode1;
  parameter R_main11b_0_tx11b_0_mod11b_0_modQpskZero_0_numZeros          = 28;
  defparam  main11b_0.R_tx11b_0_mod11b_0_modQpskZero_0_numZeros          = R_main11b_0_tx11b_0_mod11b_0_modQpskZero_0_numZeros;
  parameter R_main11b_0_tx11b_0_src11to20_0_lut_cf11bTx_wrAdr            = 29;
  defparam  main11b_0.R_tx11b_0_src11to20_0_lut_cf11bTx_wrAdr            = R_main11b_0_tx11b_0_src11to20_0_lut_cf11bTx_wrAdr;
  parameter R_main11b_0_tx11b_0_src11to20_0_lut_cf11bTx_wrDatHi          = 30;
  defparam  main11b_0.R_tx11b_0_src11to20_0_lut_cf11bTx_wrDatHi          = R_main11b_0_tx11b_0_src11to20_0_lut_cf11bTx_wrDatHi;
  parameter R_main11b_0_tx11b_0_src11to20_0_lut_cf11bTx_wrDatLo          = 31;
  defparam  main11b_0.R_tx11b_0_src11to20_0_lut_cf11bTx_wrDatLo          = R_main11b_0_tx11b_0_src11to20_0_lut_cf11bTx_wrDatLo;
  parameter R_main11b_0_tx11b_0_src11to20_0_lut_cf11bTx_simInit          = 32;
  defparam  main11b_0.R_tx11b_0_src11to20_0_lut_cf11bTx_simInit          = R_main11b_0_tx11b_0_src11to20_0_lut_cf11bTx_simInit;

  parameter R_main11b_0_bridge_11b_fifoMst                               = 33;
  defparam  main11b_0.R_bridge_11b_fifoMst                               = R_main11b_0_bridge_11b_fifoMst;
  parameter R_main11b_0_bridge_11b_ctrlMst                               = 34;
  defparam  main11b_0.R_bridge_11b_ctrlMst                               = R_main11b_0_bridge_11b_ctrlMst;
  parameter R_main11b_0_bridge_11b_fifoSlv                               = 35;
  defparam  main11b_0.R_bridge_11b_fifoSlv                               = R_main11b_0_bridge_11b_fifoSlv;
  parameter R_main11b_0_bridge_11b_ctrlSlv                               = 36;
  defparam  main11b_0.R_bridge_11b_ctrlSlv                               = R_main11b_0_bridge_11b_ctrlSlv;

  // FIFO address definitions - might be overwritten by an upper module
  parameter R_main11b_0_tx11b_0_ffMod2Src                                = 37;
  defparam  main11b_0.R_tx11b_0_ffMod2Src                                = R_main11b_0_tx11b_0_ffMod2Src;

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire              [main11b_0_bOut_w-1:0]  main11b_0_bOut;
  wire                                      main11b_0_bOut_or;
  wire                                      main11b_0_bOut_ff;
  wire                                      main11b_0_bOut_we;

  wire              [main11b_0_tx20_w-1:0]  main11b_0_tx20;
  wire                                      main11b_0_tx20_or;
  wire                                      main11b_0_tx20_ff;
  wire                                      main11b_0_tx20_we;

  wire               [main11b_0_bIn_w-1:0]  main11b_0_bIn;
  wire                                      main11b_0_bIn_ir;
  wire                                      main11b_0_bIn_fe;
  wire                                      main11b_0_bIn_re;

  wire              [main11b_0_rx20_w-1:0]  main11b_0_rx20;
  wire                                      main11b_0_rx20_ir;
  wire                                      main11b_0_rx20_fe;
  wire                                      main11b_0_rx20_re;

  wire          [main11b_0_ssDetect_w-1:0]  main11b_0_ssDetect;

  wire         [main11b_0_ssAcqHalt_w-1:0]  main11b_0_ssAcqHalt;

  wire                                      main11b_0_irq_bridge_11b;
  wire                                      main11b_0_regWe;
  wire                                      main11b_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  main11b main11b_0(main11b_0_bOut, main11b_0_bOut_or, main11b_0_bOut_ff, main11b_0_bOut_we,
                    main11b_0_tx20, main11b_0_tx20_or, main11b_0_tx20_ff, main11b_0_tx20_we,
                    main11b_0_bIn, main11b_0_bIn_ir, main11b_0_bIn_fe, main11b_0_bIn_re, 
                    main11b_0_rx20, main11b_0_rx20_ir, main11b_0_rx20_fe, main11b_0_rx20_re, 
                    main11b_0_ssDetect, 
                    main11b_0_ssAcqHalt, 
                    main11b_0_irq_bridge_11b, 
                    regBus, regWe, regRe, main11b_0_regWe, main11b_0_regRe, clk, clk2, reset);


//==============================================================================
