//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter main11a_0_bIn_w           = 8;
  parameter main11a_0_rx20_w          = 20;

  // Outputs
  parameter main11a_0_bOut_w          = 8;
  parameter main11a_0_tx20_w          = 20;
  parameter main11a_0_yAcqCor_w       = 8;
  parameter main11a_0_yAcqAbs_w       = 8;
  parameter main11a_0_yAcqPh_w        = 8;
  parameter main11a_0_ySyncAbs_w      = 9;
  parameter main11a_0_ySyncC_w        = 26;
  parameter main11a_0_ySyncSh_w       = 9;
  parameter main11a_0_yDemD_w         = 11;
  parameter main11a_0_yDemSb_w        = 22;
  parameter main11a_0_yDecSb_w        = 8;
  parameter main11a_0_yDecSb2_w       = 8;
  parameter main11a_0_yDecVit_w       = 8;

  // Input control lines
  parameter main11a_0_ssAcqHalt_w     = 1;

  // Output control lines
  parameter main11a_0_ssDetect_w      = 1;

  // Eregs
  parameter main11a_0_txRxSel_w       = 1;
  parameter main11a_0_txRxSel_r       = 0;
  parameter main11a_0_txRxSel_s       = 0;
  parameter main11a_0_state11a_w      = 8;
  parameter main11a_0_state11a_r      = 0;
  parameter main11a_0_state11a_s      = 0;
  parameter main11a_0_state11aDbg_w   = 8;
  parameter main11a_0_state11aDbg_r   = 0;
  parameter main11a_0_state11aDbg_s   = 0;

  // Parameters
  parameter main11a_0_wt              = 10;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam main11a_0.bIn_w           = main11a_0_bIn_w;
  defparam main11a_0.rx20_w          = main11a_0_rx20_w;
  defparam main11a_0.bOut_w          = main11a_0_bOut_w;
  defparam main11a_0.tx20_w          = main11a_0_tx20_w;
  defparam main11a_0.yAcqCor_w       = main11a_0_yAcqCor_w;
  defparam main11a_0.yAcqAbs_w       = main11a_0_yAcqAbs_w;
  defparam main11a_0.yAcqPh_w        = main11a_0_yAcqPh_w;
  defparam main11a_0.ySyncAbs_w      = main11a_0_ySyncAbs_w;
  defparam main11a_0.ySyncC_w        = main11a_0_ySyncC_w;
  defparam main11a_0.ySyncSh_w       = main11a_0_ySyncSh_w;
  defparam main11a_0.yDemD_w         = main11a_0_yDemD_w;
  defparam main11a_0.yDemSb_w        = main11a_0_yDemSb_w;
  defparam main11a_0.yDecSb_w        = main11a_0_yDecSb_w;
  defparam main11a_0.yDecSb2_w       = main11a_0_yDecSb2_w;
  defparam main11a_0.yDecVit_w       = main11a_0_yDecVit_w;
  defparam main11a_0.ssAcqHalt_w     = main11a_0_ssAcqHalt_w;
  defparam main11a_0.ssDetect_w      = main11a_0_ssDetect_w;
  defparam main11a_0.txRxSel_w       = main11a_0_txRxSel_w;
  defparam main11a_0.txRxSel_r       = main11a_0_txRxSel_r;
  defparam main11a_0.txRxSel_s       = main11a_0_txRxSel_s;
  defparam main11a_0.state11a_w      = main11a_0_state11a_w;
  defparam main11a_0.state11a_r      = main11a_0_state11a_r;
  defparam main11a_0.state11a_s      = main11a_0_state11a_s;
  defparam main11a_0.state11aDbg_w   = main11a_0_state11aDbg_w;
  defparam main11a_0.state11aDbg_r   = main11a_0_state11aDbg_r;
  defparam main11a_0.state11aDbg_s   = main11a_0_state11aDbg_s;
  defparam main11a_0.wt              = main11a_0_wt;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_main11a_0_txRxSel                                          = 0;
  defparam  main11a_0.R_txRxSel                                          = R_main11a_0_txRxSel;
  parameter R_main11a_0_state11a                                         = 1;
  defparam  main11a_0.R_state11a                                         = R_main11a_0_state11a;
  parameter R_main11a_0_state11aDbg                                      = 2;
  defparam  main11a_0.R_state11aDbg                                      = R_main11a_0_state11aDbg;
  parameter R_main11a_0_X16_11a_cmd                                      = 3;
  defparam  main11a_0.R_X16_11a_cmd                                      = R_main11a_0_X16_11a_cmd;
  parameter R_main11a_0_X16_11a_pramAdr                                  = 4;
  defparam  main11a_0.R_X16_11a_pramAdr                                  = R_main11a_0_X16_11a_pramAdr;
  parameter R_main11a_0_X16_11a_pramDat                                  = 5;
  defparam  main11a_0.R_X16_11a_pramDat                                  = R_main11a_0_X16_11a_pramDat;
  parameter R_main11a_0_X16_11a_dramAdr                                  = 6;
  defparam  main11a_0.R_X16_11a_dramAdr                                  = R_main11a_0_X16_11a_dramAdr;
  parameter R_main11a_0_X16_11a_dramDat                                  = 7;
  defparam  main11a_0.R_X16_11a_dramDat                                  = R_main11a_0_X16_11a_dramDat;
  parameter R_main11a_0_irqCtrl_11a_run1                                 = 8;
  defparam  main11a_0.R_irqCtrl_11a_run1                                 = R_main11a_0_irqCtrl_11a_run1;
  parameter R_main11a_0_irqCtrl_11a_irqStat                              = 9;
  defparam  main11a_0.R_irqCtrl_11a_irqStat                              = R_main11a_0_irqCtrl_11a_irqStat;
  parameter R_main11a_0_irqCtrl_11a_irqEdgeLevel                         = 10;
  defparam  main11a_0.R_irqCtrl_11a_irqEdgeLevel                         = R_main11a_0_irqCtrl_11a_irqEdgeLevel;
  parameter R_main11a_0_irqCtrl_11a_irqMaskIn                            = 11;
  defparam  main11a_0.R_irqCtrl_11a_irqMaskIn                            = R_main11a_0_irqCtrl_11a_irqMaskIn;
  parameter R_main11a_0_irqCtrl_11a_irqMaskOut                           = 12;
  defparam  main11a_0.R_irqCtrl_11a_irqMaskOut                           = R_main11a_0_irqCtrl_11a_irqMaskOut;
  parameter R_main11a_0_irqCtrl_11a_irqClr                               = 13;
  defparam  main11a_0.R_irqCtrl_11a_irqClr                               = R_main11a_0_irqCtrl_11a_irqClr;
  parameter R_main11a_0_irqCtrl_11a_irqSet                               = 14;
  defparam  main11a_0.R_irqCtrl_11a_irqSet                               = R_main11a_0_irqCtrl_11a_irqSet;
  parameter R_main11a_0_irqCtrl_11a_irqIdx                               = 15;
  defparam  main11a_0.R_irqCtrl_11a_irqIdx                               = R_main11a_0_irqCtrl_11a_irqIdx;
  parameter R_main11a_0_tx11a_0_enc11a_0_run1                            = 16;
  defparam  main11a_0.R_tx11a_0_enc11a_0_run1                            = R_main11a_0_tx11a_0_enc11a_0_run1;
  parameter R_main11a_0_tx11a_0_enc11a_0_crc32_0_numBits                 = 17;
  defparam  main11a_0.R_tx11a_0_enc11a_0_crc32_0_numBits                 = R_main11a_0_tx11a_0_enc11a_0_crc32_0_numBits;
  parameter R_main11a_0_tx11a_0_enc11a_0_ppdu11a_0_plcpHdr0              = 18;
  defparam  main11a_0.R_tx11a_0_enc11a_0_ppdu11a_0_plcpHdr0              = R_main11a_0_tx11a_0_enc11a_0_ppdu11a_0_plcpHdr0;
  parameter R_main11a_0_tx11a_0_enc11a_0_ppdu11a_0_plcpHdr1              = 19;
  defparam  main11a_0.R_tx11a_0_enc11a_0_ppdu11a_0_plcpHdr1              = R_main11a_0_tx11a_0_enc11a_0_ppdu11a_0_plcpHdr1;
  parameter R_main11a_0_tx11a_0_enc11a_0_ppdu11a_0_numByte               = 20;
  defparam  main11a_0.R_tx11a_0_enc11a_0_ppdu11a_0_numByte               = R_main11a_0_tx11a_0_enc11a_0_ppdu11a_0_numByte;
  parameter R_main11a_0_tx11a_0_enc11a_0_ppdu11a_0_numPadBit             = 21;
  defparam  main11a_0.R_tx11a_0_enc11a_0_ppdu11a_0_numPadBit             = R_main11a_0_tx11a_0_enc11a_0_ppdu11a_0_numPadBit;
  parameter R_main11a_0_tx11a_0_enc11a_0_scrmbl_0_s                      = 22;
  defparam  main11a_0.R_tx11a_0_enc11a_0_scrmbl_0_s                      = R_main11a_0_tx11a_0_enc11a_0_scrmbl_0_s;
  parameter R_main11a_0_tx11a_0_enc11a_0_punct_0_run1                    = 23;
  defparam  main11a_0.R_tx11a_0_enc11a_0_punct_0_run1                    = R_main11a_0_tx11a_0_enc11a_0_punct_0_run1;
  parameter R_main11a_0_tx11a_0_mod11a_0_run1                            = 24;
  defparam  main11a_0.R_tx11a_0_mod11a_0_run1                            = R_main11a_0_tx11a_0_mod11a_0_run1;
  parameter R_main11a_0_tx11a_0_mod11a_0_intlv_0_mode1                   = 25;
  defparam  main11a_0.R_tx11a_0_mod11a_0_intlv_0_mode1                   = R_main11a_0_tx11a_0_mod11a_0_intlv_0_mode1;
  parameter R_main11a_0_tx11a_0_mod11a_0_qamMod_0_mode1                  = 26;
  defparam  main11a_0.R_tx11a_0_mod11a_0_qamMod_0_mode1                  = R_main11a_0_tx11a_0_mod11a_0_qamMod_0_mode1;
  parameter R_main11a_0_tx11a_0_mod11a_0_shortSym_0_numOfdm              = 27;
  defparam  main11a_0.R_tx11a_0_mod11a_0_shortSym_0_numOfdm              = R_main11a_0_tx11a_0_mod11a_0_shortSym_0_numOfdm;
  parameter R_main11a_0_rx11a_0_runAcqBuf                                = 28;
  defparam  main11a_0.R_rx11a_0_runAcqBuf                                = R_main11a_0_rx11a_0_runAcqBuf;
  parameter R_main11a_0_rx11a_0_bufNormRot_0_numOut                      = 29;
  defparam  main11a_0.R_rx11a_0_bufNormRot_0_numOut                      = R_main11a_0_rx11a_0_bufNormRot_0_numOut;
  parameter R_main11a_0_rx11a_0_bufNormRot_0_runOut                      = 30;
  defparam  main11a_0.R_rx11a_0_bufNormRot_0_runOut                      = R_main11a_0_rx11a_0_bufNormRot_0_runOut;
  parameter R_main11a_0_rx11a_0_bufNormRot_0_fftWrap                     = 31;
  defparam  main11a_0.R_rx11a_0_bufNormRot_0_fftWrap                     = R_main11a_0_rx11a_0_bufNormRot_0_fftWrap;
  parameter R_main11a_0_rx11a_0_bufNormRot_0_rxBuf_0_wrAdr               = 32;
  defparam  main11a_0.R_rx11a_0_bufNormRot_0_rxBuf_0_wrAdr               = R_main11a_0_rx11a_0_bufNormRot_0_rxBuf_0_wrAdr;
  parameter R_main11a_0_rx11a_0_bufNormRot_0_rxBuf_0_rdAdr0              = 33;
  defparam  main11a_0.R_rx11a_0_bufNormRot_0_rxBuf_0_rdAdr0              = R_main11a_0_rx11a_0_bufNormRot_0_rxBuf_0_rdAdr0;
  parameter R_main11a_0_rx11a_0_bufNormRot_0_rxBuf_0_irqAdr              = 34;
  defparam  main11a_0.R_rx11a_0_bufNormRot_0_rxBuf_0_irqAdr              = R_main11a_0_rx11a_0_bufNormRot_0_rxBuf_0_irqAdr;
  parameter R_main11a_0_rx11a_0_bufNormRot_0_rxBuf_0_agcDoneAdr          = 35;
  defparam  main11a_0.R_rx11a_0_bufNormRot_0_rxBuf_0_agcDoneAdr          = R_main11a_0_rx11a_0_bufNormRot_0_rxBuf_0_agcDoneAdr;
  parameter R_main11a_0_rx11a_0_bufNormRot_0_normX_0_amp                 = 36;
  defparam  main11a_0.R_rx11a_0_bufNormRot_0_normX_0_amp                 = R_main11a_0_rx11a_0_bufNormRot_0_normX_0_amp;
  parameter R_main11a_0_rx11a_0_bufNormRot_0_cordicRot_0_ph              = 37;
  defparam  main11a_0.R_rx11a_0_bufNormRot_0_cordicRot_0_ph              = R_main11a_0_rx11a_0_bufNormRot_0_cordicRot_0_ph;
  parameter R_main11a_0_rx11a_0_bufNormRot_0_cordicRot_0_dph             = 38;
  defparam  main11a_0.R_rx11a_0_bufNormRot_0_cordicRot_0_dph             = R_main11a_0_rx11a_0_bufNormRot_0_cordicRot_0_dph;
  parameter R_main11a_0_rx11a_0_acq11a_0_freqOff                         = 39;
  defparam  main11a_0.R_rx11a_0_acq11a_0_freqOff                         = R_main11a_0_rx11a_0_acq11a_0_freqOff;
  parameter R_main11a_0_rx11a_0_acq11a_0_timeOff                         = 40;
  defparam  main11a_0.R_rx11a_0_acq11a_0_timeOff                         = R_main11a_0_rx11a_0_acq11a_0_timeOff;
  parameter R_main11a_0_rx11a_0_acq11a_0_ampEst                          = 41;
  defparam  main11a_0.R_rx11a_0_acq11a_0_ampEst                          = R_main11a_0_rx11a_0_acq11a_0_ampEst;
  parameter R_main11a_0_rx11a_0_acq11a_0_ssNorm_0_cutN_20c4_numCut       = 42;
  defparam  main11a_0.R_rx11a_0_acq11a_0_ssNorm_0_cutN_20c4_numCut       = R_main11a_0_rx11a_0_acq11a_0_ssNorm_0_cutN_20c4_numCut;
  parameter R_main11a_0_rx11a_0_acq11a_0_ssCcfAvgDet_0_thr2              = 43;
  defparam  main11a_0.R_rx11a_0_acq11a_0_ssCcfAvgDet_0_thr2              = R_main11a_0_rx11a_0_acq11a_0_ssCcfAvgDet_0_thr2;
  parameter R_main11a_0_rx11a_0_acq11a_0_ssCcfAvgDet_0_thr3              = 44;
  defparam  main11a_0.R_rx11a_0_acq11a_0_ssCcfAvgDet_0_thr3              = R_main11a_0_rx11a_0_acq11a_0_ssCcfAvgDet_0_thr3;
  parameter R_main11a_0_rx11a_0_acq11a_0_ssCcfAvgDet_0_thr4              = 45;
  defparam  main11a_0.R_rx11a_0_acq11a_0_ssCcfAvgDet_0_thr4              = R_main11a_0_rx11a_0_acq11a_0_ssCcfAvgDet_0_thr4;
  parameter R_main11a_0_rx11a_0_acq11a_0_ctfe_0_ctfeCordic_0_thr         = 46;
  defparam  main11a_0.R_rx11a_0_acq11a_0_ctfe_0_ctfeCordic_0_thr         = R_main11a_0_rx11a_0_acq11a_0_ctfe_0_ctfeCordic_0_thr;
  parameter R_main11a_0_rx11a_0_sync11a_0_run1                           = 47;
  defparam  main11a_0.R_rx11a_0_sync11a_0_run1                           = R_main11a_0_rx11a_0_sync11a_0_run1;
  parameter R_main11a_0_rx11a_0_sync11a_0_lsCcf_0_peakPos                = 48;
  defparam  main11a_0.R_rx11a_0_sync11a_0_lsCcf_0_peakPos                = R_main11a_0_rx11a_0_sync11a_0_lsCcf_0_peakPos;
  parameter R_main11a_0_rx11a_0_sync11a_0_lsCcf_0_peakVal                = 49;
  defparam  main11a_0.R_rx11a_0_sync11a_0_lsCcf_0_peakVal                = R_main11a_0_rx11a_0_sync11a_0_lsCcf_0_peakVal;
  parameter R_main11a_0_rx11a_0_sync11a_0_cxMulAvg_0_numSmpl             = 50;
  defparam  main11a_0.R_rx11a_0_sync11a_0_cxMulAvg_0_numSmpl             = R_main11a_0_rx11a_0_sync11a_0_cxMulAvg_0_numSmpl;
  parameter R_main11a_0_rx11a_0_sync11a_0_cxMulAvg_0_yReLo               = 51;
  defparam  main11a_0.R_rx11a_0_sync11a_0_cxMulAvg_0_yReLo               = R_main11a_0_rx11a_0_sync11a_0_cxMulAvg_0_yReLo;
  parameter R_main11a_0_rx11a_0_sync11a_0_cxMulAvg_0_yImHi               = 52;
  defparam  main11a_0.R_rx11a_0_sync11a_0_cxMulAvg_0_yImHi               = R_main11a_0_rx11a_0_sync11a_0_cxMulAvg_0_yImHi;
  parameter R_main11a_0_rx11a_0_dem11a_0_run1                            = 53;
  defparam  main11a_0.R_rx11a_0_dem11a_0_run1                            = R_main11a_0_rx11a_0_dem11a_0_run1;
  parameter R_main11a_0_rx11a_0_dem11a_0_ttCordic_0_run1                 = 54;
  defparam  main11a_0.R_rx11a_0_dem11a_0_ttCordic_0_run1                 = R_main11a_0_rx11a_0_dem11a_0_ttCordic_0_run1;
  parameter R_main11a_0_rx11a_0_dem11a_0_ttCordic_0_ph                   = 55;
  defparam  main11a_0.R_rx11a_0_dem11a_0_ttCordic_0_ph                   = R_main11a_0_rx11a_0_dem11a_0_ttCordic_0_ph;
  parameter R_main11a_0_rx11a_0_dem11a_0_ttCordic_0_dph3                 = 56;
  defparam  main11a_0.R_rx11a_0_dem11a_0_ttCordic_0_dph3                 = R_main11a_0_rx11a_0_dem11a_0_ttCordic_0_dph3;
  parameter R_main11a_0_rx11a_0_dem11a_0_ttCordic_0_dph4                 = 57;
  defparam  main11a_0.R_rx11a_0_dem11a_0_ttCordic_0_dph4                 = R_main11a_0_rx11a_0_dem11a_0_ttCordic_0_dph4;
  parameter R_main11a_0_rx11a_0_dem11a_0_ttCordic_0_dphM49               = 58;
  defparam  main11a_0.R_rx11a_0_dem11a_0_ttCordic_0_dphM49               = R_main11a_0_rx11a_0_dem11a_0_ttCordic_0_dphM49;
  parameter R_main11a_0_rx11a_0_dem11a_0_ttCordic_0_dph14                = 59;
  defparam  main11a_0.R_rx11a_0_dem11a_0_ttCordic_0_dph14                = R_main11a_0_rx11a_0_dem11a_0_ttCordic_0_dph14;
  parameter R_main11a_0_rx11a_0_dem11a_0_pltExt_0_pltSumRe               = 60;
  defparam  main11a_0.R_rx11a_0_dem11a_0_pltExt_0_pltSumRe               = R_main11a_0_rx11a_0_dem11a_0_pltExt_0_pltSumRe;
  parameter R_main11a_0_rx11a_0_dem11a_0_pltExt_0_pltSumIm               = 61;
  defparam  main11a_0.R_rx11a_0_dem11a_0_pltExt_0_pltSumIm               = R_main11a_0_rx11a_0_dem11a_0_pltExt_0_pltSumIm;
  parameter R_main11a_0_rx11a_0_dec11a_0_run1                            = 62;
  defparam  main11a_0.R_rx11a_0_dec11a_0_run1                            = R_main11a_0_rx11a_0_dec11a_0_run1;
  parameter R_main11a_0_rx11a_0_dec11a_0_deIntlv_0_mode1                 = 63;
  defparam  main11a_0.R_rx11a_0_dec11a_0_deIntlv_0_mode1                 = R_main11a_0_rx11a_0_dec11a_0_deIntlv_0_mode1;
  parameter R_main11a_0_rx11a_0_dec11a_0_dePunct_0_run1                  = 64;
  defparam  main11a_0.R_rx11a_0_dec11a_0_dePunct_0_run1                  = R_main11a_0_rx11a_0_dec11a_0_dePunct_0_run1;
  parameter R_main11a_0_rx11a_0_dec11a_0_vitMain_0_run1                  = 65;
  defparam  main11a_0.R_rx11a_0_dec11a_0_vitMain_0_run1                  = R_main11a_0_rx11a_0_dec11a_0_vitMain_0_run1;
  parameter R_main11a_0_rx11a_0_dec11a_0_vitMain_0_numBits               = 66;
  defparam  main11a_0.R_rx11a_0_dec11a_0_vitMain_0_numBits               = R_main11a_0_rx11a_0_dec11a_0_vitMain_0_numBits;
  parameter R_main11a_0_rx11a_0_dec11a_0_vitMain_0_rxMode                = 67;
  defparam  main11a_0.R_rx11a_0_dec11a_0_vitMain_0_rxMode                = R_main11a_0_rx11a_0_dec11a_0_vitMain_0_rxMode;
  parameter R_main11a_0_rx11a_0_dec11a_0_vitMain_0_rxLen                 = 68;
  defparam  main11a_0.R_rx11a_0_dec11a_0_vitMain_0_rxLen                 = R_main11a_0_rx11a_0_dec11a_0_vitMain_0_rxLen;
  parameter R_main11a_0_rx11a_0_dec11a_0_vitMain_0_pm00                  = 69;
  defparam  main11a_0.R_rx11a_0_dec11a_0_vitMain_0_pm00                  = R_main11a_0_rx11a_0_dec11a_0_vitMain_0_pm00;
  parameter R_main11a_0_rx11a_0_dec11a_0_crc32x8_0_numBytes              = 70;
  defparam  main11a_0.R_rx11a_0_dec11a_0_crc32x8_0_numBytes              = R_main11a_0_rx11a_0_dec11a_0_crc32x8_0_numBytes;
  parameter R_main11a_0_rx11a_0_dec11a_0_crc32x8_0_crcRes                = 71;
  defparam  main11a_0.R_rx11a_0_dec11a_0_crc32x8_0_crcRes                = R_main11a_0_rx11a_0_dec11a_0_crc32x8_0_crcRes;
  parameter R_main11a_0_cordicR2P_0_run1                                 = 72;
  defparam  main11a_0.R_cordicR2P_0_run1                                 = R_main11a_0_cordicR2P_0_run1;
  parameter R_main11a_0_cordicR2P_0_numIt                                = 73;
  defparam  main11a_0.R_cordicR2P_0_numIt                                = R_main11a_0_cordicR2P_0_numIt;
  parameter R_main11a_0_cordicR2P_0_xReAbs                               = 74;
  defparam  main11a_0.R_cordicR2P_0_xReAbs                               = R_main11a_0_cordicR2P_0_xReAbs;
  parameter R_main11a_0_cordicR2P_0_xImPh                                = 75;
  defparam  main11a_0.R_cordicR2P_0_xImPh                                = R_main11a_0_cordicR2P_0_xImPh;
  parameter R_main11a_0_cordicR2P_0_thr                                  = 76;
  defparam  main11a_0.R_cordicR2P_0_thr                                  = R_main11a_0_cordicR2P_0_thr;
  parameter R_main11a_0_sqrtX_0_run1                                     = 77;
  defparam  main11a_0.R_sqrtX_0_run1                                     = R_main11a_0_sqrtX_0_run1;
  parameter R_main11a_0_sqrtX_0_xy                                       = 78;
  defparam  main11a_0.R_sqrtX_0_xy                                       = R_main11a_0_sqrtX_0_xy;
  parameter R_main11a_0_fft64_0_run1                                     = 79;
  defparam  main11a_0.R_fft64_0_run1                                     = R_main11a_0_fft64_0_run1;
  parameter R_main11a_0_fft64_0_tglMode                                  = 80;
  defparam  main11a_0.R_fft64_0_tglMode                                  = R_main11a_0_fft64_0_tglMode;
  parameter R_main11a_0_fft64_0_inpOrd                                   = 81;
  defparam  main11a_0.R_fft64_0_inpOrd                                   = R_main11a_0_fft64_0_inpOrd;
  parameter R_main11a_0_fft64_0_outpOrd                                  = 82;
  defparam  main11a_0.R_fft64_0_outpOrd                                  = R_main11a_0_fft64_0_outpOrd;

  parameter R_main11a_0_bridge_11a_fifoMst                               = 83;
  defparam  main11a_0.R_bridge_11a_fifoMst                               = R_main11a_0_bridge_11a_fifoMst;
  parameter R_main11a_0_bridge_11a_ctrlMst                               = 84;
  defparam  main11a_0.R_bridge_11a_ctrlMst                               = R_main11a_0_bridge_11a_ctrlMst;
  parameter R_main11a_0_bridge_11a_fifoSlv                               = 85;
  defparam  main11a_0.R_bridge_11a_fifoSlv                               = R_main11a_0_bridge_11a_fifoSlv;
  parameter R_main11a_0_bridge_11a_ctrlSlv                               = 86;
  defparam  main11a_0.R_bridge_11a_ctrlSlv                               = R_main11a_0_bridge_11a_ctrlSlv;

  // FIFO address definitions - might be overwritten by an upper module
  parameter R_main11a_0_tx11a_0_mod11a_0_qam2lpd                         = 87;
  defparam  main11a_0.R_tx11a_0_mod11a_0_qam2lpd                         = R_main11a_0_tx11a_0_mod11a_0_qam2lpd;
  parameter R_main11a_0_rx11a_0_acq11a_0_ssNorm_0_ffIn                   = 88;
  defparam  main11a_0.R_rx11a_0_acq11a_0_ssNorm_0_ffIn                   = R_main11a_0_rx11a_0_acq11a_0_ssNorm_0_ffIn;
  parameter R_main11a_0_rx11a_0_dem11a_0_ffIn                            = 89;
  defparam  main11a_0.R_rx11a_0_dem11a_0_ffIn                            = R_main11a_0_rx11a_0_dem11a_0_ffIn;
  parameter R_main11a_0_rx11a_0_dec11a_0_ffD2D                           = 90;
  defparam  main11a_0.R_rx11a_0_dec11a_0_ffD2D                           = R_main11a_0_rx11a_0_dec11a_0_ffD2D;

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire              [main11a_0_bOut_w-1:0]  main11a_0_bOut;
  wire                                      main11a_0_bOut_or;
  wire                                      main11a_0_bOut_ff;
  wire                                      main11a_0_bOut_we;

  wire              [main11a_0_tx20_w-1:0]  main11a_0_tx20;
  wire                                      main11a_0_tx20_or;
  wire                                      main11a_0_tx20_ff;
  wire                                      main11a_0_tx20_we;

  wire           [main11a_0_yAcqCor_w-1:0]  main11a_0_yAcqCor;
  wire                                      main11a_0_yAcqCor_or;
  wire                                      main11a_0_yAcqCor_ff;
  wire                                      main11a_0_yAcqCor_we;

  wire           [main11a_0_yAcqAbs_w-1:0]  main11a_0_yAcqAbs;
  wire                                      main11a_0_yAcqAbs_or;
  wire                                      main11a_0_yAcqAbs_ff;
  wire                                      main11a_0_yAcqAbs_we;

  wire            [main11a_0_yAcqPh_w-1:0]  main11a_0_yAcqPh;
  wire                                      main11a_0_yAcqPh_or;
  wire                                      main11a_0_yAcqPh_ff;
  wire                                      main11a_0_yAcqPh_we;

  wire          [main11a_0_ySyncAbs_w-1:0]  main11a_0_ySyncAbs;
  wire                                      main11a_0_ySyncAbs_or;
  wire                                      main11a_0_ySyncAbs_ff;
  wire                                      main11a_0_ySyncAbs_we;

  wire            [main11a_0_ySyncC_w-1:0]  main11a_0_ySyncC;
  wire                                      main11a_0_ySyncC_or;
  wire                                      main11a_0_ySyncC_ff;
  wire                                      main11a_0_ySyncC_we;

  wire           [main11a_0_ySyncSh_w-1:0]  main11a_0_ySyncSh;
  wire                                      main11a_0_ySyncSh_or;
  wire                                      main11a_0_ySyncSh_ff;
  wire                                      main11a_0_ySyncSh_we;

  wire             [main11a_0_yDemD_w-1:0]  main11a_0_yDemD;
  wire                                      main11a_0_yDemD_or;
  wire                                      main11a_0_yDemD_ff;
  wire                                      main11a_0_yDemD_we;

  wire            [main11a_0_yDemSb_w-1:0]  main11a_0_yDemSb;
  wire                                      main11a_0_yDemSb_or;
  wire                                      main11a_0_yDemSb_ff;
  wire                                      main11a_0_yDemSb_we;

  wire            [main11a_0_yDecSb_w-1:0]  main11a_0_yDecSb;
  wire                                      main11a_0_yDecSb_or;
  wire                                      main11a_0_yDecSb_ff;
  wire                                      main11a_0_yDecSb_we;

  wire           [main11a_0_yDecSb2_w-1:0]  main11a_0_yDecSb2;
  wire                                      main11a_0_yDecSb2_or;
  wire                                      main11a_0_yDecSb2_ff;
  wire                                      main11a_0_yDecSb2_we;

  wire           [main11a_0_yDecVit_w-1:0]  main11a_0_yDecVit;
  wire                                      main11a_0_yDecVit_or;
  wire                                      main11a_0_yDecVit_ff;
  wire                                      main11a_0_yDecVit_we;

  wire               [main11a_0_bIn_w-1:0]  main11a_0_bIn;
  wire                                      main11a_0_bIn_ir;
  wire                                      main11a_0_bIn_fe;
  wire                                      main11a_0_bIn_re;

  wire              [main11a_0_rx20_w-1:0]  main11a_0_rx20;
  wire                                      main11a_0_rx20_ir;
  wire                                      main11a_0_rx20_fe;
  wire                                      main11a_0_rx20_re;

  wire          [main11a_0_ssDetect_w-1:0]  main11a_0_ssDetect;

  wire         [main11a_0_ssAcqHalt_w-1:0]  main11a_0_ssAcqHalt;

  wire                                      main11a_0_irq_bridge_11a;
  wire                                      main11a_0_regWe;
  wire                                      main11a_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  main11a main11a_0(main11a_0_bOut, main11a_0_bOut_or, main11a_0_bOut_ff, main11a_0_bOut_we,
                    main11a_0_tx20, main11a_0_tx20_or, main11a_0_tx20_ff, main11a_0_tx20_we,
                    main11a_0_yAcqCor, main11a_0_yAcqCor_or, main11a_0_yAcqCor_ff, main11a_0_yAcqCor_we,
                    main11a_0_yAcqAbs, main11a_0_yAcqAbs_or, main11a_0_yAcqAbs_ff, main11a_0_yAcqAbs_we,
                    main11a_0_yAcqPh, main11a_0_yAcqPh_or, main11a_0_yAcqPh_ff, main11a_0_yAcqPh_we,
                    main11a_0_ySyncAbs, main11a_0_ySyncAbs_or, main11a_0_ySyncAbs_ff, main11a_0_ySyncAbs_we,
                    main11a_0_ySyncC, main11a_0_ySyncC_or, main11a_0_ySyncC_ff, main11a_0_ySyncC_we,
                    main11a_0_ySyncSh, main11a_0_ySyncSh_or, main11a_0_ySyncSh_ff, main11a_0_ySyncSh_we,
                    main11a_0_yDemD, main11a_0_yDemD_or, main11a_0_yDemD_ff, main11a_0_yDemD_we,
                    main11a_0_yDemSb, main11a_0_yDemSb_or, main11a_0_yDemSb_ff, main11a_0_yDemSb_we,
                    main11a_0_yDecSb, main11a_0_yDecSb_or, main11a_0_yDecSb_ff, main11a_0_yDecSb_we,
                    main11a_0_yDecSb2, main11a_0_yDecSb2_or, main11a_0_yDecSb2_ff, main11a_0_yDecSb2_we,
                    main11a_0_yDecVit, main11a_0_yDecVit_or, main11a_0_yDecVit_ff, main11a_0_yDecVit_we,
                    main11a_0_bIn, main11a_0_bIn_ir, main11a_0_bIn_fe, main11a_0_bIn_re, 
                    main11a_0_rx20, main11a_0_rx20_ir, main11a_0_rx20_fe, main11a_0_rx20_re, 
                    main11a_0_ssDetect, 
                    main11a_0_ssAcqHalt, 
                    main11a_0_irq_bridge_11a, 
                    regBus, regWe, regRe, main11a_0_regWe, main11a_0_regRe, clk, clk2, reset);


//==============================================================================
