//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   main11a
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module main11a(bOut, bOut_or, bOut_ff, bOut_we, 
               tx20, tx20_or, tx20_ff, tx20_we, 
               yAcqCor, yAcqCor_or, yAcqCor_ff, yAcqCor_we, 
               yAcqAbs, yAcqAbs_or, yAcqAbs_ff, yAcqAbs_we, 
               yAcqPh, yAcqPh_or, yAcqPh_ff, yAcqPh_we, 
               ySyncAbs, ySyncAbs_or, ySyncAbs_ff, ySyncAbs_we, 
               ySyncC, ySyncC_or, ySyncC_ff, ySyncC_we, 
               ySyncSh, ySyncSh_or, ySyncSh_ff, ySyncSh_we, 
               yDemD, yDemD_or, yDemD_ff, yDemD_we, 
               yDemSb, yDemSb_or, yDemSb_ff, yDemSb_we, 
               yDecSb, yDecSb_or, yDecSb_ff, yDecSb_we, 
               yDecSb2, yDecSb2_or, yDecSb2_ff, yDecSb2_we, 
               yDecVit, yDecVit_or, yDecVit_ff, yDecVit_we, 
               bIn, bIn_ir, bIn_fe, bIn_re, 
               rx20, rx20_ir, rx20_fe, rx20_re, 
               ssDetect, 
               ssAcqHalt, 
               irq_bridge_11a, 
               regBusIn, regWeIn, regReIn, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Include global definitions
  `include "def_Const_wlan.v"

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter bOut_w            = 0;
  parameter tx20_w            = 0;
  parameter yAcqCor_w         = 0;
  parameter yAcqAbs_w         = 0;
  parameter yAcqPh_w          = 0;
  parameter ySyncAbs_w        = 0;
  parameter ySyncC_w          = 0;
  parameter ySyncSh_w         = 0;
  parameter yDemD_w           = 0;
  parameter yDemSb_w          = 0;
  parameter yDecSb_w          = 0;
  parameter yDecSb2_w         = 0;
  parameter yDecVit_w         = 0;
  parameter bIn_w             = 0;
  parameter rx20_w            = 0;

  parameter ssDetect_w        = 0;
  parameter ssAcqHalt_w       = 0;

  parameter txRxSel_w         = 0;
  parameter txRxSel_r         = 0;
  parameter txRxSel_s         = 0;
  parameter R_txRxSel         = 0;
  parameter state11a_w        = 0;
  parameter state11a_r        = 0;
  parameter state11a_s        = 0;
  parameter R_state11a        = 0;
  parameter state11aDbg_w     = 0;
  parameter state11aDbg_r     = 0;
  parameter state11aDbg_s     = 0;
  parameter R_state11aDbg     = 0;

  parameter R_bridge_11a_fifoMst = 0;
  parameter R_bridge_11a_ctrlMst = 0;
  parameter R_bridge_11a_fifoSlv = 0;
  parameter R_bridge_11a_ctrlSlv = 0;

  parameter wt                = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output         [bOut_w-1:0]  bOut;
  output                       bOut_or;
  input                        bOut_ff;
  output                       bOut_we;
  assign                       bOut_we = bOut_or & ~bOut_ff;

  output         [tx20_w-1:0]  tx20;
  output                       tx20_or;
  input                        tx20_ff;
  output                       tx20_we;
  assign                       tx20_we = tx20_or & ~tx20_ff;

  output      [yAcqCor_w-1:0]  yAcqCor;
  output                       yAcqCor_or;
  input                        yAcqCor_ff;
  output                       yAcqCor_we;
  assign                       yAcqCor_we = yAcqCor_or & ~yAcqCor_ff;

  output      [yAcqAbs_w-1:0]  yAcqAbs;
  output                       yAcqAbs_or;
  input                        yAcqAbs_ff;
  output                       yAcqAbs_we;
  assign                       yAcqAbs_we = yAcqAbs_or & ~yAcqAbs_ff;

  output       [yAcqPh_w-1:0]  yAcqPh;
  output                       yAcqPh_or;
  input                        yAcqPh_ff;
  output                       yAcqPh_we;
  assign                       yAcqPh_we = yAcqPh_or & ~yAcqPh_ff;

  output     [ySyncAbs_w-1:0]  ySyncAbs;
  output                       ySyncAbs_or;
  input                        ySyncAbs_ff;
  output                       ySyncAbs_we;
  assign                       ySyncAbs_we = ySyncAbs_or & ~ySyncAbs_ff;

  output       [ySyncC_w-1:0]  ySyncC;
  output                       ySyncC_or;
  input                        ySyncC_ff;
  output                       ySyncC_we;
  assign                       ySyncC_we = ySyncC_or & ~ySyncC_ff;

  output      [ySyncSh_w-1:0]  ySyncSh;
  output                       ySyncSh_or;
  input                        ySyncSh_ff;
  output                       ySyncSh_we;
  assign                       ySyncSh_we = ySyncSh_or & ~ySyncSh_ff;

  output        [yDemD_w-1:0]  yDemD;
  output                       yDemD_or;
  input                        yDemD_ff;
  output                       yDemD_we;
  assign                       yDemD_we = yDemD_or & ~yDemD_ff;

  output       [yDemSb_w-1:0]  yDemSb;
  output                       yDemSb_or;
  input                        yDemSb_ff;
  output                       yDemSb_we;
  assign                       yDemSb_we = yDemSb_or & ~yDemSb_ff;

  output       [yDecSb_w-1:0]  yDecSb;
  output                       yDecSb_or;
  input                        yDecSb_ff;
  output                       yDecSb_we;
  assign                       yDecSb_we = yDecSb_or & ~yDecSb_ff;

  output      [yDecSb2_w-1:0]  yDecSb2;
  output                       yDecSb2_or;
  input                        yDecSb2_ff;
  output                       yDecSb2_we;
  assign                       yDecSb2_we = yDecSb2_or & ~yDecSb2_ff;

  output      [yDecVit_w-1:0]  yDecVit;
  output                       yDecVit_or;
  input                        yDecVit_ff;
  output                       yDecVit_we;
  assign                       yDecVit_we = yDecVit_or & ~yDecVit_ff;

  input           [bIn_w-1:0]  bIn;
  output                       bIn_ir;
  input                        bIn_fe;
  output                       bIn_re;
  assign                       bIn_re = bIn_ir & ~bIn_fe;

  input          [rx20_w-1:0]  rx20;
  output                       rx20_ir;
  input                        rx20_fe;
  output                       rx20_re;
  assign                       rx20_re = rx20_ir & ~rx20_fe;

  output     [ssDetect_w-1:0]  ssDetect;
  input     [ssAcqHalt_w-1:0]  ssAcqHalt;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Define bridge IRQ to upper module
  output                       irq_bridge_11a;

  // Inputs and outputs for registers
  inout                [15:0]  regBusIn;
  input                        regWeIn;
  input                        regReIn;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire        [txRxSel_w-1:0]  txRxSel_q;
  wire        [txRxSel_w-1:0]  txRxSel_d;
  wire                         txRxSel_weint;
  assign                       txRxSel_weint = 0;

  wire       [state11a_w-1:0]  state11a_q;
  wire       [state11a_w-1:0]  state11a_d;
  wire                         state11a_weint;
  assign                       state11a_weint = 0;

  wire    [state11aDbg_w-1:0]  state11aDbg_q;
  wire    [state11aDbg_w-1:0]  state11aDbg_d;
  wire                         state11aDbg_weint;
  assign                       state11aDbg_weint = 0;

  // Assign clock
  wire clk;
  assign clk = clk1;

  wire   [15:0] regBus;
  wire          regWe;
  wire          regRe;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg txRxSel(txRxSel_q, regBus, txRxSel_d, txRxSel_weint, regWe, regRe, clk, reset);
  defparam txRxSel.w    = txRxSel_w;
  defparam txRxSel.rval = txRxSel_r;
  defparam txRxSel.sgn  = txRxSel_s;
  defparam txRxSel.adr  = R_txRxSel;

  ereg state11a(state11a_q, regBus, state11a_d, state11a_weint, regWe, regRe, clk, reset);
  defparam state11a.w    = state11a_w;
  defparam state11a.rval = state11a_r;
  defparam state11a.sgn  = state11a_s;
  defparam state11a.adr  = R_state11a;

  ereg state11aDbg(state11aDbg_q, regBus, state11aDbg_d, state11aDbg_weint, regWe, regRe, clk, reset);
  defparam state11aDbg.w    = state11aDbg_w;
  defparam state11aDbg.rval = state11aDbg_r;
  defparam state11aDbg.sgn  = state11aDbg_s;
  defparam state11aDbg.adr  = R_state11aDbg;

  // --------------------------------------------------------------------------------------
  // Included bridge

  // ----------------------------------------
  wire                bridge_11a_irqMst;
  wire                bridge_11a_irqSlv;
  wire                bridge_11a_regWeSlvOut;

  bridge bridge_11a(bridge_11a_irqMst,
                    bridge_11a_irqSlv,
                    bridge_11a_regWeSlvOut,
                    regBusIn, regWeIn, regReIn,
                    regBus,   regWe,   regRe,
                    clk, reset);

  defparam bridge_11a.R_fifoMst = R_bridge_11a_fifoMst;
  defparam bridge_11a.R_ctrlMst = R_bridge_11a_ctrlMst;
  defparam bridge_11a.R_fifoSlv = R_bridge_11a_fifoSlv;
  defparam bridge_11a.R_ctrlSlv = R_bridge_11a_ctrlSlv;

  assign irq_bridge_11a = bridge_11a_irqMst;

  // --------------------------------------------------------------------------------------
  // Included instances
  `include "X16_11a.v"
  `include "irqCtrl_11a.v"
  `include "tx11a_0.v"
  `include "rx11a_0.v"
  `include "cordicR2P_0.v"
  `include "sqrtX_0.v"
  `include "fft64_0.v"
  `include "s2To1Sel_20.v"
  `include "s1To2Sel_20.v"

  // --------------------------------------------------------------------------------------
  // Define connections
  assign tx11a_0_x                 = bIn;
  assign tx11a_0_x_fe              = bIn_fe;
  assign bIn_ir                    = tx11a_0_x_ir;

  assign tx20                      = tx11a_0_y;
  assign tx20_or                   = tx11a_0_y_or;
  assign tx11a_0_y_ff              = tx20_ff;

  assign rx11a_0_x                 = rx20;
  assign rx11a_0_x_fe              = rx20_fe;
  assign rx20_ir                   = rx11a_0_x_ir;

  assign bOut                      = rx11a_0_y;
  assign bOut_or                   = rx11a_0_y_or;
  assign rx11a_0_y_ff              = bOut_ff;

  assign s2To1Sel_20_x0            = tx11a_0_yFft;
  assign s2To1Sel_20_x0_fe         = ~tx11a_0_yFft_or;
  assign tx11a_0_yFft_ff           = ~s2To1Sel_20_x0_ir;

  assign tx11a_0_xFft              = s1To2Sel_20_y0;
  assign tx11a_0_xFft_fe           = ~s1To2Sel_20_y0_or;
  assign s1To2Sel_20_y0_ff         = ~tx11a_0_xFft_ir;

  assign fft64_0_x                 = s2To1Sel_20_y;
  assign fft64_0_x_fe              = ~s2To1Sel_20_y_or;
  assign s2To1Sel_20_y_ff          = ~fft64_0_x_ir;

  assign s1To2Sel_20_x             = fft64_0_y;
  assign s1To2Sel_20_x_fe          = ~fft64_0_y_or;
  assign fft64_0_y_ff              = ~s1To2Sel_20_x_ir;

  assign yAcqCor                   = rx11a_0_yAcqCor;
  assign yAcqCor_or                = rx11a_0_yAcqCor_or;
  assign rx11a_0_yAcqCor_ff        = yAcqCor_ff;

  assign yAcqPh                    = rx11a_0_yAcqPh;
  assign yAcqPh_or                 = rx11a_0_yAcqPh_or;
  assign rx11a_0_yAcqPh_ff         = yAcqPh_ff;

  assign yAcqAbs                   = rx11a_0_yAcqAbs;
  assign yAcqAbs_or                = rx11a_0_yAcqAbs_or;
  assign rx11a_0_yAcqAbs_ff        = yAcqAbs_ff;

  assign ySyncAbs                  = rx11a_0_ySyncAbs;
  assign ySyncAbs_or               = rx11a_0_ySyncAbs_or;
  assign rx11a_0_ySyncAbs_ff       = ySyncAbs_ff;

  assign ySyncC                    = rx11a_0_ySyncC;
  assign ySyncC_or                 = rx11a_0_ySyncC_or;
  assign rx11a_0_ySyncC_ff         = ySyncC_ff;

  assign ySyncSh                   = rx11a_0_ySyncSh;
  assign ySyncSh_or                = rx11a_0_ySyncSh_or;
  assign rx11a_0_ySyncSh_ff        = ySyncSh_ff;

  assign yDemD                     = rx11a_0_yDemD;
  assign yDemD_or                  = rx11a_0_yDemD_or;
  assign rx11a_0_yDemD_ff          = yDemD_ff;

  assign yDemSb                    = rx11a_0_yDemSb;
  assign yDemSb_or                 = rx11a_0_yDemSb_or;
  assign rx11a_0_yDemSb_ff         = yDemSb_ff;

  assign yDecSb                    = rx11a_0_yDecSb;
  assign yDecSb_or                 = rx11a_0_yDecSb_or;
  assign rx11a_0_yDecSb_ff         = yDecSb_ff;

  assign yDecSb2                   = rx11a_0_yDecSb2;
  assign yDecSb2_or                = rx11a_0_yDecSb2_or;
  assign rx11a_0_yDecSb2_ff        = yDecSb2_ff;

  assign yDecVit                   = rx11a_0_yDecVit;
  assign yDecVit_or                = rx11a_0_yDecVit_or;
  assign rx11a_0_yDecVit_ff        = yDecVit_ff;


  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regWe = 0 | X16_11a_regWe | irqCtrl_11a_regWe | tx11a_0_regWe
                      | rx11a_0_regWe | cordicR2P_0_regWe | sqrtX_0_regWe
                      | fft64_0_regWe | s2To1Sel_20_regWe | s1To2Sel_20_regWe | bridge_11a_regWeSlvOut;
  assign regReOut = 0;
  assign regRe = 0 | X16_11a_regRe | irqCtrl_11a_regRe | tx11a_0_regRe
                      | rx11a_0_regRe | cordicR2P_0_regRe | sqrtX_0_regRe
                      | fft64_0_regRe | s2To1Sel_20_regRe | s1To2Sel_20_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // Assign FFT connection
  assign s2To1Sel_20_x1            = rx11a_0_yFft;
  assign s2To1Sel_20_x1_fe         = ~rx11a_0_yFft_or;
  assign rx11a_0_yFft_ff           = ~s2To1Sel_20_x1_ir;

  assign rx11a_0_xFft              = s1To2Sel_20_y1;
  assign rx11a_0_xFft_fe           = ~s1To2Sel_20_y1_or;
  assign s1To2Sel_20_y1_ff         = ~rx11a_0_xFft_ir;

  // Assign interrupts - inputs
  assign irqCtrl_11a_irqIn[WlanIrqBitCtrl11a_C]                           = bridge_11a_irqSlv;
  assign irqCtrl_11a_irqIn[WlanIrqBitTxPsduDone_C:WlanIrqBitTxHdr0Done_C] = tx11a_0_irqDone;
  assign irqCtrl_11a_irqIn[WlanIrqBitRxVitPsduDone_C:WlanIrqBitRxAgc_C]   = rx11a_0_irqDone;
  assign irqCtrl_11a_irqIn[WlanIrqBitRxSqrtDone_C]                        = sqrtX_0_irqDone;
  assign irqCtrl_11a_irqIn[WlanIrqBitRxCordicDone_C]                      = cordicR2P_0_irqDone;

  // Assign IRQ output
  assign X16_11a_irqExt = irqCtrl_11a_irqOut;

  // Connect TX/RX switch for FFT
  assign s1To2Sel_20_sel = txRxSel_q;
  assign s2To1Sel_20_sel = txRxSel_q;

  // Connect AGC control signals
  assign ssDetect           = rx11a_0_ssDetect;
  assign rx11a_0_ssAcqHalt  = ssAcqHalt;

endmodule
//=========================================================================================

