//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter main11_0_bIn_w           = 8;
  parameter main11_0_rx80_w          = 24;

  // Outputs
  parameter main11_0_bOut_w          = 8;
  parameter main11_0_tx80_w          = 24;
  parameter main11_0_attn_w          = 16;
  parameter main11_0_yRxDbg0_w       = 32;
  parameter main11_0_yRxDbg1_w       = 32;

  // Input control lines

  // Output control lines
  parameter main11_0_irq11a_w        = 1;
  parameter main11_0_irq11b_w        = 1;
  parameter main11_0_dbgLed_w        = 8;

  // Eregs
  parameter main11_0_singleAdc_w     = 1;
  parameter main11_0_singleAdc_r     = 0;
  parameter main11_0_singleAdc_s     = 0;

  // Parameters
  parameter main11_0_w               = 12;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam main11_0.bIn_w           = main11_0_bIn_w;
  defparam main11_0.rx80_w          = main11_0_rx80_w;
  defparam main11_0.bOut_w          = main11_0_bOut_w;
  defparam main11_0.tx80_w          = main11_0_tx80_w;
  defparam main11_0.attn_w          = main11_0_attn_w;
  defparam main11_0.yRxDbg0_w       = main11_0_yRxDbg0_w;
  defparam main11_0.yRxDbg1_w       = main11_0_yRxDbg1_w;
  defparam main11_0.irq11a_w        = main11_0_irq11a_w;
  defparam main11_0.irq11b_w        = main11_0_irq11b_w;
  defparam main11_0.dbgLed_w        = main11_0_dbgLed_w;
  defparam main11_0.singleAdc_w     = main11_0_singleAdc_w;
  defparam main11_0.singleAdc_r     = main11_0_singleAdc_r;
  defparam main11_0.singleAdc_s     = main11_0_singleAdc_s;
  defparam main11_0.w               = main11_0_w;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_main11_0_singleAdc                                         = 0;
  defparam  main11_0.R_singleAdc                                         = R_main11_0_singleAdc;
  parameter R_main11_0_main11a_0_txRxSel                                 = 1;
  defparam  main11_0.R_main11a_0_txRxSel                                 = R_main11_0_main11a_0_txRxSel;
  parameter R_main11_0_main11a_0_state11a                                = 2;
  defparam  main11_0.R_main11a_0_state11a                                = R_main11_0_main11a_0_state11a;
  parameter R_main11_0_main11a_0_state11aDbg                             = 3;
  defparam  main11_0.R_main11a_0_state11aDbg                             = R_main11_0_main11a_0_state11aDbg;
  parameter R_main11_0_main11a_0_X16_11a_cmd                             = 4;
  defparam  main11_0.R_main11a_0_X16_11a_cmd                             = R_main11_0_main11a_0_X16_11a_cmd;
  parameter R_main11_0_main11a_0_X16_11a_pramAdr                         = 5;
  defparam  main11_0.R_main11a_0_X16_11a_pramAdr                         = R_main11_0_main11a_0_X16_11a_pramAdr;
  parameter R_main11_0_main11a_0_X16_11a_pramDat                         = 6;
  defparam  main11_0.R_main11a_0_X16_11a_pramDat                         = R_main11_0_main11a_0_X16_11a_pramDat;
  parameter R_main11_0_main11a_0_X16_11a_dramAdr                         = 7;
  defparam  main11_0.R_main11a_0_X16_11a_dramAdr                         = R_main11_0_main11a_0_X16_11a_dramAdr;
  parameter R_main11_0_main11a_0_X16_11a_dramDat                         = 8;
  defparam  main11_0.R_main11a_0_X16_11a_dramDat                         = R_main11_0_main11a_0_X16_11a_dramDat;
  parameter R_main11_0_main11a_0_irqCtrl_11a_run1                        = 9;
  defparam  main11_0.R_main11a_0_irqCtrl_11a_run1                        = R_main11_0_main11a_0_irqCtrl_11a_run1;
  parameter R_main11_0_main11a_0_irqCtrl_11a_irqStat                     = 10;
  defparam  main11_0.R_main11a_0_irqCtrl_11a_irqStat                     = R_main11_0_main11a_0_irqCtrl_11a_irqStat;
  parameter R_main11_0_main11a_0_irqCtrl_11a_irqEdgeLevel                = 11;
  defparam  main11_0.R_main11a_0_irqCtrl_11a_irqEdgeLevel                = R_main11_0_main11a_0_irqCtrl_11a_irqEdgeLevel;
  parameter R_main11_0_main11a_0_irqCtrl_11a_irqMaskIn                   = 12;
  defparam  main11_0.R_main11a_0_irqCtrl_11a_irqMaskIn                   = R_main11_0_main11a_0_irqCtrl_11a_irqMaskIn;
  parameter R_main11_0_main11a_0_irqCtrl_11a_irqMaskOut                  = 13;
  defparam  main11_0.R_main11a_0_irqCtrl_11a_irqMaskOut                  = R_main11_0_main11a_0_irqCtrl_11a_irqMaskOut;
  parameter R_main11_0_main11a_0_irqCtrl_11a_irqClr                      = 14;
  defparam  main11_0.R_main11a_0_irqCtrl_11a_irqClr                      = R_main11_0_main11a_0_irqCtrl_11a_irqClr;
  parameter R_main11_0_main11a_0_irqCtrl_11a_irqSet                      = 15;
  defparam  main11_0.R_main11a_0_irqCtrl_11a_irqSet                      = R_main11_0_main11a_0_irqCtrl_11a_irqSet;
  parameter R_main11_0_main11a_0_irqCtrl_11a_irqIdx                      = 16;
  defparam  main11_0.R_main11a_0_irqCtrl_11a_irqIdx                      = R_main11_0_main11a_0_irqCtrl_11a_irqIdx;
  parameter R_main11_0_main11a_0_tx11a_0_enc11a_0_run1                   = 17;
  defparam  main11_0.R_main11a_0_tx11a_0_enc11a_0_run1                   = R_main11_0_main11a_0_tx11a_0_enc11a_0_run1;
  parameter R_main11_0_main11a_0_tx11a_0_enc11a_0_crc32_0_numBits        = 18;
  defparam  main11_0.R_main11a_0_tx11a_0_enc11a_0_crc32_0_numBits        = R_main11_0_main11a_0_tx11a_0_enc11a_0_crc32_0_numBits;
  parameter R_main11_0_main11a_0_tx11a_0_enc11a_0_ppdu11a_0_plcpHdr0     = 19;
  defparam  main11_0.R_main11a_0_tx11a_0_enc11a_0_ppdu11a_0_plcpHdr0     = R_main11_0_main11a_0_tx11a_0_enc11a_0_ppdu11a_0_plcpHdr0;
  parameter R_main11_0_main11a_0_tx11a_0_enc11a_0_ppdu11a_0_plcpHdr1     = 20;
  defparam  main11_0.R_main11a_0_tx11a_0_enc11a_0_ppdu11a_0_plcpHdr1     = R_main11_0_main11a_0_tx11a_0_enc11a_0_ppdu11a_0_plcpHdr1;
  parameter R_main11_0_main11a_0_tx11a_0_enc11a_0_ppdu11a_0_numByte      = 21;
  defparam  main11_0.R_main11a_0_tx11a_0_enc11a_0_ppdu11a_0_numByte      = R_main11_0_main11a_0_tx11a_0_enc11a_0_ppdu11a_0_numByte;
  parameter R_main11_0_main11a_0_tx11a_0_enc11a_0_ppdu11a_0_numPadBit    = 22;
  defparam  main11_0.R_main11a_0_tx11a_0_enc11a_0_ppdu11a_0_numPadBit    = R_main11_0_main11a_0_tx11a_0_enc11a_0_ppdu11a_0_numPadBit;
  parameter R_main11_0_main11a_0_tx11a_0_enc11a_0_scrmbl_0_s             = 23;
  defparam  main11_0.R_main11a_0_tx11a_0_enc11a_0_scrmbl_0_s             = R_main11_0_main11a_0_tx11a_0_enc11a_0_scrmbl_0_s;
  parameter R_main11_0_main11a_0_tx11a_0_enc11a_0_punct_0_run1           = 24;
  defparam  main11_0.R_main11a_0_tx11a_0_enc11a_0_punct_0_run1           = R_main11_0_main11a_0_tx11a_0_enc11a_0_punct_0_run1;
  parameter R_main11_0_main11a_0_tx11a_0_mod11a_0_run1                   = 25;
  defparam  main11_0.R_main11a_0_tx11a_0_mod11a_0_run1                   = R_main11_0_main11a_0_tx11a_0_mod11a_0_run1;
  parameter R_main11_0_main11a_0_tx11a_0_mod11a_0_intlv_0_mode1          = 26;
  defparam  main11_0.R_main11a_0_tx11a_0_mod11a_0_intlv_0_mode1          = R_main11_0_main11a_0_tx11a_0_mod11a_0_intlv_0_mode1;
  parameter R_main11_0_main11a_0_tx11a_0_mod11a_0_qamMod_0_mode1         = 27;
  defparam  main11_0.R_main11a_0_tx11a_0_mod11a_0_qamMod_0_mode1         = R_main11_0_main11a_0_tx11a_0_mod11a_0_qamMod_0_mode1;
  parameter R_main11_0_main11a_0_tx11a_0_mod11a_0_shortSym_0_numOfdm     = 28;
  defparam  main11_0.R_main11a_0_tx11a_0_mod11a_0_shortSym_0_numOfdm     = R_main11_0_main11a_0_tx11a_0_mod11a_0_shortSym_0_numOfdm;
  parameter R_main11_0_main11a_0_rx11a_0_runAcqBuf                       = 29;
  defparam  main11_0.R_main11a_0_rx11a_0_runAcqBuf                       = R_main11_0_main11a_0_rx11a_0_runAcqBuf;
  parameter R_main11_0_main11a_0_rx11a_0_bufNormRot_0_numOut             = 30;
  defparam  main11_0.R_main11a_0_rx11a_0_bufNormRot_0_numOut             = R_main11_0_main11a_0_rx11a_0_bufNormRot_0_numOut;
  parameter R_main11_0_main11a_0_rx11a_0_bufNormRot_0_runOut             = 31;
  defparam  main11_0.R_main11a_0_rx11a_0_bufNormRot_0_runOut             = R_main11_0_main11a_0_rx11a_0_bufNormRot_0_runOut;
  parameter R_main11_0_main11a_0_rx11a_0_bufNormRot_0_fftWrap            = 32;
  defparam  main11_0.R_main11a_0_rx11a_0_bufNormRot_0_fftWrap            = R_main11_0_main11a_0_rx11a_0_bufNormRot_0_fftWrap;
  parameter R_main11_0_main11a_0_rx11a_0_bufNormRot_0_rxBuf_0_wrAdr      = 33;
  defparam  main11_0.R_main11a_0_rx11a_0_bufNormRot_0_rxBuf_0_wrAdr      = R_main11_0_main11a_0_rx11a_0_bufNormRot_0_rxBuf_0_wrAdr;
  parameter R_main11_0_main11a_0_rx11a_0_bufNormRot_0_rxBuf_0_rdAdr0     = 34;
  defparam  main11_0.R_main11a_0_rx11a_0_bufNormRot_0_rxBuf_0_rdAdr0     = R_main11_0_main11a_0_rx11a_0_bufNormRot_0_rxBuf_0_rdAdr0;
  parameter R_main11_0_main11a_0_rx11a_0_bufNormRot_0_rxBuf_0_irqAdr     = 35;
  defparam  main11_0.R_main11a_0_rx11a_0_bufNormRot_0_rxBuf_0_irqAdr     = R_main11_0_main11a_0_rx11a_0_bufNormRot_0_rxBuf_0_irqAdr;
  parameter R_main11_0_main11a_0_rx11a_0_bufNormRot_0_rxBuf_0_agcDoneAdr = 36;
  defparam  main11_0.R_main11a_0_rx11a_0_bufNormRot_0_rxBuf_0_agcDoneAdr = R_main11_0_main11a_0_rx11a_0_bufNormRot_0_rxBuf_0_agcDoneAdr;
  parameter R_main11_0_main11a_0_rx11a_0_bufNormRot_0_normX_0_amp        = 37;
  defparam  main11_0.R_main11a_0_rx11a_0_bufNormRot_0_normX_0_amp        = R_main11_0_main11a_0_rx11a_0_bufNormRot_0_normX_0_amp;
  parameter R_main11_0_main11a_0_rx11a_0_bufNormRot_0_cordicRot_0_ph     = 38;
  defparam  main11_0.R_main11a_0_rx11a_0_bufNormRot_0_cordicRot_0_ph     = R_main11_0_main11a_0_rx11a_0_bufNormRot_0_cordicRot_0_ph;
  parameter R_main11_0_main11a_0_rx11a_0_bufNormRot_0_cordicRot_0_dph    = 39;
  defparam  main11_0.R_main11a_0_rx11a_0_bufNormRot_0_cordicRot_0_dph    = R_main11_0_main11a_0_rx11a_0_bufNormRot_0_cordicRot_0_dph;
  parameter R_main11_0_main11a_0_rx11a_0_acq11a_0_freqOff                = 40;
  defparam  main11_0.R_main11a_0_rx11a_0_acq11a_0_freqOff                = R_main11_0_main11a_0_rx11a_0_acq11a_0_freqOff;
  parameter R_main11_0_main11a_0_rx11a_0_acq11a_0_timeOff                = 41;
  defparam  main11_0.R_main11a_0_rx11a_0_acq11a_0_timeOff                = R_main11_0_main11a_0_rx11a_0_acq11a_0_timeOff;
  parameter R_main11_0_main11a_0_rx11a_0_acq11a_0_ampEst                 = 42;
  defparam  main11_0.R_main11a_0_rx11a_0_acq11a_0_ampEst                 = R_main11_0_main11a_0_rx11a_0_acq11a_0_ampEst;
  parameter R_main11_0_main11a_0_rx11a_0_acq11a_0_ssNorm_0_cutN_20c4_numCut = 43;
  defparam  main11_0.R_main11a_0_rx11a_0_acq11a_0_ssNorm_0_cutN_20c4_numCut = R_main11_0_main11a_0_rx11a_0_acq11a_0_ssNorm_0_cutN_20c4_numCut;
  parameter R_main11_0_main11a_0_rx11a_0_acq11a_0_ssCcfAvgDet_0_thr2     = 44;
  defparam  main11_0.R_main11a_0_rx11a_0_acq11a_0_ssCcfAvgDet_0_thr2     = R_main11_0_main11a_0_rx11a_0_acq11a_0_ssCcfAvgDet_0_thr2;
  parameter R_main11_0_main11a_0_rx11a_0_acq11a_0_ssCcfAvgDet_0_thr3     = 45;
  defparam  main11_0.R_main11a_0_rx11a_0_acq11a_0_ssCcfAvgDet_0_thr3     = R_main11_0_main11a_0_rx11a_0_acq11a_0_ssCcfAvgDet_0_thr3;
  parameter R_main11_0_main11a_0_rx11a_0_acq11a_0_ssCcfAvgDet_0_thr4     = 46;
  defparam  main11_0.R_main11a_0_rx11a_0_acq11a_0_ssCcfAvgDet_0_thr4     = R_main11_0_main11a_0_rx11a_0_acq11a_0_ssCcfAvgDet_0_thr4;
  parameter R_main11_0_main11a_0_rx11a_0_acq11a_0_ctfe_0_ctfeCordic_0_thr = 47;
  defparam  main11_0.R_main11a_0_rx11a_0_acq11a_0_ctfe_0_ctfeCordic_0_thr = R_main11_0_main11a_0_rx11a_0_acq11a_0_ctfe_0_ctfeCordic_0_thr;
  parameter R_main11_0_main11a_0_rx11a_0_sync11a_0_run1                  = 48;
  defparam  main11_0.R_main11a_0_rx11a_0_sync11a_0_run1                  = R_main11_0_main11a_0_rx11a_0_sync11a_0_run1;
  parameter R_main11_0_main11a_0_rx11a_0_sync11a_0_lsCcf_0_peakPos       = 49;
  defparam  main11_0.R_main11a_0_rx11a_0_sync11a_0_lsCcf_0_peakPos       = R_main11_0_main11a_0_rx11a_0_sync11a_0_lsCcf_0_peakPos;
  parameter R_main11_0_main11a_0_rx11a_0_sync11a_0_lsCcf_0_peakVal       = 50;
  defparam  main11_0.R_main11a_0_rx11a_0_sync11a_0_lsCcf_0_peakVal       = R_main11_0_main11a_0_rx11a_0_sync11a_0_lsCcf_0_peakVal;
  parameter R_main11_0_main11a_0_rx11a_0_sync11a_0_cxMulAvg_0_numSmpl    = 51;
  defparam  main11_0.R_main11a_0_rx11a_0_sync11a_0_cxMulAvg_0_numSmpl    = R_main11_0_main11a_0_rx11a_0_sync11a_0_cxMulAvg_0_numSmpl;
  parameter R_main11_0_main11a_0_rx11a_0_sync11a_0_cxMulAvg_0_yReLo      = 52;
  defparam  main11_0.R_main11a_0_rx11a_0_sync11a_0_cxMulAvg_0_yReLo      = R_main11_0_main11a_0_rx11a_0_sync11a_0_cxMulAvg_0_yReLo;
  parameter R_main11_0_main11a_0_rx11a_0_sync11a_0_cxMulAvg_0_yImHi      = 53;
  defparam  main11_0.R_main11a_0_rx11a_0_sync11a_0_cxMulAvg_0_yImHi      = R_main11_0_main11a_0_rx11a_0_sync11a_0_cxMulAvg_0_yImHi;
  parameter R_main11_0_main11a_0_rx11a_0_dem11a_0_run1                   = 54;
  defparam  main11_0.R_main11a_0_rx11a_0_dem11a_0_run1                   = R_main11_0_main11a_0_rx11a_0_dem11a_0_run1;
  parameter R_main11_0_main11a_0_rx11a_0_dem11a_0_ttCordic_0_run1        = 55;
  defparam  main11_0.R_main11a_0_rx11a_0_dem11a_0_ttCordic_0_run1        = R_main11_0_main11a_0_rx11a_0_dem11a_0_ttCordic_0_run1;
  parameter R_main11_0_main11a_0_rx11a_0_dem11a_0_ttCordic_0_ph          = 56;
  defparam  main11_0.R_main11a_0_rx11a_0_dem11a_0_ttCordic_0_ph          = R_main11_0_main11a_0_rx11a_0_dem11a_0_ttCordic_0_ph;
  parameter R_main11_0_main11a_0_rx11a_0_dem11a_0_ttCordic_0_dph3        = 57;
  defparam  main11_0.R_main11a_0_rx11a_0_dem11a_0_ttCordic_0_dph3        = R_main11_0_main11a_0_rx11a_0_dem11a_0_ttCordic_0_dph3;
  parameter R_main11_0_main11a_0_rx11a_0_dem11a_0_ttCordic_0_dph4        = 58;
  defparam  main11_0.R_main11a_0_rx11a_0_dem11a_0_ttCordic_0_dph4        = R_main11_0_main11a_0_rx11a_0_dem11a_0_ttCordic_0_dph4;
  parameter R_main11_0_main11a_0_rx11a_0_dem11a_0_ttCordic_0_dphM49      = 59;
  defparam  main11_0.R_main11a_0_rx11a_0_dem11a_0_ttCordic_0_dphM49      = R_main11_0_main11a_0_rx11a_0_dem11a_0_ttCordic_0_dphM49;
  parameter R_main11_0_main11a_0_rx11a_0_dem11a_0_ttCordic_0_dph14       = 60;
  defparam  main11_0.R_main11a_0_rx11a_0_dem11a_0_ttCordic_0_dph14       = R_main11_0_main11a_0_rx11a_0_dem11a_0_ttCordic_0_dph14;
  parameter R_main11_0_main11a_0_rx11a_0_dem11a_0_pltExt_0_pltSumRe      = 61;
  defparam  main11_0.R_main11a_0_rx11a_0_dem11a_0_pltExt_0_pltSumRe      = R_main11_0_main11a_0_rx11a_0_dem11a_0_pltExt_0_pltSumRe;
  parameter R_main11_0_main11a_0_rx11a_0_dem11a_0_pltExt_0_pltSumIm      = 62;
  defparam  main11_0.R_main11a_0_rx11a_0_dem11a_0_pltExt_0_pltSumIm      = R_main11_0_main11a_0_rx11a_0_dem11a_0_pltExt_0_pltSumIm;
  parameter R_main11_0_main11a_0_rx11a_0_dec11a_0_run1                   = 63;
  defparam  main11_0.R_main11a_0_rx11a_0_dec11a_0_run1                   = R_main11_0_main11a_0_rx11a_0_dec11a_0_run1;
  parameter R_main11_0_main11a_0_rx11a_0_dec11a_0_deIntlv_0_mode1        = 64;
  defparam  main11_0.R_main11a_0_rx11a_0_dec11a_0_deIntlv_0_mode1        = R_main11_0_main11a_0_rx11a_0_dec11a_0_deIntlv_0_mode1;
  parameter R_main11_0_main11a_0_rx11a_0_dec11a_0_dePunct_0_run1         = 65;
  defparam  main11_0.R_main11a_0_rx11a_0_dec11a_0_dePunct_0_run1         = R_main11_0_main11a_0_rx11a_0_dec11a_0_dePunct_0_run1;
  parameter R_main11_0_main11a_0_rx11a_0_dec11a_0_vitMain_0_run1         = 66;
  defparam  main11_0.R_main11a_0_rx11a_0_dec11a_0_vitMain_0_run1         = R_main11_0_main11a_0_rx11a_0_dec11a_0_vitMain_0_run1;
  parameter R_main11_0_main11a_0_rx11a_0_dec11a_0_vitMain_0_numBits      = 67;
  defparam  main11_0.R_main11a_0_rx11a_0_dec11a_0_vitMain_0_numBits      = R_main11_0_main11a_0_rx11a_0_dec11a_0_vitMain_0_numBits;
  parameter R_main11_0_main11a_0_rx11a_0_dec11a_0_vitMain_0_rxMode       = 68;
  defparam  main11_0.R_main11a_0_rx11a_0_dec11a_0_vitMain_0_rxMode       = R_main11_0_main11a_0_rx11a_0_dec11a_0_vitMain_0_rxMode;
  parameter R_main11_0_main11a_0_rx11a_0_dec11a_0_vitMain_0_rxLen        = 69;
  defparam  main11_0.R_main11a_0_rx11a_0_dec11a_0_vitMain_0_rxLen        = R_main11_0_main11a_0_rx11a_0_dec11a_0_vitMain_0_rxLen;
  parameter R_main11_0_main11a_0_rx11a_0_dec11a_0_vitMain_0_pm00         = 70;
  defparam  main11_0.R_main11a_0_rx11a_0_dec11a_0_vitMain_0_pm00         = R_main11_0_main11a_0_rx11a_0_dec11a_0_vitMain_0_pm00;
  parameter R_main11_0_main11a_0_rx11a_0_dec11a_0_crc32x8_0_numBytes     = 71;
  defparam  main11_0.R_main11a_0_rx11a_0_dec11a_0_crc32x8_0_numBytes     = R_main11_0_main11a_0_rx11a_0_dec11a_0_crc32x8_0_numBytes;
  parameter R_main11_0_main11a_0_rx11a_0_dec11a_0_crc32x8_0_crcRes       = 72;
  defparam  main11_0.R_main11a_0_rx11a_0_dec11a_0_crc32x8_0_crcRes       = R_main11_0_main11a_0_rx11a_0_dec11a_0_crc32x8_0_crcRes;
  parameter R_main11_0_main11a_0_cordicR2P_0_run1                        = 73;
  defparam  main11_0.R_main11a_0_cordicR2P_0_run1                        = R_main11_0_main11a_0_cordicR2P_0_run1;
  parameter R_main11_0_main11a_0_cordicR2P_0_numIt                       = 74;
  defparam  main11_0.R_main11a_0_cordicR2P_0_numIt                       = R_main11_0_main11a_0_cordicR2P_0_numIt;
  parameter R_main11_0_main11a_0_cordicR2P_0_xReAbs                      = 75;
  defparam  main11_0.R_main11a_0_cordicR2P_0_xReAbs                      = R_main11_0_main11a_0_cordicR2P_0_xReAbs;
  parameter R_main11_0_main11a_0_cordicR2P_0_xImPh                       = 76;
  defparam  main11_0.R_main11a_0_cordicR2P_0_xImPh                       = R_main11_0_main11a_0_cordicR2P_0_xImPh;
  parameter R_main11_0_main11a_0_cordicR2P_0_thr                         = 77;
  defparam  main11_0.R_main11a_0_cordicR2P_0_thr                         = R_main11_0_main11a_0_cordicR2P_0_thr;
  parameter R_main11_0_main11a_0_sqrtX_0_run1                            = 78;
  defparam  main11_0.R_main11a_0_sqrtX_0_run1                            = R_main11_0_main11a_0_sqrtX_0_run1;
  parameter R_main11_0_main11a_0_sqrtX_0_xy                              = 79;
  defparam  main11_0.R_main11a_0_sqrtX_0_xy                              = R_main11_0_main11a_0_sqrtX_0_xy;
  parameter R_main11_0_main11a_0_fft64_0_run1                            = 80;
  defparam  main11_0.R_main11a_0_fft64_0_run1                            = R_main11_0_main11a_0_fft64_0_run1;
  parameter R_main11_0_main11a_0_fft64_0_tglMode                         = 81;
  defparam  main11_0.R_main11a_0_fft64_0_tglMode                         = R_main11_0_main11a_0_fft64_0_tglMode;
  parameter R_main11_0_main11a_0_fft64_0_inpOrd                          = 82;
  defparam  main11_0.R_main11a_0_fft64_0_inpOrd                          = R_main11_0_main11a_0_fft64_0_inpOrd;
  parameter R_main11_0_main11a_0_fft64_0_outpOrd                         = 83;
  defparam  main11_0.R_main11a_0_fft64_0_outpOrd                         = R_main11_0_main11a_0_fft64_0_outpOrd;
  parameter R_main11_0_main11b_0_state11b                                = 84;
  defparam  main11_0.R_main11b_0_state11b                                = R_main11_0_main11b_0_state11b;
  parameter R_main11_0_main11b_0_state11bDbg                             = 85;
  defparam  main11_0.R_main11b_0_state11bDbg                             = R_main11_0_main11b_0_state11bDbg;
  parameter R_main11_0_main11b_0_X16_11b_cmd                             = 86;
  defparam  main11_0.R_main11b_0_X16_11b_cmd                             = R_main11_0_main11b_0_X16_11b_cmd;
  parameter R_main11_0_main11b_0_X16_11b_pramAdr                         = 87;
  defparam  main11_0.R_main11b_0_X16_11b_pramAdr                         = R_main11_0_main11b_0_X16_11b_pramAdr;
  parameter R_main11_0_main11b_0_X16_11b_pramDat                         = 88;
  defparam  main11_0.R_main11b_0_X16_11b_pramDat                         = R_main11_0_main11b_0_X16_11b_pramDat;
  parameter R_main11_0_main11b_0_X16_11b_dramAdr                         = 89;
  defparam  main11_0.R_main11b_0_X16_11b_dramAdr                         = R_main11_0_main11b_0_X16_11b_dramAdr;
  parameter R_main11_0_main11b_0_X16_11b_dramDat                         = 90;
  defparam  main11_0.R_main11b_0_X16_11b_dramDat                         = R_main11_0_main11b_0_X16_11b_dramDat;
  parameter R_main11_0_main11b_0_irqCtrl_11b_run1                        = 91;
  defparam  main11_0.R_main11b_0_irqCtrl_11b_run1                        = R_main11_0_main11b_0_irqCtrl_11b_run1;
  parameter R_main11_0_main11b_0_irqCtrl_11b_irqStat                     = 92;
  defparam  main11_0.R_main11b_0_irqCtrl_11b_irqStat                     = R_main11_0_main11b_0_irqCtrl_11b_irqStat;
  parameter R_main11_0_main11b_0_irqCtrl_11b_irqEdgeLevel                = 93;
  defparam  main11_0.R_main11b_0_irqCtrl_11b_irqEdgeLevel                = R_main11_0_main11b_0_irqCtrl_11b_irqEdgeLevel;
  parameter R_main11_0_main11b_0_irqCtrl_11b_irqMaskIn                   = 94;
  defparam  main11_0.R_main11b_0_irqCtrl_11b_irqMaskIn                   = R_main11_0_main11b_0_irqCtrl_11b_irqMaskIn;
  parameter R_main11_0_main11b_0_irqCtrl_11b_irqMaskOut                  = 95;
  defparam  main11_0.R_main11b_0_irqCtrl_11b_irqMaskOut                  = R_main11_0_main11b_0_irqCtrl_11b_irqMaskOut;
  parameter R_main11_0_main11b_0_irqCtrl_11b_irqClr                      = 96;
  defparam  main11_0.R_main11b_0_irqCtrl_11b_irqClr                      = R_main11_0_main11b_0_irqCtrl_11b_irqClr;
  parameter R_main11_0_main11b_0_irqCtrl_11b_irqSet                      = 97;
  defparam  main11_0.R_main11b_0_irqCtrl_11b_irqSet                      = R_main11_0_main11b_0_irqCtrl_11b_irqSet;
  parameter R_main11_0_main11b_0_irqCtrl_11b_irqIdx                      = 98;
  defparam  main11_0.R_main11b_0_irqCtrl_11b_irqIdx                      = R_main11_0_main11b_0_irqCtrl_11b_irqIdx;
  parameter R_main11_0_main11b_0_tx11b_0_run1                            = 99;
  defparam  main11_0.R_main11b_0_tx11b_0_run1                            = R_main11_0_main11b_0_tx11b_0_run1;
  parameter R_main11_0_main11b_0_tx11b_0_crc32_0_numBits                 = 100;
  defparam  main11_0.R_main11b_0_tx11b_0_crc32_0_numBits                 = R_main11_0_main11b_0_tx11b_0_crc32_0_numBits;
  parameter R_main11_0_main11b_0_tx11b_0_ppdu11b_0_header                = 101;
  defparam  main11_0.R_main11b_0_tx11b_0_ppdu11b_0_header                = R_main11_0_main11b_0_tx11b_0_ppdu11b_0_header;
  parameter R_main11_0_main11b_0_tx11b_0_ppdu11b_0_sfd                   = 102;
  defparam  main11_0.R_main11b_0_tx11b_0_ppdu11b_0_sfd                   = R_main11_0_main11b_0_tx11b_0_ppdu11b_0_sfd;
  parameter R_main11_0_main11b_0_tx11b_0_ppdu11b_0_sigser                = 103;
  defparam  main11_0.R_main11b_0_tx11b_0_ppdu11b_0_sigser                = R_main11_0_main11b_0_tx11b_0_ppdu11b_0_sigser;
  parameter R_main11_0_main11b_0_tx11b_0_ppdu11b_0_len                   = 104;
  defparam  main11_0.R_main11b_0_tx11b_0_ppdu11b_0_len                   = R_main11_0_main11b_0_tx11b_0_ppdu11b_0_len;
  parameter R_main11_0_main11b_0_tx11b_0_ppdu11b_0_crc                   = 105;
  defparam  main11_0.R_main11b_0_tx11b_0_ppdu11b_0_crc                   = R_main11_0_main11b_0_tx11b_0_ppdu11b_0_crc;
  parameter R_main11_0_main11b_0_tx11b_0_ppdu11b_0_numBits               = 106;
  defparam  main11_0.R_main11b_0_tx11b_0_ppdu11b_0_numBits               = R_main11_0_main11b_0_tx11b_0_ppdu11b_0_numBits;
  parameter R_main11_0_main11b_0_tx11b_0_scrmbl_tx11b_s                  = 107;
  defparam  main11_0.R_main11b_0_tx11b_0_scrmbl_tx11b_s                  = R_main11_0_main11b_0_tx11b_0_scrmbl_tx11b_s;
  parameter R_main11_0_main11b_0_tx11b_0_mod11b_0_mod11bBpsk_0_numBits   = 108;
  defparam  main11_0.R_main11b_0_tx11b_0_mod11b_0_mod11bBpsk_0_numBits   = R_main11_0_main11b_0_tx11b_0_mod11b_0_mod11bBpsk_0_numBits;
  parameter R_main11_0_main11b_0_tx11b_0_mod11b_0_mod11bQpsk_0_numBits   = 109;
  defparam  main11_0.R_main11b_0_tx11b_0_mod11b_0_mod11bQpsk_0_numBits   = R_main11_0_main11b_0_tx11b_0_mod11b_0_mod11bQpsk_0_numBits;
  parameter R_main11_0_main11b_0_tx11b_0_mod11b_0_mod11bCck_0_numBits    = 110;
  defparam  main11_0.R_main11b_0_tx11b_0_mod11b_0_mod11bCck_0_numBits    = R_main11_0_main11b_0_tx11b_0_mod11b_0_mod11bCck_0_numBits;
  parameter R_main11_0_main11b_0_tx11b_0_mod11b_0_mod11bCck_0_mode1      = 111;
  defparam  main11_0.R_main11b_0_tx11b_0_mod11b_0_mod11bCck_0_mode1      = R_main11_0_main11b_0_tx11b_0_mod11b_0_mod11bCck_0_mode1;
  parameter R_main11_0_main11b_0_tx11b_0_mod11b_0_modQpskZero_0_numZeros = 112;
  defparam  main11_0.R_main11b_0_tx11b_0_mod11b_0_modQpskZero_0_numZeros = R_main11_0_main11b_0_tx11b_0_mod11b_0_modQpskZero_0_numZeros;
  parameter R_main11_0_main11b_0_tx11b_0_src11to20_0_lut_cf11bTx_wrAdr   = 113;
  defparam  main11_0.R_main11b_0_tx11b_0_src11to20_0_lut_cf11bTx_wrAdr   = R_main11_0_main11b_0_tx11b_0_src11to20_0_lut_cf11bTx_wrAdr;
  parameter R_main11_0_main11b_0_tx11b_0_src11to20_0_lut_cf11bTx_wrDatHi = 114;
  defparam  main11_0.R_main11b_0_tx11b_0_src11to20_0_lut_cf11bTx_wrDatHi = R_main11_0_main11b_0_tx11b_0_src11to20_0_lut_cf11bTx_wrDatHi;
  parameter R_main11_0_main11b_0_tx11b_0_src11to20_0_lut_cf11bTx_wrDatLo = 115;
  defparam  main11_0.R_main11b_0_tx11b_0_src11to20_0_lut_cf11bTx_wrDatLo = R_main11_0_main11b_0_tx11b_0_src11to20_0_lut_cf11bTx_wrDatLo;
  parameter R_main11_0_main11b_0_tx11b_0_src11to20_0_lut_cf11bTx_simInit = 116;
  defparam  main11_0.R_main11b_0_tx11b_0_src11to20_0_lut_cf11bTx_simInit = R_main11_0_main11b_0_tx11b_0_src11to20_0_lut_cf11bTx_simInit;
  parameter R_main11_0_rtx80_0_run1                                      = 117;
  defparam  main11_0.R_rtx80_0_run1                                      = R_main11_0_rtx80_0_run1;
  parameter R_main11_0_rtx80_0_scaleTx_0_scFac                           = 118;
  defparam  main11_0.R_rtx80_0_scaleTx_0_scFac                           = R_main11_0_rtx80_0_scaleTx_0_scFac;
  parameter R_main11_0_rtx80_0_wdfSrc_0_cLo1                             = 119;
  defparam  main11_0.R_rtx80_0_wdfSrc_0_cLo1                             = R_main11_0_rtx80_0_wdfSrc_0_cLo1;
  parameter R_main11_0_rtx80_0_wdfSrc_0_cLo2                             = 120;
  defparam  main11_0.R_rtx80_0_wdfSrc_0_cLo2                             = R_main11_0_rtx80_0_wdfSrc_0_cLo2;
  parameter R_main11_0_rtx80_0_wdfSrc_0_cLo3                             = 121;
  defparam  main11_0.R_rtx80_0_wdfSrc_0_cLo3                             = R_main11_0_rtx80_0_wdfSrc_0_cLo3;
  parameter R_main11_0_rtx80_0_wdfSrc_0_cLo4                             = 122;
  defparam  main11_0.R_rtx80_0_wdfSrc_0_cLo4                             = R_main11_0_rtx80_0_wdfSrc_0_cLo4;
  parameter R_main11_0_rtx80_0_wdfSrc_0_cHi1                             = 123;
  defparam  main11_0.R_rtx80_0_wdfSrc_0_cHi1                             = R_main11_0_rtx80_0_wdfSrc_0_cHi1;
  parameter R_main11_0_rtx80_0_wdfSrc_0_cHi2                             = 124;
  defparam  main11_0.R_rtx80_0_wdfSrc_0_cHi2                             = R_main11_0_rtx80_0_wdfSrc_0_cHi2;
  parameter R_main11_0_rtx80_0_wdfSrc_0_singleAdc                        = 125;
  defparam  main11_0.R_rtx80_0_wdfSrc_0_singleAdc                        = R_main11_0_rtx80_0_wdfSrc_0_singleAdc;
  parameter R_main11_0_rtx80_0_freqShift_0_fShBr                         = 126;
  defparam  main11_0.R_rtx80_0_freqShift_0_fShBr                         = R_main11_0_rtx80_0_freqShift_0_fShBr;
  parameter R_main11_0_rtx80_0_dcOffCorr_0_corrOn                        = 127;
  defparam  main11_0.R_rtx80_0_dcOffCorr_0_corrOn                        = R_main11_0_rtx80_0_dcOffCorr_0_corrOn;
  parameter R_main11_0_rtx80_0_dcOffCorr_0_txDcOffRe                     = 128;
  defparam  main11_0.R_rtx80_0_dcOffCorr_0_txDcOffRe                     = R_main11_0_rtx80_0_dcOffCorr_0_txDcOffRe;
  parameter R_main11_0_rtx80_0_dcOffCorr_0_txDcOffIm                     = 129;
  defparam  main11_0.R_rtx80_0_dcOffCorr_0_txDcOffIm                     = R_main11_0_rtx80_0_dcOffCorr_0_txDcOffIm;
  parameter R_main11_0_rtx80_0_dcOffCorr_0_lut_rxDcOff_wrAdr             = 130;
  defparam  main11_0.R_rtx80_0_dcOffCorr_0_lut_rxDcOff_wrAdr             = R_main11_0_rtx80_0_dcOffCorr_0_lut_rxDcOff_wrAdr;
  parameter R_main11_0_rtx80_0_dcOffCorr_0_lut_rxDcOff_wrDatHi           = 131;
  defparam  main11_0.R_rtx80_0_dcOffCorr_0_lut_rxDcOff_wrDatHi           = R_main11_0_rtx80_0_dcOffCorr_0_lut_rxDcOff_wrDatHi;
  parameter R_main11_0_rtx80_0_dcOffCorr_0_lut_rxDcOff_wrDatLo           = 132;
  defparam  main11_0.R_rtx80_0_dcOffCorr_0_lut_rxDcOff_wrDatLo           = R_main11_0_rtx80_0_dcOffCorr_0_lut_rxDcOff_wrDatLo;
  parameter R_main11_0_rtx80_0_dcOffCorr_0_lut_rxDcOff_simInit           = 133;
  defparam  main11_0.R_rtx80_0_dcOffCorr_0_lut_rxDcOff_simInit           = R_main11_0_rtx80_0_dcOffCorr_0_lut_rxDcOff_simInit;
  parameter R_main11_0_rtx80_0_iqBuf_0_swSel                             = 134;
  defparam  main11_0.R_rtx80_0_iqBuf_0_swSel                             = R_main11_0_rtx80_0_iqBuf_0_swSel;
  parameter R_main11_0_rtx80_0_iqBuf_0_dataBufX32_iqBuf_run1             = 135;
  defparam  main11_0.R_rtx80_0_iqBuf_0_dataBufX32_iqBuf_run1             = R_main11_0_rtx80_0_iqBuf_0_dataBufX32_iqBuf_run1;
  parameter R_main11_0_rtx80_0_iqBuf_0_dataBufX32_iqBuf_datAdr           = 136;
  defparam  main11_0.R_rtx80_0_iqBuf_0_dataBufX32_iqBuf_datAdr           = R_main11_0_rtx80_0_iqBuf_0_dataBufX32_iqBuf_datAdr;
  parameter R_main11_0_rtx80_0_iqBuf_0_dataBufX32_iqBuf_datValLo         = 137;
  defparam  main11_0.R_rtx80_0_iqBuf_0_dataBufX32_iqBuf_datValLo         = R_main11_0_rtx80_0_iqBuf_0_dataBufX32_iqBuf_datValLo;
  parameter R_main11_0_rtx80_0_iqBuf_0_dataBufX32_iqBuf_datValHi         = 138;
  defparam  main11_0.R_rtx80_0_iqBuf_0_dataBufX32_iqBuf_datValHi         = R_main11_0_rtx80_0_iqBuf_0_dataBufX32_iqBuf_datValHi;
  parameter R_main11_0_rtx80_0_iqBuf_0_thrPass_0_run1                    = 139;
  defparam  main11_0.R_rtx80_0_iqBuf_0_thrPass_0_run1                    = R_main11_0_rtx80_0_iqBuf_0_thrPass_0_run1;
  parameter R_main11_0_rtx80_0_iqBuf_0_thrPass_0_thr                     = 140;
  defparam  main11_0.R_rtx80_0_iqBuf_0_thrPass_0_thr                     = R_main11_0_rtx80_0_iqBuf_0_thrPass_0_thr;
  parameter R_main11_0_rtx80_0_iqBuf_0_thrPass_0_trig                    = 141;
  defparam  main11_0.R_rtx80_0_iqBuf_0_thrPass_0_trig                    = R_main11_0_rtx80_0_iqBuf_0_thrPass_0_trig;
  parameter R_main11_0_agcMain_0_run1                                    = 142;
  defparam  main11_0.R_agcMain_0_run1                                    = R_main11_0_agcMain_0_run1;
  parameter R_main11_0_agcMain_0_numSteps                                = 143;
  defparam  main11_0.R_agcMain_0_numSteps                                = R_main11_0_agcMain_0_numSteps;
  parameter R_main11_0_agcMain_0_attnCur                                 = 144;
  defparam  main11_0.R_agcMain_0_attnCur                                 = R_main11_0_agcMain_0_attnCur;
  parameter R_main11_0_agcMain_0_attnCurReal                             = 145;
  defparam  main11_0.R_agcMain_0_attnCurReal                             = R_main11_0_agcMain_0_attnCurReal;
  parameter R_main11_0_agcMain_0_attnInit                                = 146;
  defparam  main11_0.R_agcMain_0_attnInit                                = R_main11_0_agcMain_0_attnInit;
  parameter R_main11_0_agcMain_0_attnTest                                = 147;
  defparam  main11_0.R_agcMain_0_attnTest                                = R_main11_0_agcMain_0_attnTest;
  parameter R_main11_0_agcMain_0_backOffTgt                              = 148;
  defparam  main11_0.R_agcMain_0_backOffTgt                              = R_main11_0_agcMain_0_backOffTgt;
  parameter R_main11_0_agcMain_0_attnInitUpdt                            = 149;
  defparam  main11_0.R_agcMain_0_attnInitUpdt                            = R_main11_0_agcMain_0_attnInitUpdt;
  parameter R_main11_0_agcMain_0_thrLo                                   = 150;
  defparam  main11_0.R_agcMain_0_thrLo                                   = R_main11_0_agcMain_0_thrLo;
  parameter R_main11_0_agcMain_0_thrHi                                   = 151;
  defparam  main11_0.R_agcMain_0_thrHi                                   = R_main11_0_agcMain_0_thrHi;
  parameter R_main11_0_agcMain_0_thrX                                    = 152;
  defparam  main11_0.R_agcMain_0_thrX                                    = R_main11_0_agcMain_0_thrX;
  parameter R_main11_0_agcMain_0_stepDb                                  = 153;
  defparam  main11_0.R_agcMain_0_stepDb                                  = R_main11_0_agcMain_0_stepDb;
  parameter R_main11_0_agcMain_0_waitSettle                              = 154;
  defparam  main11_0.R_agcMain_0_waitSettle                              = R_main11_0_agcMain_0_waitSettle;
  parameter R_main11_0_agcMain_0_waitFinal                               = 155;
  defparam  main11_0.R_agcMain_0_waitFinal                               = R_main11_0_agcMain_0_waitFinal;
  parameter R_main11_0_agcMain_0_lut_agc_wrAdr                           = 156;
  defparam  main11_0.R_agcMain_0_lut_agc_wrAdr                           = R_main11_0_agcMain_0_lut_agc_wrAdr;
  parameter R_main11_0_agcMain_0_lut_agc_wrDatHi                         = 157;
  defparam  main11_0.R_agcMain_0_lut_agc_wrDatHi                         = R_main11_0_agcMain_0_lut_agc_wrDatHi;
  parameter R_main11_0_agcMain_0_lut_agc_wrDatLo                         = 158;
  defparam  main11_0.R_agcMain_0_lut_agc_wrDatLo                         = R_main11_0_agcMain_0_lut_agc_wrDatLo;
  parameter R_main11_0_agcMain_0_lut_agc_simInit                         = 159;
  defparam  main11_0.R_agcMain_0_lut_agc_simInit                         = R_main11_0_agcMain_0_lut_agc_simInit;
  parameter R_main11_0_agcMain_0_agcRssi_0_singleAdc                     = 160;
  defparam  main11_0.R_agcMain_0_agcRssi_0_singleAdc                     = R_main11_0_agcMain_0_agcRssi_0_singleAdc;

  parameter R_main11_0_main11a_0_bridge_11a_fifoMst                      = 161;
  defparam  main11_0.R_main11a_0_bridge_11a_fifoMst                      = R_main11_0_main11a_0_bridge_11a_fifoMst;
  parameter R_main11_0_main11a_0_bridge_11a_ctrlMst                      = 162;
  defparam  main11_0.R_main11a_0_bridge_11a_ctrlMst                      = R_main11_0_main11a_0_bridge_11a_ctrlMst;
  parameter R_main11_0_main11a_0_bridge_11a_fifoSlv                      = 163;
  defparam  main11_0.R_main11a_0_bridge_11a_fifoSlv                      = R_main11_0_main11a_0_bridge_11a_fifoSlv;
  parameter R_main11_0_main11a_0_bridge_11a_ctrlSlv                      = 164;
  defparam  main11_0.R_main11a_0_bridge_11a_ctrlSlv                      = R_main11_0_main11a_0_bridge_11a_ctrlSlv;
  parameter R_main11_0_main11b_0_bridge_11b_fifoMst                      = 165;
  defparam  main11_0.R_main11b_0_bridge_11b_fifoMst                      = R_main11_0_main11b_0_bridge_11b_fifoMst;
  parameter R_main11_0_main11b_0_bridge_11b_ctrlMst                      = 166;
  defparam  main11_0.R_main11b_0_bridge_11b_ctrlMst                      = R_main11_0_main11b_0_bridge_11b_ctrlMst;
  parameter R_main11_0_main11b_0_bridge_11b_fifoSlv                      = 167;
  defparam  main11_0.R_main11b_0_bridge_11b_fifoSlv                      = R_main11_0_main11b_0_bridge_11b_fifoSlv;
  parameter R_main11_0_main11b_0_bridge_11b_ctrlSlv                      = 168;
  defparam  main11_0.R_main11b_0_bridge_11b_ctrlSlv                      = R_main11_0_main11b_0_bridge_11b_ctrlSlv;

  // FIFO address definitions - might be overwritten by an upper module
  parameter R_main11_0_main11a_0_tx11a_0_mod11a_0_qam2lpd                = 169;
  defparam  main11_0.R_main11a_0_tx11a_0_mod11a_0_qam2lpd                = R_main11_0_main11a_0_tx11a_0_mod11a_0_qam2lpd;
  parameter R_main11_0_main11a_0_rx11a_0_acq11a_0_ssNorm_0_ffIn          = 170;
  defparam  main11_0.R_main11a_0_rx11a_0_acq11a_0_ssNorm_0_ffIn          = R_main11_0_main11a_0_rx11a_0_acq11a_0_ssNorm_0_ffIn;
  parameter R_main11_0_main11a_0_rx11a_0_dem11a_0_ffIn                   = 171;
  defparam  main11_0.R_main11a_0_rx11a_0_dem11a_0_ffIn                   = R_main11_0_main11a_0_rx11a_0_dem11a_0_ffIn;
  parameter R_main11_0_main11a_0_rx11a_0_dec11a_0_ffD2D                  = 172;
  defparam  main11_0.R_main11a_0_rx11a_0_dec11a_0_ffD2D                  = R_main11_0_main11a_0_rx11a_0_dec11a_0_ffD2D;
  parameter R_main11_0_main11b_0_tx11b_0_ffMod2Src                       = 173;
  defparam  main11_0.R_main11b_0_tx11b_0_ffMod2Src                       = R_main11_0_main11b_0_tx11b_0_ffMod2Src;

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [main11_0_bOut_w-1:0]  main11_0_bOut;
  wire                                      main11_0_bOut_or;
  wire                                      main11_0_bOut_ff;
  wire                                      main11_0_bOut_we;

  wire               [main11_0_tx80_w-1:0]  main11_0_tx80;
  wire                                      main11_0_tx80_or;
  wire                                      main11_0_tx80_ff;
  wire                                      main11_0_tx80_we;

  wire               [main11_0_attn_w-1:0]  main11_0_attn;
  wire                                      main11_0_attn_or;
  wire                                      main11_0_attn_ff;
  wire                                      main11_0_attn_we;

  wire            [main11_0_yRxDbg0_w-1:0]  main11_0_yRxDbg0;
  wire                                      main11_0_yRxDbg0_or;
  wire                                      main11_0_yRxDbg0_ff;
  wire                                      main11_0_yRxDbg0_we;

  wire            [main11_0_yRxDbg1_w-1:0]  main11_0_yRxDbg1;
  wire                                      main11_0_yRxDbg1_or;
  wire                                      main11_0_yRxDbg1_ff;
  wire                                      main11_0_yRxDbg1_we;

  wire                [main11_0_bIn_w-1:0]  main11_0_bIn;
  wire                                      main11_0_bIn_ir;
  wire                                      main11_0_bIn_fe;
  wire                                      main11_0_bIn_re;

  wire               [main11_0_rx80_w-1:0]  main11_0_rx80;
  wire                                      main11_0_rx80_ir;
  wire                                      main11_0_rx80_fe;
  wire                                      main11_0_rx80_re;

  wire             [main11_0_irq11a_w-1:0]  main11_0_irq11a;
  wire             [main11_0_irq11b_w-1:0]  main11_0_irq11b;
  wire             [main11_0_dbgLed_w-1:0]  main11_0_dbgLed;

  wire                                      main11_0_regWe;
  wire                                      main11_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  main11 main11_0(main11_0_bOut, main11_0_bOut_or, main11_0_bOut_ff, main11_0_bOut_we,
                  main11_0_tx80, main11_0_tx80_or, main11_0_tx80_ff, main11_0_tx80_we,
                  main11_0_attn, main11_0_attn_or, main11_0_attn_ff, main11_0_attn_we,
                  main11_0_yRxDbg0, main11_0_yRxDbg0_or, main11_0_yRxDbg0_ff, main11_0_yRxDbg0_we,
                  main11_0_yRxDbg1, main11_0_yRxDbg1_or, main11_0_yRxDbg1_ff, main11_0_yRxDbg1_we,
                  main11_0_bIn, main11_0_bIn_ir, main11_0_bIn_fe, main11_0_bIn_re, 
                  main11_0_rx80, main11_0_rx80_ir, main11_0_rx80_fe, main11_0_rx80_re, 
                  main11_0_irq11a, 
                  main11_0_irq11b, 
                  main11_0_dbgLed, 
                  regBus, regWe, regRe, main11_0_regWe, main11_0_regRe, clk, clk2, reset);


//==============================================================================
