//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter lut_agc_adr_w           = 7;

  // Outputs
  parameter lut_agc_dat_w           = 23;

  // Input control lines

  // Output control lines

  // Eregs
  parameter lut_agc_wrAdr_w         = 7;
  parameter lut_agc_wrAdr_r         = 0;
  parameter lut_agc_wrAdr_s         = 0;
  parameter lut_agc_wrDatHi_w       = 16;
  parameter lut_agc_wrDatHi_r       = 0;
  parameter lut_agc_wrDatHi_s       = 0;
  parameter lut_agc_wrDatLo_w       = 16;
  parameter lut_agc_wrDatLo_r       = 0;
  parameter lut_agc_wrDatLo_s       = 0;
  parameter lut_agc_simInit_w       = 1;
  parameter lut_agc_simInit_r       = 0;
  parameter lut_agc_simInit_s       = 0;

  // Parameters
  parameter lut_agc_w               = 23;
  parameter lut_agc_n               = 70;
  parameter lut_agc_m               = 7;
  parameter lut_agc_lutDat          = 0;

  // Iregs

  // Single ported memories
  parameter lut_agc_lutMem_w        = 23;
  parameter lut_agc_lutMem_n        = 70;
  parameter lut_agc_lutMem_m        = `CLOG2(70);

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam lut_agc.adr_w           = lut_agc_adr_w;
  defparam lut_agc.dat_w           = lut_agc_dat_w;
  defparam lut_agc.wrAdr_w         = lut_agc_wrAdr_w;
  defparam lut_agc.wrAdr_r         = lut_agc_wrAdr_r;
  defparam lut_agc.wrAdr_s         = lut_agc_wrAdr_s;
  defparam lut_agc.wrDatHi_w       = lut_agc_wrDatHi_w;
  defparam lut_agc.wrDatHi_r       = lut_agc_wrDatHi_r;
  defparam lut_agc.wrDatHi_s       = lut_agc_wrDatHi_s;
  defparam lut_agc.wrDatLo_w       = lut_agc_wrDatLo_w;
  defparam lut_agc.wrDatLo_r       = lut_agc_wrDatLo_r;
  defparam lut_agc.wrDatLo_s       = lut_agc_wrDatLo_s;
  defparam lut_agc.simInit_w       = lut_agc_simInit_w;
  defparam lut_agc.simInit_r       = lut_agc_simInit_r;
  defparam lut_agc.simInit_s       = lut_agc_simInit_s;
  defparam lut_agc.w               = lut_agc_w;
  defparam lut_agc.n               = lut_agc_n;
  defparam lut_agc.m               = lut_agc_m;
  defparam lut_agc.lutDat          = lut_agc_lutDat;
  defparam lut_agc.lutMem_w        = lut_agc_lutMem_w;
  defparam lut_agc.lutMem_n        = lut_agc_lutMem_n;
  defparam lut_agc.lutMem_m        = lut_agc_lutMem_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_lut_agc_wrAdr                                              = 0;
  defparam  lut_agc.R_wrAdr                                              = R_lut_agc_wrAdr;
  parameter R_lut_agc_wrDatHi                                            = 1;
  defparam  lut_agc.R_wrDatHi                                            = R_lut_agc_wrDatHi;
  parameter R_lut_agc_wrDatLo                                            = 2;
  defparam  lut_agc.R_wrDatLo                                            = R_lut_agc_wrDatLo;
  parameter R_lut_agc_simInit                                            = 3;
  defparam  lut_agc.R_simInit                                            = R_lut_agc_simInit;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                 [lut_agc_dat_w-1:0]  lut_agc_dat;
  wire                                      lut_agc_dat_or;
  wire                                      lut_agc_dat_ff;
  wire                                      lut_agc_dat_we;

  wire                 [lut_agc_adr_w-1:0]  lut_agc_adr;
  wire                                      lut_agc_adr_ir;
  wire                                      lut_agc_adr_fe;
  wire                                      lut_agc_adr_re;

  wire                                      lut_agc_regWe;
  wire                                      lut_agc_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  lut lut_agc(lut_agc_dat, lut_agc_dat_or, lut_agc_dat_ff, lut_agc_dat_we,
              lut_agc_adr, lut_agc_adr_ir, lut_agc_adr_fe, lut_agc_adr_re, 
              regBus, regWe, regRe, lut_agc_regWe, lut_agc_regRe, clk, clk2, reset);


//==============================================================================
