//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter lsPltDat_0_x_w             = 20;

  // Outputs
  parameter lsPltDat_0_y_w             = 20;

  // Input control lines
  parameter lsPltDat_0_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter lsPltDat_0_w               = 10;
  parameter lsPltDat_0_bpskOne         = 128;

  // Iregs
  parameter lsPltDat_0_cntOfdm_w       = 2;
  parameter lsPltDat_0_cntOfdm_n       = 1;
  parameter lsPltDat_0_cntOfdm_m       = `CLOG2(1);
  parameter lsPltDat_0_pilotState_w    = 7;
  parameter lsPltDat_0_pilotState_n    = 1;
  parameter lsPltDat_0_pilotState_m    = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam lsPltDat_0.x_w             = lsPltDat_0_x_w;
  defparam lsPltDat_0.y_w             = lsPltDat_0_y_w;
  defparam lsPltDat_0.run1_w          = lsPltDat_0_run1_w;
  defparam lsPltDat_0.w               = lsPltDat_0_w;
  defparam lsPltDat_0.bpskOne         = lsPltDat_0_bpskOne;
  defparam lsPltDat_0.cntOfdm_w       = lsPltDat_0_cntOfdm_w;
  defparam lsPltDat_0.cntOfdm_n       = lsPltDat_0_cntOfdm_n;
  defparam lsPltDat_0.cntOfdm_m       = lsPltDat_0_cntOfdm_m;
  defparam lsPltDat_0.pilotState_w    = lsPltDat_0_pilotState_w;
  defparam lsPltDat_0.pilotState_n    = lsPltDat_0_pilotState_n;
  defparam lsPltDat_0.pilotState_m    = lsPltDat_0_pilotState_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                [lsPltDat_0_y_w-1:0]  lsPltDat_0_y;
  wire                                      lsPltDat_0_y_or;
  wire                                      lsPltDat_0_y_ff;
  wire                                      lsPltDat_0_y_we;

  wire                [lsPltDat_0_x_w-1:0]  lsPltDat_0_x;
  wire                                      lsPltDat_0_x_ir;
  wire                                      lsPltDat_0_x_fe;
  wire                                      lsPltDat_0_x_re;

  wire             [lsPltDat_0_run1_w-1:0]  lsPltDat_0_run1;

  wire                                      lsPltDat_0_regWe;
  wire                                      lsPltDat_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  lsPltDat lsPltDat_0(lsPltDat_0_y, lsPltDat_0_y_or, lsPltDat_0_y_ff, lsPltDat_0_y_we,
                      lsPltDat_0_x, lsPltDat_0_x_ir, lsPltDat_0_x_fe, lsPltDat_0_x_re, 
                      lsPltDat_0_run1, 
                      regBus, regWe, regRe, lsPltDat_0_regWe, lsPltDat_0_regRe, clk, clk2, reset);


//==============================================================================
