//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   lsPltDat
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module lsPltDat(y, y_or, y_ff, y_we, 
                x, x_ir, x_fe, x_re, 
                run1, 
                regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter x_w               = 0;

  parameter run1_w            = 0;

  parameter w                 = 0;
  parameter bpskOne           = 0;

  parameter cntOfdm_w         = 0;
  parameter cntOfdm_n         = 0;
  parameter cntOfdm_m         = 0;
  parameter pilotState_w      = 0;
  parameter pilotState_n      = 0;
  parameter pilotState_m      = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  input          [run1_w-1:0]  run1;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  // --------------------------------------------------------------------------------------
  // Internal status registers
  reg         [cntOfdm_w-1:0]  cntOfdm;
  reg      [pilotState_w-1:0]  pilotState;

  // --------------------------------------------------------------------------------------
  // Included instances
  `include "buf1_20.v"

  // --------------------------------------------------------------------------------------
  // Define connections
  assign y                         = buf1_20_y;
  assign y_or                      = buf1_20_y_or;
  assign buf1_20_y_ff              = y_ff;


  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | buf1_20_regWe;
  assign regReOut = 0 | buf1_20_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================

//-----------------------------------------------------------------------------------------
  // Define some states and the number of carriers belonging to the state
  parameter StZero0   =  0;    parameter CntZero0   =  6;
  parameter StData0   =  1;    parameter CntData0   =  5;
  parameter StPilot0  =  2;    parameter CntPilot0  =  1;
  parameter StData1   =  3;    parameter CntData1   = 13;
  parameter StPilot1  =  4;    parameter CntPilot1  =  1;
  parameter StData2   =  5;    parameter CntData2   =  6;
  parameter StZero1   =  6;    parameter CntZero1   =  1;
  parameter StData3   =  7;    parameter CntData3   =  6;
  parameter StPilot2  =  8;    parameter CntPilot2  =  1;
  parameter StData4   =  9;    parameter CntData4   = 13;
  parameter StPilot3  = 10;    parameter CntPilot3  =  1;
  parameter StData5   = 11;    parameter CntData5   =  5;
  parameter StZero2   = 12;    parameter CntZero2   =  5;

  // Registers and wires
  reg        [3:0]  state;                // Current state, see above
  reg        [3:0]  cntSc;                // Count the subcarriers
  reg        [1:0]  cnt4;                 // Count 0..3 for FFT output shift
  reg       [51:0]  lsPat;                // Long symbol pilots, MSB:LSB = c(-26:+26)
  wire   [2*w-1:0]  longSym, pilotSym;    // Long/pilot BSPK symbols
  wire   [2*w-1:0]  longSymData, pilotData;  
  wire   [2*w-1:0]  yR0;                  // Next output y, before [1 -j -1 j] rotation
  wire     [w-1:0]  yR0ReP, yR0ImP;       // Re/Im part, Pos     
  wire     [w-1:0]  yR0ReM, yR0ImM;       // Re/Im part, Neg
  reg      [w-1:0]  yR0Re, yR0Im;         // Final real/imag part
  
  wire              zeroSel;              // Pass zeros
  wire              longSymSel;           // Pass long symbols
  wire              pilotSel;             // Pass pilots
  wire              dataInt;              // Internal data creation flag
  wire              pilotFb;              // Pilot feedback
  
  wire       [y_w-1:0]  yP;                     // Preliminary output
  wire                  yP_we, yP_or, yP_ff;  // before buffering
  
  // --------------------------------------------------------------------------
  // Copy this autogenerated stuff to avoid non-causal use of yP
  assign buf1_20_x                 = yP;
  assign buf1_20_x_fe              = ~yP_or;
  assign yP_ff                     = ~buf1_20_x_ir;

  // --------------------------------------------------------------------------
  assign zeroSel    = (state==StZero0) | (state==StZero1) | (state==StZero2);
  assign longSymSel = (cntOfdm[1]==0);
  assign pilotSel   = (state==StPilot0) | (state==StPilot1) | 
                      (state==StPilot2) | (state==StPilot3);
  
  // Define when data is produced internally
  assign dataInt = zeroSel | longSymSel | pilotSel;

    // Assign long symbol output
  assign longSym[w-1:0]    = lsPat[51] ? -bpskOne : bpskOne; // Real part
  assign longSym[2*w-1:w]  = 0;                              // Imag part
  
  // Assign pilots
  assign pilotFb           = pilotState[6]^pilotState[3];    // Pilot feedback
  assign pilotSym[w-1:0]   = pilotFb^(state==StPilot3) ? -bpskOne : bpskOne;
  assign pilotSym[2*w-1:w] = 0;
  
  // Define multiplexors for output data
  assign pilotData    = pilotSel    ? pilotSym : x;
  assign longSymData  = longSymSel  ? longSym  : pilotData;
  assign yR0          = zeroSel     ? 0        : longSymData;
  
  // Define output multiplication by [1 -1 1 -1 ...] or [1 -j -1 j 1 -j ...]
  assign yR0ReP = yR0[w-1:0];
  assign yR0ImP = yR0[2*w-1:w];
  assign yR0ReM = -yR0ReP;
  assign yR0ImM = -yR0ImP;

  always @(*) begin
    case (cnt4)
      0: yR0Re = yR0ReP;
      1: yR0Re = yR0ImP;
      2: yR0Re = yR0ReM;
      3: yR0Re = yR0ImM;
    endcase

    case (cnt4)
      0: yR0Im = yR0ImP;
      1: yR0Im = yR0ReM;
      2: yR0Im = yR0ImM;
      3: yR0Im = yR0ReP;
    endcase
  end
      
  // --------------------------------------------------------------------------
  // Assign input/output enable
  assign x_ir   = run1 & (yP_ff==0 & dataInt==0); 
  assign yP_or  = run1 & ( x_fe==0 | dataInt==1);
  assign yP_we  = yP_or & ~yP_ff;
  assign yP     = {yR0Im, yR0Re};

  // Output buffer control
  assign buf1_20_run1 = run1;
  
  // --------------------------------------------------------------------------
  // Main FSM
  always @(posedge clk) begin
 
    // Reset
    if (run1==0) begin
      state       <= StZero0;
      cntSc       <= CntZero0;
      cntOfdm     <= 0;
      cnt4        <= 0;
      lsPat       <= 52'b0011001010000001100101000001100101011111001101010000;
      pilotState  <= 7'b1111111;
    end else 
    
    // Normal operation
    if (yP_we) begin

      if (cntOfdm==0) begin
        cnt4 <= cnt4+2;                     // Count up phase shift by 2 for the 1st OFDM
      end else begin                        // symbol or by 1 otherwise
        cnt4 <= cnt4+1;
      end
      if (zeroSel==0) begin                 // Rotate long symbol pattern
        lsPat <= {lsPat[50:0], lsPat[51]};  // Start with c(-26:26) = [MSB:LSB]
      end

      if (cntSc!=1) begin             // if cnt!=1
        cntSc <= cntSc-1;             //   -> count down the number of subcarriers
      end else begin                  //      of the current state
        if (state == StZero0) begin   // else
          state <= StData0;           //   -> Goto the next state, and set the 
          cntSc <= CntData0;          //      number of carriers of the next state
        end else
        if (state == StData0) begin
          state <= StPilot0;
          cntSc <= CntPilot0;
        end else
        if (state == StPilot0) begin
          state <= StData1;
          cntSc <= CntData1;
        end else
        if (state == StData1) begin
          state <= StPilot1;
          cntSc <= CntPilot1;
        end else
        if (state == StPilot1) begin
          state <= StData2;
          cntSc <= CntData2;
        end else
        if (state == StData2) begin
          state <= StZero1;
          cntSc <= CntZero1;
        end else
        if (state == StZero1) begin
          state <= StData3;
          cntSc <= CntData3;
        end else
        if (state == StData3) begin
          state <= StPilot2;
          cntSc <= CntPilot2;
        end else
        if (state == StPilot2) begin
          state <= StData4;
          cntSc <= CntData4;
        end else
        if (state == StData4) begin
          state <= StPilot3;
          cntSc <= CntPilot3;
        end else
        if (state == StPilot3) begin
          state <= StData5;
          cntSc <= CntData5;
        end else
        if (state == StData5) begin
          state <= StZero2;
          cntSc <= CntZero2;
        end else
        if (state == StZero2) begin
          state   <= StZero0;
          cntSc   <= CntZero0;
          if (cntOfdm[1]==0) begin      // If OFDM symbol no <= 1
            cntOfdm     <= cntOfdm+1;   // Count up OFDM symbols
          end else begin                // Goto next pilot state
            pilotState  <= {pilotState[5:0], pilotFb};
          end
        end // if (state==...)
      end // if (cnt!=1) begin .. else
    end // if (yP_we) begin
  end // always  

endmodule
//=========================================================================================

