//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter lsCcf_0_x_w             = 20;
  parameter lsCcf_0_xFft_w          = 20;

  // Outputs
  parameter lsCcf_0_yAbs_w          = 10;
  parameter lsCcf_0_yFft_w          = 20;
  parameter lsCcf_0_yC_w            = 20;

  // Input control lines
  parameter lsCcf_0_run1_w          = 3;

  // Output control lines
  parameter lsCcf_0_irqFteDone_w    = 1;
  parameter lsCcf_0_irqCtfDone_w    = 1;

  // Eregs
  parameter lsCcf_0_peakPos_w       = 6;
  parameter lsCcf_0_peakPos_r       = 0;
  parameter lsCcf_0_peakPos_s       = 0;
  parameter lsCcf_0_peakVal_w       = 10;
  parameter lsCcf_0_peakVal_r       = 0;
  parameter lsCcf_0_peakVal_s       = 0;

  // Parameters
  parameter lsCcf_0_wx              = 10;
  parameter lsCcf_0_wa              = 10;
  parameter lsCcf_0_wc              = 10;
  parameter lsCcf_0_wf              = 10;
  parameter lsCcf_0_StFft           = 0;
  parameter lsCcf_0_StMul           = 1;
  parameter lsCcf_0_StMax           = 2;
  parameter lsCcf_0_StHalt          = 3;
  parameter lsCcf_0_ModeReset       = 0;
  parameter lsCcf_0_ModeFte         = 1;
  parameter lsCcf_0_ModeChEst       = 2;
  parameter lsCcf_0_ModeChCor       = 3;
  parameter lsCcf_0_SyncOff         = 0;
  parameter lsCcf_0_SyncFte         = 1;
  parameter lsCcf_0_SyncFfe         = 2;
  parameter lsCcf_0_SyncAmpEst      = 3;
  parameter lsCcf_0_SyncChEst       = 4;
  parameter lsCcf_0_SyncChCor       = 5;

  // Iregs
  parameter lsCcf_0_state_w         = 2;
  parameter lsCcf_0_state_n         = 1;
  parameter lsCcf_0_state_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam lsCcf_0.x_w             = lsCcf_0_x_w;
  defparam lsCcf_0.xFft_w          = lsCcf_0_xFft_w;
  defparam lsCcf_0.yAbs_w          = lsCcf_0_yAbs_w;
  defparam lsCcf_0.yFft_w          = lsCcf_0_yFft_w;
  defparam lsCcf_0.yC_w            = lsCcf_0_yC_w;
  defparam lsCcf_0.run1_w          = lsCcf_0_run1_w;
  defparam lsCcf_0.irqFteDone_w    = lsCcf_0_irqFteDone_w;
  defparam lsCcf_0.irqCtfDone_w    = lsCcf_0_irqCtfDone_w;
  defparam lsCcf_0.peakPos_w       = lsCcf_0_peakPos_w;
  defparam lsCcf_0.peakPos_r       = lsCcf_0_peakPos_r;
  defparam lsCcf_0.peakPos_s       = lsCcf_0_peakPos_s;
  defparam lsCcf_0.peakVal_w       = lsCcf_0_peakVal_w;
  defparam lsCcf_0.peakVal_r       = lsCcf_0_peakVal_r;
  defparam lsCcf_0.peakVal_s       = lsCcf_0_peakVal_s;
  defparam lsCcf_0.wx              = lsCcf_0_wx;
  defparam lsCcf_0.wa              = lsCcf_0_wa;
  defparam lsCcf_0.wc              = lsCcf_0_wc;
  defparam lsCcf_0.wf              = lsCcf_0_wf;
  defparam lsCcf_0.StFft           = lsCcf_0_StFft;
  defparam lsCcf_0.StMul           = lsCcf_0_StMul;
  defparam lsCcf_0.StMax           = lsCcf_0_StMax;
  defparam lsCcf_0.StHalt          = lsCcf_0_StHalt;
  defparam lsCcf_0.ModeReset       = lsCcf_0_ModeReset;
  defparam lsCcf_0.ModeFte         = lsCcf_0_ModeFte;
  defparam lsCcf_0.ModeChEst       = lsCcf_0_ModeChEst;
  defparam lsCcf_0.ModeChCor       = lsCcf_0_ModeChCor;
  defparam lsCcf_0.SyncOff         = lsCcf_0_SyncOff;
  defparam lsCcf_0.SyncFte         = lsCcf_0_SyncFte;
  defparam lsCcf_0.SyncFfe         = lsCcf_0_SyncFfe;
  defparam lsCcf_0.SyncAmpEst      = lsCcf_0_SyncAmpEst;
  defparam lsCcf_0.SyncChEst       = lsCcf_0_SyncChEst;
  defparam lsCcf_0.SyncChCor       = lsCcf_0_SyncChCor;
  defparam lsCcf_0.state_w         = lsCcf_0_state_w;
  defparam lsCcf_0.state_n         = lsCcf_0_state_n;
  defparam lsCcf_0.state_m         = lsCcf_0_state_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_lsCcf_0_peakPos                                            = 0;
  defparam  lsCcf_0.R_peakPos                                            = R_lsCcf_0_peakPos;
  parameter R_lsCcf_0_peakVal                                            = 1;
  defparam  lsCcf_0.R_peakVal                                            = R_lsCcf_0_peakVal;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                [lsCcf_0_yAbs_w-1:0]  lsCcf_0_yAbs;
  wire                                      lsCcf_0_yAbs_or;
  wire                                      lsCcf_0_yAbs_ff;
  wire                                      lsCcf_0_yAbs_we;

  wire                [lsCcf_0_yFft_w-1:0]  lsCcf_0_yFft;
  wire                                      lsCcf_0_yFft_or;
  wire                                      lsCcf_0_yFft_ff;
  wire                                      lsCcf_0_yFft_we;

  wire                  [lsCcf_0_yC_w-1:0]  lsCcf_0_yC;
  wire                                      lsCcf_0_yC_or;
  wire                                      lsCcf_0_yC_ff;
  wire                                      lsCcf_0_yC_we;

  wire                   [lsCcf_0_x_w-1:0]  lsCcf_0_x;
  wire                                      lsCcf_0_x_ir;
  wire                                      lsCcf_0_x_fe;
  wire                                      lsCcf_0_x_re;

  wire                [lsCcf_0_xFft_w-1:0]  lsCcf_0_xFft;
  wire                                      lsCcf_0_xFft_ir;
  wire                                      lsCcf_0_xFft_fe;
  wire                                      lsCcf_0_xFft_re;

  wire          [lsCcf_0_irqFteDone_w-1:0]  lsCcf_0_irqFteDone;
  wire          [lsCcf_0_irqCtfDone_w-1:0]  lsCcf_0_irqCtfDone;

  wire                [lsCcf_0_run1_w-1:0]  lsCcf_0_run1;

  wire                                      lsCcf_0_regWe;
  wire                                      lsCcf_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  lsCcf lsCcf_0(lsCcf_0_yAbs, lsCcf_0_yAbs_or, lsCcf_0_yAbs_ff, lsCcf_0_yAbs_we,
                lsCcf_0_yFft, lsCcf_0_yFft_or, lsCcf_0_yFft_ff, lsCcf_0_yFft_we,
                lsCcf_0_yC, lsCcf_0_yC_or, lsCcf_0_yC_ff, lsCcf_0_yC_we,
                lsCcf_0_x, lsCcf_0_x_ir, lsCcf_0_x_fe, lsCcf_0_x_re, 
                lsCcf_0_xFft, lsCcf_0_xFft_ir, lsCcf_0_xFft_fe, lsCcf_0_xFft_re, 
                lsCcf_0_irqFteDone, 
                lsCcf_0_irqCtfDone, 
                lsCcf_0_run1, 
                regBus, regWe, regRe, lsCcf_0_regWe, lsCcf_0_regRe, clk, clk2, reset);


//==============================================================================
