//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs

  // Outputs

  // Input control lines
  parameter irqCtrl_11b_irqIn_w         = 16;

  // Output control lines
  parameter irqCtrl_11b_irqOut_w        = 1;

  // Eregs
  parameter irqCtrl_11b_run1_w          = 1;
  parameter irqCtrl_11b_run1_r          = 0;
  parameter irqCtrl_11b_run1_s          = 0;
  parameter irqCtrl_11b_irqStat_w       = 16;
  parameter irqCtrl_11b_irqStat_r       = 0;
  parameter irqCtrl_11b_irqStat_s       = 0;
  parameter irqCtrl_11b_irqEdgeLevel_w  = 16;
  parameter irqCtrl_11b_irqEdgeLevel_r  = 0;
  parameter irqCtrl_11b_irqEdgeLevel_s  = 0;
  parameter irqCtrl_11b_irqMaskIn_w     = 16;
  parameter irqCtrl_11b_irqMaskIn_r     = 0;
  parameter irqCtrl_11b_irqMaskIn_s     = 0;
  parameter irqCtrl_11b_irqMaskOut_w    = 16;
  parameter irqCtrl_11b_irqMaskOut_r    = 0;
  parameter irqCtrl_11b_irqMaskOut_s    = 0;
  parameter irqCtrl_11b_irqClr_w        = 0;
  parameter irqCtrl_11b_irqClr_r        = 0;
  parameter irqCtrl_11b_irqClr_s        = 0;
  parameter irqCtrl_11b_irqSet_w        = 0;
  parameter irqCtrl_11b_irqSet_r        = 0;
  parameter irqCtrl_11b_irqSet_s        = 0;
  parameter irqCtrl_11b_irqIdx_w        = 4;
  parameter irqCtrl_11b_irqIdx_r        = 0;
  parameter irqCtrl_11b_irqIdx_s        = 0;

  // Parameters
  parameter irqCtrl_11b_w               = 16;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam irqCtrl_11b.irqIn_w         = irqCtrl_11b_irqIn_w;
  defparam irqCtrl_11b.irqOut_w        = irqCtrl_11b_irqOut_w;
  defparam irqCtrl_11b.run1_w          = irqCtrl_11b_run1_w;
  defparam irqCtrl_11b.run1_r          = irqCtrl_11b_run1_r;
  defparam irqCtrl_11b.run1_s          = irqCtrl_11b_run1_s;
  defparam irqCtrl_11b.irqStat_w       = irqCtrl_11b_irqStat_w;
  defparam irqCtrl_11b.irqStat_r       = irqCtrl_11b_irqStat_r;
  defparam irqCtrl_11b.irqStat_s       = irqCtrl_11b_irqStat_s;
  defparam irqCtrl_11b.irqEdgeLevel_w  = irqCtrl_11b_irqEdgeLevel_w;
  defparam irqCtrl_11b.irqEdgeLevel_r  = irqCtrl_11b_irqEdgeLevel_r;
  defparam irqCtrl_11b.irqEdgeLevel_s  = irqCtrl_11b_irqEdgeLevel_s;
  defparam irqCtrl_11b.irqMaskIn_w     = irqCtrl_11b_irqMaskIn_w;
  defparam irqCtrl_11b.irqMaskIn_r     = irqCtrl_11b_irqMaskIn_r;
  defparam irqCtrl_11b.irqMaskIn_s     = irqCtrl_11b_irqMaskIn_s;
  defparam irqCtrl_11b.irqMaskOut_w    = irqCtrl_11b_irqMaskOut_w;
  defparam irqCtrl_11b.irqMaskOut_r    = irqCtrl_11b_irqMaskOut_r;
  defparam irqCtrl_11b.irqMaskOut_s    = irqCtrl_11b_irqMaskOut_s;
  defparam irqCtrl_11b.irqClr_w        = irqCtrl_11b_irqClr_w;
  defparam irqCtrl_11b.irqClr_r        = irqCtrl_11b_irqClr_r;
  defparam irqCtrl_11b.irqClr_s        = irqCtrl_11b_irqClr_s;
  defparam irqCtrl_11b.irqSet_w        = irqCtrl_11b_irqSet_w;
  defparam irqCtrl_11b.irqSet_r        = irqCtrl_11b_irqSet_r;
  defparam irqCtrl_11b.irqSet_s        = irqCtrl_11b_irqSet_s;
  defparam irqCtrl_11b.irqIdx_w        = irqCtrl_11b_irqIdx_w;
  defparam irqCtrl_11b.irqIdx_r        = irqCtrl_11b_irqIdx_r;
  defparam irqCtrl_11b.irqIdx_s        = irqCtrl_11b_irqIdx_s;
  defparam irqCtrl_11b.w               = irqCtrl_11b_w;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_irqCtrl_11b_run1                                           = 0;
  defparam  irqCtrl_11b.R_run1                                           = R_irqCtrl_11b_run1;
  parameter R_irqCtrl_11b_irqStat                                        = 1;
  defparam  irqCtrl_11b.R_irqStat                                        = R_irqCtrl_11b_irqStat;
  parameter R_irqCtrl_11b_irqEdgeLevel                                   = 2;
  defparam  irqCtrl_11b.R_irqEdgeLevel                                   = R_irqCtrl_11b_irqEdgeLevel;
  parameter R_irqCtrl_11b_irqMaskIn                                      = 3;
  defparam  irqCtrl_11b.R_irqMaskIn                                      = R_irqCtrl_11b_irqMaskIn;
  parameter R_irqCtrl_11b_irqMaskOut                                     = 4;
  defparam  irqCtrl_11b.R_irqMaskOut                                     = R_irqCtrl_11b_irqMaskOut;
  parameter R_irqCtrl_11b_irqClr                                         = 5;
  defparam  irqCtrl_11b.R_irqClr                                         = R_irqCtrl_11b_irqClr;
  parameter R_irqCtrl_11b_irqSet                                         = 6;
  defparam  irqCtrl_11b.R_irqSet                                         = R_irqCtrl_11b_irqSet;
  parameter R_irqCtrl_11b_irqIdx                                         = 7;
  defparam  irqCtrl_11b.R_irqIdx                                         = R_irqCtrl_11b_irqIdx;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire          [irqCtrl_11b_irqOut_w-1:0]  irqCtrl_11b_irqOut;

  wire           [irqCtrl_11b_irqIn_w-1:0]  irqCtrl_11b_irqIn;

  wire                                      irqCtrl_11b_regWe;
  wire                                      irqCtrl_11b_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  irqCtrl irqCtrl_11b(irqCtrl_11b_irqOut, 
                      irqCtrl_11b_irqIn, 
                      regBus, regWe, regRe, irqCtrl_11b_regWe, irqCtrl_11b_regRe, clk, clk2, reset);


//==============================================================================
