//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter iqBuf_0_xTx_w           = 24;
  parameter iqBuf_0_xRx_w           = 24;

  // Outputs
  parameter iqBuf_0_yTx_w           = 24;
  parameter iqBuf_0_yRx_w           = 24;

  // Input control lines

  // Output control lines

  // Eregs
  parameter iqBuf_0_swSel_w         = 6;
  parameter iqBuf_0_swSel_r         = 36;
  parameter iqBuf_0_swSel_s         = 0;

  // Parameters
  parameter iqBuf_0_w               = 12;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam iqBuf_0.xTx_w           = iqBuf_0_xTx_w;
  defparam iqBuf_0.xRx_w           = iqBuf_0_xRx_w;
  defparam iqBuf_0.yTx_w           = iqBuf_0_yTx_w;
  defparam iqBuf_0.yRx_w           = iqBuf_0_yRx_w;
  defparam iqBuf_0.swSel_w         = iqBuf_0_swSel_w;
  defparam iqBuf_0.swSel_r         = iqBuf_0_swSel_r;
  defparam iqBuf_0.swSel_s         = iqBuf_0_swSel_s;
  defparam iqBuf_0.w               = iqBuf_0_w;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_iqBuf_0_swSel                                              = 0;
  defparam  iqBuf_0.R_swSel                                              = R_iqBuf_0_swSel;
  parameter R_iqBuf_0_dataBufX32_iqBuf_run1                              = 1;
  defparam  iqBuf_0.R_dataBufX32_iqBuf_run1                              = R_iqBuf_0_dataBufX32_iqBuf_run1;
  parameter R_iqBuf_0_dataBufX32_iqBuf_datAdr                            = 2;
  defparam  iqBuf_0.R_dataBufX32_iqBuf_datAdr                            = R_iqBuf_0_dataBufX32_iqBuf_datAdr;
  parameter R_iqBuf_0_dataBufX32_iqBuf_datValLo                          = 3;
  defparam  iqBuf_0.R_dataBufX32_iqBuf_datValLo                          = R_iqBuf_0_dataBufX32_iqBuf_datValLo;
  parameter R_iqBuf_0_dataBufX32_iqBuf_datValHi                          = 4;
  defparam  iqBuf_0.R_dataBufX32_iqBuf_datValHi                          = R_iqBuf_0_dataBufX32_iqBuf_datValHi;
  parameter R_iqBuf_0_thrPass_0_run1                                     = 5;
  defparam  iqBuf_0.R_thrPass_0_run1                                     = R_iqBuf_0_thrPass_0_run1;
  parameter R_iqBuf_0_thrPass_0_thr                                      = 6;
  defparam  iqBuf_0.R_thrPass_0_thr                                      = R_iqBuf_0_thrPass_0_thr;
  parameter R_iqBuf_0_thrPass_0_trig                                     = 7;
  defparam  iqBuf_0.R_thrPass_0_trig                                     = R_iqBuf_0_thrPass_0_trig;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                 [iqBuf_0_yTx_w-1:0]  iqBuf_0_yTx;
  wire                                      iqBuf_0_yTx_or;
  wire                                      iqBuf_0_yTx_ff;
  wire                                      iqBuf_0_yTx_we;

  wire                 [iqBuf_0_yRx_w-1:0]  iqBuf_0_yRx;
  wire                                      iqBuf_0_yRx_or;
  wire                                      iqBuf_0_yRx_ff;
  wire                                      iqBuf_0_yRx_we;

  wire                 [iqBuf_0_xTx_w-1:0]  iqBuf_0_xTx;
  wire                                      iqBuf_0_xTx_ir;
  wire                                      iqBuf_0_xTx_fe;
  wire                                      iqBuf_0_xTx_re;

  wire                 [iqBuf_0_xRx_w-1:0]  iqBuf_0_xRx;
  wire                                      iqBuf_0_xRx_ir;
  wire                                      iqBuf_0_xRx_fe;
  wire                                      iqBuf_0_xRx_re;

  wire                                      iqBuf_0_regWe;
  wire                                      iqBuf_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  iqBuf iqBuf_0(iqBuf_0_yTx, iqBuf_0_yTx_or, iqBuf_0_yTx_ff, iqBuf_0_yTx_we,
                iqBuf_0_yRx, iqBuf_0_yRx_or, iqBuf_0_yRx_ff, iqBuf_0_yRx_we,
                iqBuf_0_xTx, iqBuf_0_xTx_ir, iqBuf_0_xTx_fe, iqBuf_0_xTx_re, 
                iqBuf_0_xRx, iqBuf_0_xRx_ir, iqBuf_0_xRx_fe, iqBuf_0_xRx_re, 
                regBus, regWe, regRe, iqBuf_0_regWe, iqBuf_0_regRe, clk, clk2, reset);


//==============================================================================
