//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   iqBuf
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module iqBuf(yTx, yTx_or, yTx_ff, yTx_we, 
             yRx, yRx_or, yRx_ff, yRx_we, 
             xTx, xTx_ir, xTx_fe, xTx_re, 
             xRx, xRx_ir, xRx_fe, xRx_re, 
             regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Include global definitions
  `include "def_Const_wlan.v"

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter yTx_w             = 0;
  parameter yRx_w             = 0;
  parameter xTx_w             = 0;
  parameter xRx_w             = 0;


  parameter swSel_w           = 0;
  parameter swSel_r           = 0;
  parameter swSel_s           = 0;
  parameter R_swSel           = 0;

  parameter w                 = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output          [yTx_w-1:0]  yTx;
  output                       yTx_or;
  input                        yTx_ff;
  output                       yTx_we;
  assign                       yTx_we = yTx_or & ~yTx_ff;

  output          [yRx_w-1:0]  yRx;
  output                       yRx_or;
  input                        yRx_ff;
  output                       yRx_we;
  assign                       yRx_we = yRx_or & ~yRx_ff;

  input           [xTx_w-1:0]  xTx;
  output                       xTx_ir;
  input                        xTx_fe;
  output                       xTx_re;
  assign                       xTx_re = xTx_ir & ~xTx_fe;

  input           [xRx_w-1:0]  xRx;
  output                       xRx_ir;
  input                        xRx_fe;
  output                       xRx_re;
  assign                       xRx_re = xRx_ir & ~xRx_fe;


  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire          [swSel_w-1:0]  swSel_q;
  wire          [swSel_w-1:0]  swSel_d;
  wire                         swSel_weint;
  assign                       swSel_weint = 0;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg swSel(swSel_q, regBus, swSel_d, swSel_weint, regWe, regRe, clk, reset);
  defparam swSel.w    = swSel_w;
  defparam swSel.rval = swSel_r;
  defparam swSel.sgn  = swSel_s;
  defparam swSel.adr  = R_swSel;

  // --------------------------------------------------------------------------------------
  // Included instances
  `include "dataBufX32_iqBuf.v"
  `include "thrPass_0.v"
  `include "s1To2Sel_24a.v"
  `include "s1To2Sel_24b.v"
  `include "s1To2Sel_24c.v"
  `include "s2To1Sel_24a.v"
  `include "s2To1Sel_24b.v"
  `include "s2To1Sel_24c.v"

  // --------------------------------------------------------------------------------------
  // Define connections
  assign s1To2Sel_24a_x            = xTx;
  assign s1To2Sel_24a_x_fe         = xTx_fe;
  assign xTx_ir                    = s1To2Sel_24a_x_ir;

  assign s2To1Sel_24a_x0           = s1To2Sel_24a_y0;
  assign s2To1Sel_24a_x0_fe        = ~s1To2Sel_24a_y0_or;
  assign s1To2Sel_24a_y0_ff        = ~s2To1Sel_24a_x0_ir;

  assign s2To1Sel_24b_x0           = s1To2Sel_24a_y1;
  assign s2To1Sel_24b_x0_fe        = ~s1To2Sel_24a_y1_or;
  assign s1To2Sel_24a_y1_ff        = ~s2To1Sel_24b_x0_ir;

  assign yTx                       = s2To1Sel_24a_y;
  assign yTx_or                    = s2To1Sel_24a_y_or;
  assign s2To1Sel_24a_y_ff         = yTx_ff;

  assign s2To1Sel_24b_x1           = thrPass_0_y;
  assign s2To1Sel_24b_x1_fe        = ~thrPass_0_y_or;
  assign thrPass_0_y_ff            = ~s2To1Sel_24b_x1_ir;

  assign dataBufX32_iqBuf_x        = s2To1Sel_24b_y;
  assign dataBufX32_iqBuf_x_fe     = ~s2To1Sel_24b_y_or;
  assign s2To1Sel_24b_y_ff         = ~dataBufX32_iqBuf_x_ir;

  assign s1To2Sel_24b_x            = dataBufX32_iqBuf_y;
  assign s1To2Sel_24b_x_fe         = ~dataBufX32_iqBuf_y_or;
  assign dataBufX32_iqBuf_y_ff     = ~s1To2Sel_24b_x_ir;

  assign s2To1Sel_24a_x1           = s1To2Sel_24b_y0;
  assign s2To1Sel_24a_x1_fe        = ~s1To2Sel_24b_y0_or;
  assign s1To2Sel_24b_y0_ff        = ~s2To1Sel_24a_x1_ir;

  assign s2To1Sel_24c_x0           = s1To2Sel_24b_y1;
  assign s2To1Sel_24c_x0_fe        = ~s1To2Sel_24b_y1_or;
  assign s1To2Sel_24b_y1_ff        = ~s2To1Sel_24c_x0_ir;

  assign s1To2Sel_24c_x            = xRx;
  assign s1To2Sel_24c_x_fe         = xRx_fe;
  assign xRx_ir                    = s1To2Sel_24c_x_ir;

  assign thrPass_0_x               = s1To2Sel_24c_y0;
  assign thrPass_0_x_fe            = ~s1To2Sel_24c_y0_or;
  assign s1To2Sel_24c_y0_ff        = ~thrPass_0_x_ir;

  assign s2To1Sel_24c_x1           = s1To2Sel_24c_y1;
  assign s2To1Sel_24c_x1_fe        = ~s1To2Sel_24c_y1_or;
  assign s1To2Sel_24c_y1_ff        = ~s2To1Sel_24c_x1_ir;

  assign yRx                       = s2To1Sel_24c_y;
  assign yRx_or                    = s2To1Sel_24c_y_or;
  assign s2To1Sel_24c_y_ff         = yRx_ff;


  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | dataBufX32_iqBuf_regWe | thrPass_0_regWe | s1To2Sel_24a_regWe
                      | s1To2Sel_24b_regWe | s1To2Sel_24c_regWe | s2To1Sel_24a_regWe
                      | s2To1Sel_24b_regWe | s2To1Sel_24c_regWe;
  assign regReOut = 0 | dataBufX32_iqBuf_regRe | thrPass_0_regRe | s1To2Sel_24a_regRe
                      | s1To2Sel_24b_regRe | s1To2Sel_24c_regRe | s2To1Sel_24a_regRe
                      | s2To1Sel_24b_regRe | s2To1Sel_24c_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // Assign switches
  assign s1To2Sel_24a_sel = swSel_q[0];
  assign s1To2Sel_24b_sel = swSel_q[1];
  assign s1To2Sel_24c_sel = swSel_q[2];
  assign s2To1Sel_24a_sel = swSel_q[3];
  assign s2To1Sel_24b_sel = swSel_q[4];
  assign s2To1Sel_24c_sel = swSel_q[5];

endmodule
//=========================================================================================

