//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter intlv_0_x_w             = 1;

  // Outputs
  parameter intlv_0_y_w             = 1;

  // Input control lines
  parameter intlv_0_run1_w          = 1;

  // Output control lines
  parameter intlv_0_irqHdrDone_w    = 1;

  // Eregs
  parameter intlv_0_mode1_w         = 2;
  parameter intlv_0_mode1_r         = 0;
  parameter intlv_0_mode1_s         = 0;

  // Parameters

  // Iregs
  parameter intlv_0_cntOfdmWr_w     = 1;
  parameter intlv_0_cntOfdmWr_n     = 1;
  parameter intlv_0_cntOfdmWr_m     = `CLOG2(1);
  parameter intlv_0_cntOfdmRd_w     = 1;
  parameter intlv_0_cntOfdmRd_n     = 1;
  parameter intlv_0_cntOfdmRd_m     = `CLOG2(1);

  // Single ported memories
  parameter intlv_0_mem0_w          = 1;
  parameter intlv_0_mem0_n          = 288;
  parameter intlv_0_mem0_m          = `CLOG2(288);
  parameter intlv_0_mem1_w          = 1;
  parameter intlv_0_mem1_n          = 288;
  parameter intlv_0_mem1_m          = `CLOG2(288);

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam intlv_0.x_w             = intlv_0_x_w;
  defparam intlv_0.y_w             = intlv_0_y_w;
  defparam intlv_0.run1_w          = intlv_0_run1_w;
  defparam intlv_0.irqHdrDone_w    = intlv_0_irqHdrDone_w;
  defparam intlv_0.mode1_w         = intlv_0_mode1_w;
  defparam intlv_0.mode1_r         = intlv_0_mode1_r;
  defparam intlv_0.mode1_s         = intlv_0_mode1_s;
  defparam intlv_0.cntOfdmWr_w     = intlv_0_cntOfdmWr_w;
  defparam intlv_0.cntOfdmWr_n     = intlv_0_cntOfdmWr_n;
  defparam intlv_0.cntOfdmWr_m     = intlv_0_cntOfdmWr_m;
  defparam intlv_0.cntOfdmRd_w     = intlv_0_cntOfdmRd_w;
  defparam intlv_0.cntOfdmRd_n     = intlv_0_cntOfdmRd_n;
  defparam intlv_0.cntOfdmRd_m     = intlv_0_cntOfdmRd_m;
  defparam intlv_0.mem0_w          = intlv_0_mem0_w;
  defparam intlv_0.mem0_n          = intlv_0_mem0_n;
  defparam intlv_0.mem0_m          = intlv_0_mem0_m;
  defparam intlv_0.mem1_w          = intlv_0_mem1_w;
  defparam intlv_0.mem1_n          = intlv_0_mem1_n;
  defparam intlv_0.mem1_m          = intlv_0_mem1_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_intlv_0_mode1                                              = 0;
  defparam  intlv_0.R_mode1                                              = R_intlv_0_mode1;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                   [intlv_0_y_w-1:0]  intlv_0_y;
  wire                                      intlv_0_y_or;
  wire                                      intlv_0_y_ff;
  wire                                      intlv_0_y_we;

  wire                   [intlv_0_x_w-1:0]  intlv_0_x;
  wire                                      intlv_0_x_ir;
  wire                                      intlv_0_x_fe;
  wire                                      intlv_0_x_re;

  wire          [intlv_0_irqHdrDone_w-1:0]  intlv_0_irqHdrDone;

  wire                [intlv_0_run1_w-1:0]  intlv_0_run1;

  wire                                      intlv_0_regWe;
  wire                                      intlv_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  intlv intlv_0(intlv_0_y, intlv_0_y_or, intlv_0_y_ff, intlv_0_y_we,
                intlv_0_x, intlv_0_x_ir, intlv_0_x_fe, intlv_0_x_re, 
                intlv_0_irqHdrDone, 
                intlv_0_run1, 
                regBus, regWe, regRe, intlv_0_regWe, intlv_0_regRe, clk, clk2, reset);


//==============================================================================
