//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   ins0Bit
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module ins0Bit(y, y_or, y_ff, y_we, 
               x, x_ir, x_fe, x_re, 
               run1, 
               regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter x_w               = 0;

  parameter run1_w            = 0;

  parameter cntIn_w           = 0;
  parameter cntIn_n           = 0;
  parameter cntIn_m           = 0;
  parameter cntOut_w          = 0;
  parameter cntOut_n          = 0;
  parameter cntOut_m          = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  input          [run1_w-1:0]  run1;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  // --------------------------------------------------------------------------------------
  // Internal status registers
  reg           [cntIn_w-1:0]  cntIn;
  reg          [cntOut_w-1:0]  cntOut;

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Assign input enable
  assign x_ir = run1 && ((y_ff==0 && cntOut==1) || cntIn==0);
  
  // --------------------------------------------------------------------------------------
  // FSM
  always @(posedge clk) begin
    
    // Reset
    if (run1==0) begin
      cntIn   <= 0;
      cntOut  <= 0;
      
    // Normal operation
    end else begin
      
      // Input/output counters
      if (x_re) begin
        cntIn <= 1;
      end
      if (y_we) begin
        cntOut <= 1;
      end

    end // if (run1==0) ... else
  end // always

  // --------------------------------------------------------------------------------------
  // Assign output
  assign y_or = run1 && ((x_fe==0 && cntIn==1) || cntOut==0);
  assign y    = (cntOut==0) ? 0 : x;

endmodule
//=========================================================================================

