//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter freqShift_0_x_w             = 24;

  // Outputs
  parameter freqShift_0_y_w             = 24;

  // Input control lines
  parameter freqShift_0_run1_w          = 2;

  // Output control lines

  // Eregs
  parameter freqShift_0_fShBr_w         = 3;
  parameter freqShift_0_fShBr_r         = 0;
  parameter freqShift_0_fShBr_s         = 0;

  // Parameters
  parameter freqShift_0_w               = 12;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam freqShift_0.x_w             = freqShift_0_x_w;
  defparam freqShift_0.y_w             = freqShift_0_y_w;
  defparam freqShift_0.run1_w          = freqShift_0_run1_w;
  defparam freqShift_0.fShBr_w         = freqShift_0_fShBr_w;
  defparam freqShift_0.fShBr_r         = freqShift_0_fShBr_r;
  defparam freqShift_0.fShBr_s         = freqShift_0_fShBr_s;
  defparam freqShift_0.w               = freqShift_0_w;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_freqShift_0_fShBr                                          = 0;
  defparam  freqShift_0.R_fShBr                                          = R_freqShift_0_fShBr;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [freqShift_0_y_w-1:0]  freqShift_0_y;
  wire                                      freqShift_0_y_or;
  wire                                      freqShift_0_y_ff;
  wire                                      freqShift_0_y_we;

  wire               [freqShift_0_x_w-1:0]  freqShift_0_x;
  wire                                      freqShift_0_x_ir;
  wire                                      freqShift_0_x_fe;
  wire                                      freqShift_0_x_re;

  wire            [freqShift_0_run1_w-1:0]  freqShift_0_run1;

  wire                                      freqShift_0_regWe;
  wire                                      freqShift_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  freqShift freqShift_0(freqShift_0_y, freqShift_0_y_or, freqShift_0_y_ff, freqShift_0_y_we,
                        freqShift_0_x, freqShift_0_x_ir, freqShift_0_x_fe, freqShift_0_x_re, 
                        freqShift_0_run1, 
                        regBus, regWe, regRe, freqShift_0_regWe, freqShift_0_regRe, clk, clk2, reset);


//==============================================================================
