//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   freqShift
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module freqShift(y, y_or, y_ff, y_we, 
                 x, x_ir, x_fe, x_re, 
                 run1, 
                 regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter x_w               = 0;

  parameter run1_w            = 0;

  parameter fShBr_w           = 0;
  parameter fShBr_r           = 0;
  parameter fShBr_s           = 0;
  parameter R_fShBr           = 0;

  parameter w                 = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  input          [run1_w-1:0]  run1;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire          [fShBr_w-1:0]  fShBr_q;
  wire          [fShBr_w-1:0]  fShBr_d;
  wire                         fShBr_weint;
  assign                       fShBr_weint = 0;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg fShBr(fShBr_q, regBus, fShBr_d, fShBr_weint, regWe, regRe, clk, reset);
  defparam fShBr.w    = fShBr_w;
  defparam fShBr.rval = fShBr_r;
  defparam fShBr.sgn  = fShBr_s;
  defparam fShBr.adr  = R_fShBr;

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

//-----------------------------------------------------------------------------------------
  // Define more registers/variables
  wire  [w-1:0] xRe, xIm;
  wire          m1ReS, m1ImS, m2S;
  wire  [w-1:0] m1ReO, m1ImO, m2ReO, m2ImO;
  reg     [1:0] cnt;
  wire    [1:0] bs;   // Band selection
  wire          br;   // Band reversal
  
  // Assign input enable
  assign x_ir = run1!=0 && y_ff==0;
  
  // Get real/imag part
  assign xRe = x[  w-1:0];
  assign xIm = x[2*w-1:w];
    
  // Define configuration parameters, br = band reversal, bs = band selection
  assign br = fShBr_q[2];
  assign bs = {(fShBr_q[0] & run1[0] & ~br)^fShBr_q[1], fShBr_q[0]};
    
  // Selection of the multiplexors
  assign m1ReS =  (bs==1 & cnt[1]) | (bs==3 & ^cnt  );
  assign m1ImS = ((bs==1 & ^cnt  ) | (bs==3 & cnt[1])) ^ br;
  assign m2S   = cnt[0] & bs[0];
  
  // Define multiplexors
  assign m1ReO = (m1ReS==0) ?  xRe   : -xRe;
  assign m1ImO = (m1ImS==0) ?  xIm   : -xIm;
  assign m2ReO = (m2S==0)   ?  m1ReO : m1ImO;
  assign m2ImO = (m2S==0)   ?  m1ImO : m1ReO;

  // Update counter
  always @(posedge clk) begin
    if (run1==0) begin
      cnt <= 0;
    end else 
    if (x_re) begin
      cnt <= cnt+1;
    end
  end

  // Assign outputs
  assign y    = {m2ImO, m2ReO};
  assign y_or = run1!=0 && x_fe==0;

endmodule
//=========================================================================================
