//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter filt8x2x2_0_x_w             = 6;

  // Outputs
  parameter filt8x2x2_0_yA_w            = 10;
  parameter filt8x2x2_0_yB_w            = 10;

  // Input control lines
  parameter filt8x2x2_0_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter filt8x2x2_0_wx              = 6;
  parameter filt8x2x2_0_wy              = 10;
  parameter filt8x2x2_0_cfAR0           = 0;
  parameter filt8x2x2_0_cfAR1           = 6;
  parameter filt8x2x2_0_cfAR2           = 1;
  parameter filt8x2x2_0_cfAR3           = 2;
  parameter filt8x2x2_0_cfAR4           = 2;
  parameter filt8x2x2_0_cfAR5           = 1;
  parameter filt8x2x2_0_cfAR6           = 6;
  parameter filt8x2x2_0_cfAR7           = 0;
  parameter filt8x2x2_0_cfAI0           = 7;
  parameter filt8x2x2_0_cfAI1           = 7;
  parameter filt8x2x2_0_cfAI2           = 2;
  parameter filt8x2x2_0_cfAI3           = 2;
  parameter filt8x2x2_0_cfAI4           = 2;
  parameter filt8x2x2_0_cfAI5           = 2;
  parameter filt8x2x2_0_cfAI6           = 7;
  parameter filt8x2x2_0_cfAI7           = 7;
  parameter filt8x2x2_0_cfBR0           = 6;
  parameter filt8x2x2_0_cfBR1           = 7;
  parameter filt8x2x2_0_cfBR2           = 2;
  parameter filt8x2x2_0_cfBR3           = 1;
  parameter filt8x2x2_0_cfBR4           = 2;
  parameter filt8x2x2_0_cfBR5           = 7;
  parameter filt8x2x2_0_cfBR6           = 6;
  parameter filt8x2x2_0_cfBR7           = 1;
  parameter filt8x2x2_0_cfBI0           = 6;
  parameter filt8x2x2_0_cfBI1           = 1;
  parameter filt8x2x2_0_cfBI2           = 2;
  parameter filt8x2x2_0_cfBI3           = 1;
  parameter filt8x2x2_0_cfBI4           = 2;
  parameter filt8x2x2_0_cfBI5           = 1;
  parameter filt8x2x2_0_cfBI6           = 6;
  parameter filt8x2x2_0_cfBI7           = 0;

  // Iregs
  parameter filt8x2x2_0_xD_w            = 6;
  parameter filt8x2x2_0_xD_n            = 28;
  parameter filt8x2x2_0_xD_m            = `CLOG2(28);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam filt8x2x2_0.x_w             = filt8x2x2_0_x_w;
  defparam filt8x2x2_0.yA_w            = filt8x2x2_0_yA_w;
  defparam filt8x2x2_0.yB_w            = filt8x2x2_0_yB_w;
  defparam filt8x2x2_0.run1_w          = filt8x2x2_0_run1_w;
  defparam filt8x2x2_0.wx              = filt8x2x2_0_wx;
  defparam filt8x2x2_0.wy              = filt8x2x2_0_wy;
  defparam filt8x2x2_0.cfAR0           = filt8x2x2_0_cfAR0;
  defparam filt8x2x2_0.cfAR1           = filt8x2x2_0_cfAR1;
  defparam filt8x2x2_0.cfAR2           = filt8x2x2_0_cfAR2;
  defparam filt8x2x2_0.cfAR3           = filt8x2x2_0_cfAR3;
  defparam filt8x2x2_0.cfAR4           = filt8x2x2_0_cfAR4;
  defparam filt8x2x2_0.cfAR5           = filt8x2x2_0_cfAR5;
  defparam filt8x2x2_0.cfAR6           = filt8x2x2_0_cfAR6;
  defparam filt8x2x2_0.cfAR7           = filt8x2x2_0_cfAR7;
  defparam filt8x2x2_0.cfAI0           = filt8x2x2_0_cfAI0;
  defparam filt8x2x2_0.cfAI1           = filt8x2x2_0_cfAI1;
  defparam filt8x2x2_0.cfAI2           = filt8x2x2_0_cfAI2;
  defparam filt8x2x2_0.cfAI3           = filt8x2x2_0_cfAI3;
  defparam filt8x2x2_0.cfAI4           = filt8x2x2_0_cfAI4;
  defparam filt8x2x2_0.cfAI5           = filt8x2x2_0_cfAI5;
  defparam filt8x2x2_0.cfAI6           = filt8x2x2_0_cfAI6;
  defparam filt8x2x2_0.cfAI7           = filt8x2x2_0_cfAI7;
  defparam filt8x2x2_0.cfBR0           = filt8x2x2_0_cfBR0;
  defparam filt8x2x2_0.cfBR1           = filt8x2x2_0_cfBR1;
  defparam filt8x2x2_0.cfBR2           = filt8x2x2_0_cfBR2;
  defparam filt8x2x2_0.cfBR3           = filt8x2x2_0_cfBR3;
  defparam filt8x2x2_0.cfBR4           = filt8x2x2_0_cfBR4;
  defparam filt8x2x2_0.cfBR5           = filt8x2x2_0_cfBR5;
  defparam filt8x2x2_0.cfBR6           = filt8x2x2_0_cfBR6;
  defparam filt8x2x2_0.cfBR7           = filt8x2x2_0_cfBR7;
  defparam filt8x2x2_0.cfBI0           = filt8x2x2_0_cfBI0;
  defparam filt8x2x2_0.cfBI1           = filt8x2x2_0_cfBI1;
  defparam filt8x2x2_0.cfBI2           = filt8x2x2_0_cfBI2;
  defparam filt8x2x2_0.cfBI3           = filt8x2x2_0_cfBI3;
  defparam filt8x2x2_0.cfBI4           = filt8x2x2_0_cfBI4;
  defparam filt8x2x2_0.cfBI5           = filt8x2x2_0_cfBI5;
  defparam filt8x2x2_0.cfBI6           = filt8x2x2_0_cfBI6;
  defparam filt8x2x2_0.cfBI7           = filt8x2x2_0_cfBI7;
  defparam filt8x2x2_0.xD_w            = filt8x2x2_0_xD_w;
  defparam filt8x2x2_0.xD_n            = filt8x2x2_0_xD_n;
  defparam filt8x2x2_0.xD_m            = filt8x2x2_0_xD_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire              [filt8x2x2_0_yA_w-1:0]  filt8x2x2_0_yA;
  wire                                      filt8x2x2_0_yA_or;
  wire                                      filt8x2x2_0_yA_ff;
  wire                                      filt8x2x2_0_yA_we;

  wire              [filt8x2x2_0_yB_w-1:0]  filt8x2x2_0_yB;
  wire                                      filt8x2x2_0_yB_or;
  wire                                      filt8x2x2_0_yB_ff;
  wire                                      filt8x2x2_0_yB_we;

  wire               [filt8x2x2_0_x_w-1:0]  filt8x2x2_0_x;
  wire                                      filt8x2x2_0_x_ir;
  wire                                      filt8x2x2_0_x_fe;
  wire                                      filt8x2x2_0_x_re;

  wire            [filt8x2x2_0_run1_w-1:0]  filt8x2x2_0_run1;

  wire                                      filt8x2x2_0_regWe;
  wire                                      filt8x2x2_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  filt8x2x2 filt8x2x2_0(filt8x2x2_0_yA, filt8x2x2_0_yA_or, filt8x2x2_0_yA_ff, filt8x2x2_0_yA_we,
                        filt8x2x2_0_yB, filt8x2x2_0_yB_or, filt8x2x2_0_yB_ff, filt8x2x2_0_yB_we,
                        filt8x2x2_0_x, filt8x2x2_0_x_ir, filt8x2x2_0_x_fe, filt8x2x2_0_x_re, 
                        filt8x2x2_0_run1, 
                        regBus, regWe, regRe, filt8x2x2_0_regWe, filt8x2x2_0_regRe, clk, clk2, reset);


//==============================================================================
