//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   filt8x2x2
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module filt8x2x2(yA, yA_or, yA_ff, yA_we, 
                 yB, yB_or, yB_ff, yB_we, 
                 x, x_ir, x_fe, x_re, 
                 run1, 
                 regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter yA_w              = 0;
  parameter yB_w              = 0;
  parameter x_w               = 0;

  parameter run1_w            = 0;

  parameter wx                = 0;
  parameter wy                = 0;
  parameter cfAR0             = 0;
  parameter cfAR1             = 0;
  parameter cfAR2             = 0;
  parameter cfAR3             = 0;
  parameter cfAR4             = 0;
  parameter cfAR5             = 0;
  parameter cfAR6             = 0;
  parameter cfAR7             = 0;
  parameter cfAI0             = 0;
  parameter cfAI1             = 0;
  parameter cfAI2             = 0;
  parameter cfAI3             = 0;
  parameter cfAI4             = 0;
  parameter cfAI5             = 0;
  parameter cfAI6             = 0;
  parameter cfAI7             = 0;
  parameter cfBR0             = 0;
  parameter cfBR1             = 0;
  parameter cfBR2             = 0;
  parameter cfBR3             = 0;
  parameter cfBR4             = 0;
  parameter cfBR5             = 0;
  parameter cfBR6             = 0;
  parameter cfBR7             = 0;
  parameter cfBI0             = 0;
  parameter cfBI1             = 0;
  parameter cfBI2             = 0;
  parameter cfBI3             = 0;
  parameter cfBI4             = 0;
  parameter cfBI5             = 0;
  parameter cfBI6             = 0;
  parameter cfBI7             = 0;

  parameter xD_w              = 0;
  parameter xD_n              = 0;
  parameter xD_m              = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output           [yA_w-1:0]  yA;
  output                       yA_or;
  input                        yA_ff;
  output                       yA_we;
  assign                       yA_we = yA_or & ~yA_ff;

  output           [yB_w-1:0]  yB;
  output                       yB_or;
  input                        yB_ff;
  output                       yB_we;
  assign                       yB_we = yB_or & ~yB_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  input          [run1_w-1:0]  run1;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  // --------------------------------------------------------------------------------------
  // Internal status registers
  reg              [xD_w-1:0]  xD[xD_n-1:0];

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Register definitions
  reg        [2:0]  cfA[7:0], cfB[7:0];
  reg     [wx-1:0]  xI[7:0],  xM[7:0];
  reg       [wx:0]  xSA[7:0], xSB[7:0];
  reg     [wx+1:0]  addA0   , addA0_nxt   , addB0   , addB0_nxt   ;  
  reg     [wx+1:0]  addA1   , addA1_nxt   , addB1   , addB1_nxt   ;  
  reg     [wx+1:0]  addA2   , addA2_nxt   , addB2   , addB2_nxt   ;  
  reg     [wx+1:0]  addA3   , addA3_nxt   , addB3   , addB3_nxt   ;  
  reg     [wx+2:0]  addA01  , addA01_nxt  , addB01  , addB01_nxt  ;  
  reg     [wx+2:0]  addA23  , addA23_nxt  , addB23  , addB23_nxt  ;  
  reg     [wx+3:0]  addA0123, addA0123_nxt, addB0123, addB0123_nxt;  
  reg        [1:0]  cntIn;
  reg        [2:0]  cntOut;
  
  integer k;
  
  // --------------------------------------------------------------------------------------
  // Assign input and output enable
  assign x_ir  = run1;
  assign yA_or = cntOut[2];
  assign yA    = addA0123;
  assign yB_or = cntOut[2];
  assign yB    = addB0123;
  
  // --------------------------------------------------------------------------------------
  // Signal processing behaviour
  // always @(*) begin
  always @(x or cntIn or  // Thanks to XST this looks really stupid
           xD[ 0] or xD[ 1] or xD[ 2] or xD[ 3] or xD[ 4] or xD[ 5] or xD[ 6] or
           xD[ 7] or xD[ 8] or xD[ 9] or xD[10] or xD[11] or xD[12] or xD[13] or
           xD[14] or xD[15] or xD[16] or xD[17] or xD[18] or xD[19] or xD[20] or
           xD[21] or xD[22] or xD[23] or xD[24] or xD[25] or xD[26] or xD[27] or
           addA0 or addA1 or addA2 or addA3 or addA01 or addA23 or
           addB0 or addB1 or addB2 or addB3 or addB01 or addB23) begin
          
    // Selection of input data from delay chain
    for (k=0; k<7; k=k+1) begin
      xI[k] = xD[k*4];
    end
    xI[7] = x;
        
    // Coefficient LUT definition
    if (cntIn[0]==0) begin
      cfA[0] = cfAR0; cfA[1] = cfAR1; cfA[2] = cfAR2; cfA[3] = cfAR3;
      cfA[4] = cfAR4; cfA[5] = cfAR5; cfA[6] = cfAR6; cfA[7] = cfAR7;
      cfB[0] = cfBR0; cfB[1] = cfBR1; cfB[2] = cfBR2; cfB[3] = cfBR3;
      cfB[4] = cfBR4; cfB[5] = cfBR5; cfB[6] = cfBR6; cfB[7] = cfBR7;
    end else begin
      cfA[0] = cfAI0; cfA[1] = cfAI1; cfA[2] = cfAI2; cfA[3] = cfAI3;
      cfA[4] = cfAI4; cfA[5] = cfAI5; cfA[6] = cfAI6; cfA[7] = cfAI7;
      cfB[0] = cfBI0; cfB[1] = cfBI1; cfB[2] = cfBI2; cfB[3] = cfBI3;
      cfB[4] = cfBI4; cfB[5] = cfBI5; cfB[6] = cfBI6; cfB[7] = cfBI7;
    end

    // Apply multiplication by [-2..+2]
    for (k=0; k<8; k=k+1) begin
      xM[k] = -xI[k];
      case (cfA[7-k])
        1 :       xSA[k] = {xI[k][wx-1], xI[k]};
        2 :       xSA[k] = {xI[k], 1'b0};
        7 :       xSA[k] = {xM[k][wx-1], xM[k]};
        6 :       xSA[k] = {xM[k], 1'b0};
        default : xSA[k] = 0;
      endcase
      case (cfB[7-k])
        1 :       xSB[k] = {xI[k][wx-1], xI[k]};
        2 :       xSB[k] = {xI[k], 1'b0};
        7 :       xSB[k] = {xM[k][wx-1], xM[k]};
        6 :       xSB[k] = {xM[k], 1'b0};
        default : xSB[k] = 0;
      endcase
    end
            
    // Define adder chain
    addA0_nxt    = {xSA[0][wx],  xSA[0] } + {xSA[1][wx],  xSA[1] };
    addA1_nxt    = {xSA[2][wx],  xSA[2] } + {xSA[3][wx],  xSA[3] };
    addA2_nxt    = {xSA[4][wx],  xSA[4] } + {xSA[5][wx],  xSA[5] };
    addA3_nxt    = {xSA[6][wx],  xSA[6] } + {xSA[7][wx],  xSA[7] };
    addA01_nxt   = {addA0[wx+1],  addA0 } + {addA1[wx+1],  addA1 };
    addA23_nxt   = {addA2[wx+1],  addA2 } + {addA3[wx+1],  addA3 };
    addA0123_nxt = {addA01[wx+2], addA01} + {addA23[wx+2], addA23};

    addB0_nxt    = {xSB[0][wx],  xSB[0] } + {xSB[1][wx],  xSB[1] };
    addB1_nxt    = {xSB[2][wx],  xSB[2] } + {xSB[3][wx],  xSB[3] };
    addB2_nxt    = {xSB[4][wx],  xSB[4] } + {xSB[5][wx],  xSB[5] };
    addB3_nxt    = {xSB[6][wx],  xSB[6] } + {xSB[7][wx],  xSB[7] };
    addB01_nxt   = {addB0[wx+1],  addB0 } + {addB1[wx+1],  addB1 };
    addB23_nxt   = {addB2[wx+1],  addB2 } + {addB3[wx+1],  addB3 };
    addB0123_nxt = {addB01[wx+2], addB01} + {addB23[wx+2], addB23};

  end

  // --------------------------------------------------------------------------------------
  // Input FSM
  always @(posedge clk) begin
    
    // Reset
    if (run1==0) begin
      for (k=0; k<xD_n; k=k+1) begin
        xD[k] <= 0;
      end
      cntIn  <= 0;
      cntOut <= 0;

    // Normal operation
    end else begin
      
      // Input delay chain
      if (x_re) begin
        for (k=0; k<xD_n-1; k=k+1) begin
          xD[k] <= xD[k+1];
        end
        xD[xD_n-1] <= x;
      end
      
      // Start input counter
      if (x_re) begin
        cntIn <= cntIn+1;
      end
            
      // Define adder chain
      addA0     <= addA0_nxt;
      addA1     <= addA1_nxt;
      addA2     <= addA2_nxt;
      addA3     <= addA3_nxt;
      addA01    <= addA01_nxt;
      addA23    <= addA23_nxt;
      addA0123  <= addA0123_nxt;

      addB0     <= addB0_nxt;
      addB1     <= addB1_nxt;
      addB2     <= addB2_nxt;
      addB3     <= addB3_nxt;
      addB01    <= addB01_nxt;
      addB23    <= addB23_nxt;
      addB0123  <= addB0123_nxt;

      // Start output counter
      cntOut <= {cntOut[1:0], x_re};  
      
    end // if (run1_q==0) ... else
  end // always

endmodule
//=========================================================================================

