//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter fft8_0_x_w             = 20;

  // Outputs
  parameter fft8_0_y_w             = 20;

  // Input control lines
  parameter fft8_0_run1_w          = 2;

  // Output control lines

  // Eregs

  // Parameters
  parameter fft8_0_w               = 10;
  parameter fft8_0_wi              = 13;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam fft8_0.x_w             = fft8_0_x_w;
  defparam fft8_0.y_w             = fft8_0_y_w;
  defparam fft8_0.run1_w          = fft8_0_run1_w;
  defparam fft8_0.w               = fft8_0_w;
  defparam fft8_0.wi              = fft8_0_wi;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                    [fft8_0_y_w-1:0]  fft8_0_y;
  wire                                      fft8_0_y_or;
  wire                                      fft8_0_y_ff;
  wire                                      fft8_0_y_we;

  wire                    [fft8_0_x_w-1:0]  fft8_0_x;
  wire                                      fft8_0_x_ir;
  wire                                      fft8_0_x_fe;
  wire                                      fft8_0_x_re;

  wire                 [fft8_0_run1_w-1:0]  fft8_0_run1;

  wire                                      fft8_0_regWe;
  wire                                      fft8_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  fft8 fft8_0(fft8_0_y, fft8_0_y_or, fft8_0_y_ff, fft8_0_y_we,
              fft8_0_x, fft8_0_x_ir, fft8_0_x_fe, fft8_0_x_re, 
              fft8_0_run1, 
              regBus, regWe, regRe, fft8_0_regWe, fft8_0_regRe, clk, clk2, reset);


//==============================================================================
