//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter enc11a_0_x_w             = 8;

  // Outputs
  parameter enc11a_0_y_w             = 1;

  // Input control lines

  // Output control lines

  // Eregs
  parameter enc11a_0_run1_w          = 2;
  parameter enc11a_0_run1_r          = 0;
  parameter enc11a_0_run1_s          = 0;

  // Parameters
  parameter enc11a_0_wx              = 8;
  parameter enc11a_0_wy              = 1;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam enc11a_0.x_w             = enc11a_0_x_w;
  defparam enc11a_0.y_w             = enc11a_0_y_w;
  defparam enc11a_0.run1_w          = enc11a_0_run1_w;
  defparam enc11a_0.run1_r          = enc11a_0_run1_r;
  defparam enc11a_0.run1_s          = enc11a_0_run1_s;
  defparam enc11a_0.wx              = enc11a_0_wx;
  defparam enc11a_0.wy              = enc11a_0_wy;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_enc11a_0_run1                                              = 0;
  defparam  enc11a_0.R_run1                                              = R_enc11a_0_run1;
  parameter R_enc11a_0_crc32_0_numBits                                   = 1;
  defparam  enc11a_0.R_crc32_0_numBits                                   = R_enc11a_0_crc32_0_numBits;
  parameter R_enc11a_0_ppdu11a_0_plcpHdr0                                = 2;
  defparam  enc11a_0.R_ppdu11a_0_plcpHdr0                                = R_enc11a_0_ppdu11a_0_plcpHdr0;
  parameter R_enc11a_0_ppdu11a_0_plcpHdr1                                = 3;
  defparam  enc11a_0.R_ppdu11a_0_plcpHdr1                                = R_enc11a_0_ppdu11a_0_plcpHdr1;
  parameter R_enc11a_0_ppdu11a_0_numByte                                 = 4;
  defparam  enc11a_0.R_ppdu11a_0_numByte                                 = R_enc11a_0_ppdu11a_0_numByte;
  parameter R_enc11a_0_ppdu11a_0_numPadBit                               = 5;
  defparam  enc11a_0.R_ppdu11a_0_numPadBit                               = R_enc11a_0_ppdu11a_0_numPadBit;
  parameter R_enc11a_0_scrmbl_0_s                                        = 6;
  defparam  enc11a_0.R_scrmbl_0_s                                        = R_enc11a_0_scrmbl_0_s;
  parameter R_enc11a_0_punct_0_run1                                      = 7;
  defparam  enc11a_0.R_punct_0_run1                                      = R_enc11a_0_punct_0_run1;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                  [enc11a_0_y_w-1:0]  enc11a_0_y;
  wire                                      enc11a_0_y_or;
  wire                                      enc11a_0_y_ff;
  wire                                      enc11a_0_y_we;

  wire                  [enc11a_0_x_w-1:0]  enc11a_0_x;
  wire                                      enc11a_0_x_ir;
  wire                                      enc11a_0_x_fe;
  wire                                      enc11a_0_x_re;

  wire                                      enc11a_0_regWe;
  wire                                      enc11a_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  enc11a enc11a_0(enc11a_0_y, enc11a_0_y_or, enc11a_0_y_ff, enc11a_0_y_we,
                  enc11a_0_x, enc11a_0_x_ir, enc11a_0_x_fe, enc11a_0_x_re, 
                  regBus, regWe, regRe, enc11a_0_regWe, enc11a_0_regRe, clk, clk2, reset);


//==============================================================================
