//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   enc11a
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module enc11a(y, y_or, y_ff, y_we, 
              x, x_ir, x_fe, x_re, 
              regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter x_w               = 0;


  parameter run1_w            = 0;
  parameter run1_r            = 0;
  parameter run1_s            = 0;
  parameter R_run1            = 0;

  parameter wx                = 0;
  parameter wy                = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;


  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire           [run1_w-1:0]  run1_q;
  wire           [run1_w-1:0]  run1_d;
  wire                         run1_weint;
  assign                       run1_weint = 0;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg run1(run1_q, regBus, run1_d, run1_weint, regWe, regRe, clk, reset);
  defparam run1.w    = run1_w;
  defparam run1.rval = run1_r;
  defparam run1.sgn  = run1_s;
  defparam run1.adr  = R_run1;

  // --------------------------------------------------------------------------------------
  // Included instances
  `include "byte2Bit_0.v"
  `include "crc32_0.v"
  `include "ppdu11a_0.v"
  `include "scrmbl_0.v"
  `include "ccEnc_0.v"
  `include "punct_0.v"

  // --------------------------------------------------------------------------------------
  // Define connections
  assign byte2Bit_0_x              = x;
  assign byte2Bit_0_x_fe           = x_fe;
  assign x_ir                      = byte2Bit_0_x_ir;

  assign crc32_0_x                 = byte2Bit_0_y;
  assign crc32_0_x_fe              = ~byte2Bit_0_y_or;
  assign byte2Bit_0_y_ff           = ~crc32_0_x_ir;

  assign ppdu11a_0_x               = crc32_0_y;
  assign ppdu11a_0_x_fe            = ~crc32_0_y_or;
  assign crc32_0_y_ff              = ~ppdu11a_0_x_ir;

  assign scrmbl_0_xs               = ppdu11a_0_ys;
  assign scrmbl_0_xs_fe            = ~ppdu11a_0_ys_or;
  assign ppdu11a_0_ys_ff           = ~scrmbl_0_xs_ir;

  assign ccEnc_0_x                 = scrmbl_0_y;
  assign ccEnc_0_x_fe              = ~scrmbl_0_y_or;
  assign scrmbl_0_y_ff             = ~ccEnc_0_x_ir;

  assign punct_0_x                 = ccEnc_0_y;
  assign punct_0_x_fe              = ~ccEnc_0_y_or;
  assign ccEnc_0_y_ff              = ~punct_0_x_ir;

  assign y                         = punct_0_y;
  assign y_or                      = punct_0_y_or;
  assign punct_0_y_ff              = y_ff;


  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | byte2Bit_0_regWe | crc32_0_regWe | ppdu11a_0_regWe
                      | scrmbl_0_regWe | ccEnc_0_regWe | punct_0_regWe;
  assign regReOut = 0 | byte2Bit_0_regRe | crc32_0_regRe | ppdu11a_0_regRe
                      | scrmbl_0_regRe | ccEnc_0_regRe | punct_0_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Connect control signals
  assign  byte2Bit_0_run1 = run1_q==2;
  assign  crc32_0_run1    = run1_q==2;
  assign  ppdu11a_0_run1  = run1_q;
  assign  scrmbl_0_run1   = run1_q!=0;
  assign  ccEnc_0_run1    = run1_q!=0;

  // Set scrambler to 11a mode
  assign scrmbl_0_scrMode = 0;

endmodule
//=========================================================================================

