//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter dem11a_0_xC_w            = 26;
  parameter dem11a_0_xSf_w           = 9;

  // Outputs
  parameter dem11a_0_ySb_w           = 22;
  parameter dem11a_0_yD_w            = 11;

  // Input control lines

  // Output control lines
  parameter dem11a_0_irqTtDone_w     = 1;

  // Eregs
  parameter dem11a_0_run1_w          = 2;
  parameter dem11a_0_run1_r          = 0;
  parameter dem11a_0_run1_s          = 0;

  // Parameters
  parameter dem11a_0_wx              = 13;
  parameter dem11a_0_ws              = 9;
  parameter dem11a_0_wb              = 22;
  parameter dem11a_0_wy              = 11;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos
  parameter dem11a_0_ffIn_w          = 26;
  parameter dem11a_0_ffIn_n          = 52;
  parameter dem11a_0_ffIn_m          = 6;

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam dem11a_0.xC_w            = dem11a_0_xC_w;
  defparam dem11a_0.xSf_w           = dem11a_0_xSf_w;
  defparam dem11a_0.ySb_w           = dem11a_0_ySb_w;
  defparam dem11a_0.yD_w            = dem11a_0_yD_w;
  defparam dem11a_0.irqTtDone_w     = dem11a_0_irqTtDone_w;
  defparam dem11a_0.run1_w          = dem11a_0_run1_w;
  defparam dem11a_0.run1_r          = dem11a_0_run1_r;
  defparam dem11a_0.run1_s          = dem11a_0_run1_s;
  defparam dem11a_0.wx              = dem11a_0_wx;
  defparam dem11a_0.ws              = dem11a_0_ws;
  defparam dem11a_0.wb              = dem11a_0_wb;
  defparam dem11a_0.wy              = dem11a_0_wy;
  defparam dem11a_0.ffIn_w          = dem11a_0_ffIn_w;
  defparam dem11a_0.ffIn_m          = dem11a_0_ffIn_m;
  defparam dem11a_0.ffIn_n          = dem11a_0_ffIn_n;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_dem11a_0_run1                                              = 0;
  defparam  dem11a_0.R_run1                                              = R_dem11a_0_run1;
  parameter R_dem11a_0_ttCordic_0_run1                                   = 1;
  defparam  dem11a_0.R_ttCordic_0_run1                                   = R_dem11a_0_ttCordic_0_run1;
  parameter R_dem11a_0_ttCordic_0_ph                                     = 2;
  defparam  dem11a_0.R_ttCordic_0_ph                                     = R_dem11a_0_ttCordic_0_ph;
  parameter R_dem11a_0_ttCordic_0_dph3                                   = 3;
  defparam  dem11a_0.R_ttCordic_0_dph3                                   = R_dem11a_0_ttCordic_0_dph3;
  parameter R_dem11a_0_ttCordic_0_dph4                                   = 4;
  defparam  dem11a_0.R_ttCordic_0_dph4                                   = R_dem11a_0_ttCordic_0_dph4;
  parameter R_dem11a_0_ttCordic_0_dphM49                                 = 5;
  defparam  dem11a_0.R_ttCordic_0_dphM49                                 = R_dem11a_0_ttCordic_0_dphM49;
  parameter R_dem11a_0_ttCordic_0_dph14                                  = 6;
  defparam  dem11a_0.R_ttCordic_0_dph14                                  = R_dem11a_0_ttCordic_0_dph14;
  parameter R_dem11a_0_pltExt_0_pltSumRe                                 = 7;
  defparam  dem11a_0.R_pltExt_0_pltSumRe                                 = R_dem11a_0_pltExt_0_pltSumRe;
  parameter R_dem11a_0_pltExt_0_pltSumIm                                 = 8;
  defparam  dem11a_0.R_pltExt_0_pltSumIm                                 = R_dem11a_0_pltExt_0_pltSumIm;

  // FIFO address definitions - might be overwritten by an upper module
  parameter R_dem11a_0_ffIn                                              = 9;
  defparam  dem11a_0.R_ffIn                                              = R_dem11a_0_ffIn;

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                [dem11a_0_ySb_w-1:0]  dem11a_0_ySb;
  wire                                      dem11a_0_ySb_or;
  wire                                      dem11a_0_ySb_ff;
  wire                                      dem11a_0_ySb_we;

  wire                 [dem11a_0_yD_w-1:0]  dem11a_0_yD;
  wire                                      dem11a_0_yD_or;
  wire                                      dem11a_0_yD_ff;
  wire                                      dem11a_0_yD_we;

  wire                 [dem11a_0_xC_w-1:0]  dem11a_0_xC;
  wire                                      dem11a_0_xC_ir;
  wire                                      dem11a_0_xC_fe;
  wire                                      dem11a_0_xC_re;

  wire                [dem11a_0_xSf_w-1:0]  dem11a_0_xSf;
  wire                                      dem11a_0_xSf_ir;
  wire                                      dem11a_0_xSf_fe;
  wire                                      dem11a_0_xSf_re;

  wire          [dem11a_0_irqTtDone_w-1:0]  dem11a_0_irqTtDone;

  wire                                      dem11a_0_regWe;
  wire                                      dem11a_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  dem11a dem11a_0(dem11a_0_ySb, dem11a_0_ySb_or, dem11a_0_ySb_ff, dem11a_0_ySb_we,
                  dem11a_0_yD, dem11a_0_yD_or, dem11a_0_yD_ff, dem11a_0_yD_we,
                  dem11a_0_xC, dem11a_0_xC_ir, dem11a_0_xC_fe, dem11a_0_xC_re, 
                  dem11a_0_xSf, dem11a_0_xSf_ir, dem11a_0_xSf_fe, dem11a_0_xSf_re, 
                  dem11a_0_irqTtDone, 
                  regBus, regWe, regRe, dem11a_0_regWe, dem11a_0_regRe, clk, clk2, reset);


//==============================================================================
