//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   dem11a
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module dem11a(ySb, ySb_or, ySb_ff, ySb_we, 
              yD, yD_or, yD_ff, yD_we, 
              xC, xC_ir, xC_fe, xC_re, 
              xSf, xSf_ir, xSf_fe, xSf_re, 
              irqTtDone, 
              regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter ySb_w             = 0;
  parameter yD_w              = 0;
  parameter xC_w              = 0;
  parameter xSf_w             = 0;

  parameter irqTtDone_w       = 0;

  parameter run1_w            = 0;
  parameter run1_r            = 0;
  parameter run1_s            = 0;
  parameter R_run1            = 0;

  parameter wx                = 0;
  parameter ws                = 0;
  parameter wb                = 0;
  parameter wy                = 0;

  parameter ffIn_w            = 0;
  parameter ffIn_n            = 0;
  parameter ffIn_m            = 0;
  parameter R_ffIn            = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output          [ySb_w-1:0]  ySb;
  output                       ySb_or;
  input                        ySb_ff;
  output                       ySb_we;
  assign                       ySb_we = ySb_or & ~ySb_ff;

  output           [yD_w-1:0]  yD;
  output                       yD_or;
  input                        yD_ff;
  output                       yD_we;
  assign                       yD_we = yD_or & ~yD_ff;

  input            [xC_w-1:0]  xC;
  output                       xC_ir;
  input                        xC_fe;
  output                       xC_re;
  assign                       xC_re = xC_ir & ~xC_fe;

  input           [xSf_w-1:0]  xSf;
  output                       xSf_ir;
  input                        xSf_fe;
  output                       xSf_re;
  assign                       xSf_re = xSf_ir & ~xSf_fe;

  output    [irqTtDone_w-1:0]  irqTtDone;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire           [run1_w-1:0]  run1_q;
  wire           [run1_w-1:0]  run1_d;
  wire                         run1_weint;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg run1(run1_q, regBus, run1_d, run1_weint, regWe, regRe, clk, reset);
  defparam run1.w    = run1_w;
  defparam run1.rval = run1_r;
  defparam run1.sgn  = run1_s;
  defparam run1.adr  = R_run1;

  // --------------------------------------------------------------------------------------
  // Included instances
  `include "buf0_26.v"
  `include "ttCordic_0.v"
  `include "pltExt_0.v"
  `include "memReplay_48x9.v"
  `include "sbCalc_0.v"
  `include "s1To2And_11.v"
  `include "s1To2Ser_11.v"

  // --------------------------------------------------------------------------------------
  // Define FIFO connections

  // ----------------------------------------
  // Fifo buf0_26_y -> ttCordic_0_x
  wire         [ffIn_w-1:0]  ffIn_q;
  wire                       ffIn_fe;
  wire                       ffIn_ff;
  wire                       ffIn_ff2;
  wire                       ffIn_fuf;
  wire                       ffIn_fof;
  wire         [ffIn_w-1:0]  ffIn_d;
  wire                       ffIn_re;
  wire                       ffIn_we;
  wire                       ffIn_ir;
  wire                       ffIn_or;
  wire                       ffIn_rst;

  fifoB ffIn(ffIn_q, ffIn_fe, ffIn_ff, ffIn_ff2, ffIn_fuf,
             ffIn_fof, ffIn_d, ffIn_re, ffIn_we, ffIn_ir,
             ffIn_or, ffIn_rst, clk);
  defparam ffIn.w = ffIn_w;
  defparam ffIn.m = ffIn_m;
  defparam ffIn.n = ffIn_n;
  defparam ffIn.a = R_ffIn;

  assign ffIn_d                    = buf0_26_y;
  assign ffIn_we                   = buf0_26_y_we;
  assign buf0_26_y_ff              = ffIn_ff;
  assign ffIn_or                   = buf0_26_y_or;

  assign ttCordic_0_x              = ffIn_q;
  assign ttCordic_0_x_fe           = ffIn_fe;
  assign ffIn_re                   = ttCordic_0_x_re;
  assign ffIn_ir                   = ttCordic_0_x_ir;


  // --------------------------------------------------------------------------------------
  // Define connections
  assign buf0_26_x                 = xC;
  assign buf0_26_x_fe              = xC_fe;
  assign xC_ir                     = buf0_26_x_ir;

  assign memReplay_48x9_x          = xSf;
  assign memReplay_48x9_x_fe       = xSf_fe;
  assign xSf_ir                    = memReplay_48x9_x_ir;

  assign pltExt_0_x                = ttCordic_0_y;
  assign pltExt_0_x_fe             = ~ttCordic_0_y_or;
  assign ttCordic_0_y_ff           = ~pltExt_0_x_ir;

  assign s1To2Ser_11_x             = pltExt_0_y;
  assign s1To2Ser_11_x_fe          = ~pltExt_0_y_or;
  assign pltExt_0_y_ff             = ~s1To2Ser_11_x_ir;

  assign s1To2And_11_x             = s1To2Ser_11_y;
  assign s1To2And_11_x_fe          = ~s1To2Ser_11_y_or;
  assign s1To2Ser_11_y_ff          = ~s1To2And_11_x_ir;

  assign sbCalc_0_x                = s1To2And_11_y0;
  assign sbCalc_0_x_fe             = ~s1To2And_11_y0_or;
  assign s1To2And_11_y0_ff         = ~sbCalc_0_x_ir;

  assign sbCalc_0_sh               = memReplay_48x9_y;
  assign sbCalc_0_sh_fe            = ~memReplay_48x9_y_or;
  assign memReplay_48x9_y_ff       = ~sbCalc_0_sh_ir;

  assign ySb                       = sbCalc_0_sb;
  assign ySb_or                    = sbCalc_0_sb_or;
  assign sbCalc_0_sb_ff            = ySb_ff;

  assign yD                        = s1To2And_11_y1;
  assign yD_or                     = s1To2And_11_y1_or;
  assign s1To2And_11_y1_ff         = yD_ff;


  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | buf0_26_regWe | ttCordic_0_regWe | pltExt_0_regWe
                      | memReplay_48x9_regWe | sbCalc_0_regWe | s1To2And_11_regWe
                      | s1To2Ser_11_regWe;
  assign regReOut = 0 | buf0_26_regRe | ttCordic_0_regRe | pltExt_0_regRe
                      | memReplay_48x9_regRe | sbCalc_0_regRe | s1To2And_11_regRe
                      | s1To2Ser_11_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Connect run lines
  assign memReplay_48x9_run1  = run1_q;
  assign buf0_26_run1         = run1_q==3;
  assign pltExt_0_run1        = run1_q==3;
  assign s1To2Ser_11_run1     = run1_q==3;
  assign sbCalc_0_run1        = run1_q==3;

  // Assign IRQ line
  assign irqTtDone = pltExt_0_irqDone;

  // Reset FIFO
  assign ffIn_rst  = run1_q==0;

endmodule
//=========================================================================================

