//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   dec11a
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module dec11a(y, y_or, y_ff, y_we, 
              ySb, ySb_or, ySb_ff, ySb_we, 
              ySb2, ySb2_or, ySb2_ff, ySb2_we, 
              yVit, yVit_or, yVit_ff, yVit_we, 
              x, x_ir, x_fe, x_re, 
              irqVitDone, 
              regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter ySb_w             = 0;
  parameter ySb2_w            = 0;
  parameter yVit_w            = 0;
  parameter x_w               = 0;

  parameter irqVitDone_w      = 0;

  parameter run1_w            = 0;
  parameter run1_r            = 0;
  parameter run1_s            = 0;
  parameter R_run1            = 0;

  parameter wx                = 0;

  parameter ffD2D_w           = 0;
  parameter ffD2D_n           = 0;
  parameter ffD2D_m           = 0;
  parameter R_ffD2D           = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  output          [ySb_w-1:0]  ySb;
  output                       ySb_or;
  input                        ySb_ff;
  output                       ySb_we;
  assign                       ySb_we = ySb_or & ~ySb_ff;

  output         [ySb2_w-1:0]  ySb2;
  output                       ySb2_or;
  input                        ySb2_ff;
  output                       ySb2_we;
  assign                       ySb2_we = ySb2_or & ~ySb2_ff;

  output         [yVit_w-1:0]  yVit;
  output                       yVit_or;
  input                        yVit_ff;
  output                       yVit_we;
  assign                       yVit_we = yVit_or & ~yVit_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  output   [irqVitDone_w-1:0]  irqVitDone;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire           [run1_w-1:0]  run1_q;
  wire           [run1_w-1:0]  run1_d;
  wire                         run1_weint;
  assign                       run1_weint = 0;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg run1(run1_q, regBus, run1_d, run1_weint, regWe, regRe, clk, reset);
  defparam run1.w    = run1_w;
  defparam run1.rval = run1_r;
  defparam run1.sgn  = run1_s;
  defparam run1.adr  = R_run1;

  // --------------------------------------------------------------------------------------
  // Included instances
  `include "deIntlv_0.v"
  `include "dePunct_0.v"
  `include "vitMain_0.v"
  `include "deScr8_0.v"
  `include "crc32x8_0.v"
  `include "buf1_8.v"
  `include "s1To2And_8a.v"
  `include "s1To2And_8b.v"
  `include "s1To2And_8c.v"

  // --------------------------------------------------------------------------------------
  // Define FIFO connections

  // ----------------------------------------
  // Fifo s1To2And_8a_y0 -> dePunct_0_x
  wire        [ffD2D_w-1:0]  ffD2D_q;
  wire                       ffD2D_fe;
  wire                       ffD2D_ff;
  wire                       ffD2D_ff2;
  wire                       ffD2D_fuf;
  wire                       ffD2D_fof;
  wire        [ffD2D_w-1:0]  ffD2D_d;
  wire                       ffD2D_re;
  wire                       ffD2D_we;
  wire                       ffD2D_ir;
  wire                       ffD2D_or;
  wire                       ffD2D_rst;

  fifoB ffD2D(ffD2D_q, ffD2D_fe, ffD2D_ff, ffD2D_ff2, ffD2D_fuf,
              ffD2D_fof, ffD2D_d, ffD2D_re, ffD2D_we, ffD2D_ir,
              ffD2D_or, ffD2D_rst, clk);
  defparam ffD2D.w = ffD2D_w;
  defparam ffD2D.m = ffD2D_m;
  defparam ffD2D.n = ffD2D_n;
  defparam ffD2D.a = R_ffD2D;

  assign ffD2D_d                   = s1To2And_8a_y0;
  assign ffD2D_we                  = s1To2And_8a_y0_we;
  assign s1To2And_8a_y0_ff         = ffD2D_ff;
  assign ffD2D_or                  = s1To2And_8a_y0_or;

  assign dePunct_0_x               = ffD2D_q;
  assign dePunct_0_x_fe            = ffD2D_fe;
  assign ffD2D_re                  = dePunct_0_x_re;
  assign ffD2D_ir                  = dePunct_0_x_ir;


  // --------------------------------------------------------------------------------------
  // Define connections
  assign deIntlv_0_x               = x;
  assign deIntlv_0_x_fe            = x_fe;
  assign x_ir                      = deIntlv_0_x_ir;

  assign s1To2And_8a_x             = deIntlv_0_y;
  assign s1To2And_8a_x_fe          = ~deIntlv_0_y_or;
  assign deIntlv_0_y_ff            = ~s1To2And_8a_x_ir;

  assign buf1_8_x                  = dePunct_0_y;
  assign buf1_8_x_fe               = ~dePunct_0_y_or;
  assign dePunct_0_y_ff            = ~buf1_8_x_ir;

  assign s1To2And_8b_x             = buf1_8_y;
  assign s1To2And_8b_x_fe          = ~buf1_8_y_or;
  assign buf1_8_y_ff               = ~s1To2And_8b_x_ir;

  assign vitMain_0_x               = s1To2And_8b_y0;
  assign vitMain_0_x_fe            = ~s1To2And_8b_y0_or;
  assign s1To2And_8b_y0_ff         = ~vitMain_0_x_ir;

  assign s1To2And_8c_x             = vitMain_0_y;
  assign s1To2And_8c_x_fe          = ~vitMain_0_y_or;
  assign vitMain_0_y_ff            = ~s1To2And_8c_x_ir;

  assign deScr8_0_x                = s1To2And_8c_y0;
  assign deScr8_0_x_fe             = ~s1To2And_8c_y0_or;
  assign s1To2And_8c_y0_ff         = ~deScr8_0_x_ir;

  assign crc32x8_0_x               = deScr8_0_y;
  assign crc32x8_0_x_fe            = ~deScr8_0_y_or;
  assign deScr8_0_y_ff             = ~crc32x8_0_x_ir;

  assign y                         = crc32x8_0_y;
  assign y_or                      = crc32x8_0_y_or;
  assign crc32x8_0_y_ff            = y_ff;

  assign ySb                       = s1To2And_8a_y1;
  assign ySb_or                    = s1To2And_8a_y1_or;
  assign s1To2And_8a_y1_ff         = ySb_ff;

  assign ySb2                      = s1To2And_8b_y1;
  assign ySb2_or                   = s1To2And_8b_y1_or;
  assign s1To2And_8b_y1_ff         = ySb2_ff;

  assign yVit                      = s1To2And_8c_y1;
  assign yVit_or                   = s1To2And_8c_y1_or;
  assign s1To2And_8c_y1_ff         = yVit_ff;


  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | deIntlv_0_regWe | dePunct_0_regWe | vitMain_0_regWe
                      | deScr8_0_regWe | crc32x8_0_regWe | buf1_8_regWe
                      | s1To2And_8a_regWe | s1To2And_8b_regWe | s1To2And_8c_regWe;
  assign regReOut = 0 | deIntlv_0_regRe | dePunct_0_regRe | vitMain_0_regRe
                      | deScr8_0_regRe | crc32x8_0_regRe | buf1_8_regRe
                      | s1To2And_8a_regRe | s1To2And_8b_regRe | s1To2And_8c_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Assign run control 
  assign deIntlv_0_run1 = run1_q;
  assign deScr8_0_run1  = run1_q==2 | run1_q==3;
  assign crc32x8_0_run1 = run1_q==3;
  assign buf1_8_run1    = run1_q!=0;
  
  assign ffD2D_rst      = run1_q==0;
//  assign ffD2C_rst      = run1_q==0;
  
  // Assign viterbi IRQ
  assign irqVitDone     = vitMain_0_irqDone;
  
endmodule
//=========================================================================================

