//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter dcfBuf_0_txHost_w        = WlanDataWidth_C;
  parameter dcfBuf_0_rxPhy_w         = WlanDataWidthPhy_C;

  // Outputs
  parameter dcfBuf_0_rxHost_w        = WlanDataWidth_C;
  parameter dcfBuf_0_txPhy_w         = WlanDataWidthPhy_C;

  // Input control lines

  // Output control lines
  parameter dcfBuf_0_irqTx_w         = 1;
  parameter dcfBuf_0_irqRx_w         = 1;

  // Eregs
  parameter dcfBuf_0_dcfMode_w       = 1;
  parameter dcfBuf_0_dcfMode_r       = 0;
  parameter dcfBuf_0_dcfMode_s       = 0;

  // Parameters
  parameter dcfBuf_0_wd              = WlanDataWidth_C;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos
  parameter dcfBuf_0_phyTxFifo_w     = WlanDataWidth_C;
  parameter dcfBuf_0_phyTxFifo_n     = 7;
  parameter dcfBuf_0_phyTxFifo_m     = 3;

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam dcfBuf_0.txHost_w        = dcfBuf_0_txHost_w;
  defparam dcfBuf_0.rxPhy_w         = dcfBuf_0_rxPhy_w;
  defparam dcfBuf_0.rxHost_w        = dcfBuf_0_rxHost_w;
  defparam dcfBuf_0.txPhy_w         = dcfBuf_0_txPhy_w;
  defparam dcfBuf_0.irqTx_w         = dcfBuf_0_irqTx_w;
  defparam dcfBuf_0.irqRx_w         = dcfBuf_0_irqRx_w;
  defparam dcfBuf_0.dcfMode_w       = dcfBuf_0_dcfMode_w;
  defparam dcfBuf_0.dcfMode_r       = dcfBuf_0_dcfMode_r;
  defparam dcfBuf_0.dcfMode_s       = dcfBuf_0_dcfMode_s;
  defparam dcfBuf_0.wd              = dcfBuf_0_wd;
  defparam dcfBuf_0.phyTxFifo_w     = dcfBuf_0_phyTxFifo_w;
  defparam dcfBuf_0.phyTxFifo_m     = dcfBuf_0_phyTxFifo_m;
  defparam dcfBuf_0.phyTxFifo_n     = dcfBuf_0_phyTxFifo_n;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_dcfBuf_0_dcfMode                                           = 0;
  defparam  dcfBuf_0.R_dcfMode                                           = R_dcfBuf_0_dcfMode;
  parameter R_dcfBuf_0_dataBuf_dcfRx_run1                                = 1;
  defparam  dcfBuf_0.R_dataBuf_dcfRx_run1                                = R_dcfBuf_0_dataBuf_dcfRx_run1;
  parameter R_dcfBuf_0_dataBuf_dcfRx_datAdr                              = 2;
  defparam  dcfBuf_0.R_dataBuf_dcfRx_datAdr                              = R_dcfBuf_0_dataBuf_dcfRx_datAdr;
  parameter R_dcfBuf_0_dataBuf_dcfRx_datVal                              = 3;
  defparam  dcfBuf_0.R_dataBuf_dcfRx_datVal                              = R_dcfBuf_0_dataBuf_dcfRx_datVal;
  parameter R_dcfBuf_0_dataBuf_dcfTx_run1                                = 4;
  defparam  dcfBuf_0.R_dataBuf_dcfTx_run1                                = R_dcfBuf_0_dataBuf_dcfTx_run1;
  parameter R_dcfBuf_0_dataBuf_dcfTx_datAdr                              = 5;
  defparam  dcfBuf_0.R_dataBuf_dcfTx_datAdr                              = R_dcfBuf_0_dataBuf_dcfTx_datAdr;
  parameter R_dcfBuf_0_dataBuf_dcfTx_datVal                              = 6;
  defparam  dcfBuf_0.R_dataBuf_dcfTx_datVal                              = R_dcfBuf_0_dataBuf_dcfTx_datVal;
  parameter R_dcfBuf_0_fifoIf_0_run1                                     = 7;
  defparam  dcfBuf_0.R_fifoIf_0_run1                                     = R_dcfBuf_0_fifoIf_0_run1;
  parameter R_dcfBuf_0_fifoIf_0_rxDat                                    = 8;
  defparam  dcfBuf_0.R_fifoIf_0_rxDat                                    = R_dcfBuf_0_fifoIf_0_rxDat;
  parameter R_dcfBuf_0_fifoIf_0_rxSt                                     = 9;
  defparam  dcfBuf_0.R_fifoIf_0_rxSt                                     = R_dcfBuf_0_fifoIf_0_rxSt;
  parameter R_dcfBuf_0_fifoIf_0_txDat                                    = 10;
  defparam  dcfBuf_0.R_fifoIf_0_txDat                                    = R_dcfBuf_0_fifoIf_0_txDat;
  parameter R_dcfBuf_0_fifoIf_0_txSt                                     = 11;
  defparam  dcfBuf_0.R_fifoIf_0_txSt                                     = R_dcfBuf_0_fifoIf_0_txSt;
  parameter R_dcfBuf_0_c16To8_0_run1                                     = 12;
  defparam  dcfBuf_0.R_c16To8_0_run1                                     = R_dcfBuf_0_c16To8_0_run1;
  parameter R_dcfBuf_0_c16To8_0_nByte                                    = 13;
  defparam  dcfBuf_0.R_c16To8_0_nByte                                    = R_dcfBuf_0_c16To8_0_nByte;
  parameter R_dcfBuf_0_c8To16_0_run1                                     = 14;
  defparam  dcfBuf_0.R_c8To16_0_run1                                     = R_dcfBuf_0_c8To16_0_run1;
  parameter R_dcfBuf_0_c8To16_0_nByte                                    = 15;
  defparam  dcfBuf_0.R_c8To16_0_nByte                                    = R_dcfBuf_0_c8To16_0_nByte;

  // FIFO address definitions - might be overwritten by an upper module
  parameter R_dcfBuf_0_phyTxFifo                                         = 16;
  defparam  dcfBuf_0.R_phyTxFifo                                         = R_dcfBuf_0_phyTxFifo;

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire             [dcfBuf_0_rxHost_w-1:0]  dcfBuf_0_rxHost;
  wire                                      dcfBuf_0_rxHost_or;
  wire                                      dcfBuf_0_rxHost_ff;
  wire                                      dcfBuf_0_rxHost_we;

  wire              [dcfBuf_0_txPhy_w-1:0]  dcfBuf_0_txPhy;
  wire                                      dcfBuf_0_txPhy_or;
  wire                                      dcfBuf_0_txPhy_ff;
  wire                                      dcfBuf_0_txPhy_we;

  wire             [dcfBuf_0_txHost_w-1:0]  dcfBuf_0_txHost;
  wire                                      dcfBuf_0_txHost_ir;
  wire                                      dcfBuf_0_txHost_fe;
  wire                                      dcfBuf_0_txHost_re;

  wire              [dcfBuf_0_rxPhy_w-1:0]  dcfBuf_0_rxPhy;
  wire                                      dcfBuf_0_rxPhy_ir;
  wire                                      dcfBuf_0_rxPhy_fe;
  wire                                      dcfBuf_0_rxPhy_re;

  wire              [dcfBuf_0_irqTx_w-1:0]  dcfBuf_0_irqTx;
  wire              [dcfBuf_0_irqRx_w-1:0]  dcfBuf_0_irqRx;

  wire                                      dcfBuf_0_regWe;
  wire                                      dcfBuf_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  dcfBuf dcfBuf_0(dcfBuf_0_rxHost, dcfBuf_0_rxHost_or, dcfBuf_0_rxHost_ff, dcfBuf_0_rxHost_we,
                  dcfBuf_0_txPhy, dcfBuf_0_txPhy_or, dcfBuf_0_txPhy_ff, dcfBuf_0_txPhy_we,
                  dcfBuf_0_txHost, dcfBuf_0_txHost_ir, dcfBuf_0_txHost_fe, dcfBuf_0_txHost_re, 
                  dcfBuf_0_rxPhy, dcfBuf_0_rxPhy_ir, dcfBuf_0_rxPhy_fe, dcfBuf_0_rxPhy_re, 
                  dcfBuf_0_irqTx, 
                  dcfBuf_0_irqRx, 
                  regBus, regWe, regRe, dcfBuf_0_regWe, dcfBuf_0_regRe, clk, clk2, reset);


//==============================================================================
