//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   dcfBuf
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module dcfBuf(rxHost, rxHost_or, rxHost_ff, rxHost_we, 
              txPhy, txPhy_or, txPhy_ff, txPhy_we, 
              txHost, txHost_ir, txHost_fe, txHost_re, 
              rxPhy, rxPhy_ir, rxPhy_fe, rxPhy_re, 
              irqTx, 
              irqRx, 
              regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Include global definitions
  `include "def_Const_wlan.v"

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter rxHost_w          = 0;
  parameter txPhy_w           = 0;
  parameter txHost_w          = 0;
  parameter rxPhy_w           = 0;

  parameter irqTx_w           = 0;
  parameter irqRx_w           = 0;

  parameter dcfMode_w         = 0;
  parameter dcfMode_r         = 0;
  parameter dcfMode_s         = 0;
  parameter R_dcfMode         = 0;

  parameter wd                = 0;

  parameter phyTxFifo_w       = 0;
  parameter phyTxFifo_n       = 0;
  parameter phyTxFifo_m       = 0;
  parameter R_phyTxFifo       = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output       [rxHost_w-1:0]  rxHost;
  output                       rxHost_or;
  input                        rxHost_ff;
  output                       rxHost_we;
  assign                       rxHost_we = rxHost_or & ~rxHost_ff;

  output        [txPhy_w-1:0]  txPhy;
  output                       txPhy_or;
  input                        txPhy_ff;
  output                       txPhy_we;
  assign                       txPhy_we = txPhy_or & ~txPhy_ff;

  input        [txHost_w-1:0]  txHost;
  output                       txHost_ir;
  input                        txHost_fe;
  output                       txHost_re;
  assign                       txHost_re = txHost_ir & ~txHost_fe;

  input         [rxPhy_w-1:0]  rxPhy;
  output                       rxPhy_ir;
  input                        rxPhy_fe;
  output                       rxPhy_re;
  assign                       rxPhy_re = rxPhy_ir & ~rxPhy_fe;

  output        [irqTx_w-1:0]  irqTx;
  output        [irqRx_w-1:0]  irqRx;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire        [dcfMode_w-1:0]  dcfMode_q;
  wire        [dcfMode_w-1:0]  dcfMode_d;
  wire                         dcfMode_weint;
  assign                       dcfMode_weint = 0;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg dcfMode(dcfMode_q, regBus, dcfMode_d, dcfMode_weint, regWe, regRe, clk, reset);
  defparam dcfMode.w    = dcfMode_w;
  defparam dcfMode.rval = dcfMode_r;
  defparam dcfMode.sgn  = dcfMode_s;
  defparam dcfMode.adr  = R_dcfMode;

  // --------------------------------------------------------------------------------------
  // Included instances
  `include "s1To2Sel_16a.v"
  `include "s2To1Sel_16a.v"
  `include "s2To1Sel_16b.v"
  `include "s1To2Sel_16b.v"
  `include "dataBuf_dcfRx.v"
  `include "dataBuf_dcfTx.v"
  `include "fifoIf_0.v"
  `include "c16To8_0.v"
  `include "c8To16_0.v"

  // --------------------------------------------------------------------------------------
  // Define FIFO connections

  // ----------------------------------------
  // Fifo fifoIf_0_tx -> s2To1Sel_16b_x1
  wire    [phyTxFifo_w-1:0]  phyTxFifo_q;
  wire                       phyTxFifo_fe;
  wire                       phyTxFifo_ff;
  wire                       phyTxFifo_ff2;
  wire                       phyTxFifo_fuf;
  wire                       phyTxFifo_fof;
  wire    [phyTxFifo_w-1:0]  phyTxFifo_d;
  wire                       phyTxFifo_re;
  wire                       phyTxFifo_we;
  wire                       phyTxFifo_ir;
  wire                       phyTxFifo_or;

  fifoA phyTxFifo(phyTxFifo_q, phyTxFifo_fe, phyTxFifo_ff, phyTxFifo_ff2, phyTxFifo_fuf,
                  phyTxFifo_fof, phyTxFifo_d, phyTxFifo_re, phyTxFifo_we, phyTxFifo_ir,
                  phyTxFifo_or, regBus, regWe, clk);
  defparam phyTxFifo.w = phyTxFifo_w;
  defparam phyTxFifo.m = phyTxFifo_m;
  defparam phyTxFifo.n = phyTxFifo_n;
  defparam phyTxFifo.a = R_phyTxFifo;

  assign phyTxFifo_d               = fifoIf_0_tx;
  assign phyTxFifo_we              = fifoIf_0_tx_we;
  assign fifoIf_0_tx_ff            = phyTxFifo_ff;
  assign phyTxFifo_or              = fifoIf_0_tx_or;

  assign s2To1Sel_16b_x1           = phyTxFifo_q;
  assign s2To1Sel_16b_x1_fe        = phyTxFifo_fe;
  assign phyTxFifo_re              = s2To1Sel_16b_x1_re;
  assign phyTxFifo_ir              = s2To1Sel_16b_x1_ir;


  // --------------------------------------------------------------------------------------
  // Define connections
  assign s1To2Sel_16a_sel          = dcfMode_q;
  assign s1To2Sel_16a_x            = txHost;
  assign s1To2Sel_16a_x_fe         = txHost_fe;
  assign txHost_ir                 = s1To2Sel_16a_x_ir;

  assign dataBuf_dcfTx_x           = s1To2Sel_16a_y1;
  assign dataBuf_dcfTx_x_fe        = ~s1To2Sel_16a_y1_or;
  assign s1To2Sel_16a_y1_ff        = ~dataBuf_dcfTx_x_ir;

  assign s2To1Sel_16a_sel          = dcfMode_q;
  assign s2To1Sel_16a_x0           = s1To2Sel_16b_y0;
  assign s2To1Sel_16a_x0_fe        = ~s1To2Sel_16b_y0_or;
  assign s1To2Sel_16b_y0_ff        = ~s2To1Sel_16a_x0_ir;

  assign s2To1Sel_16a_x1           = dataBuf_dcfRx_y;
  assign s2To1Sel_16a_x1_fe        = ~dataBuf_dcfRx_y_or;
  assign dataBuf_dcfRx_y_ff        = ~s2To1Sel_16a_x1_ir;

  assign rxHost                    = s2To1Sel_16a_y;
  assign rxHost_or                 = s2To1Sel_16a_y_or;
  assign s2To1Sel_16a_y_ff         = rxHost_ff;

  assign s2To1Sel_16b_sel          = dcfMode_q;
  assign c16To8_0_x                = s2To1Sel_16b_y;
  assign c16To8_0_x_fe             = ~s2To1Sel_16b_y_or;
  assign s2To1Sel_16b_y_ff         = ~c16To8_0_x_ir;

  assign s1To2Sel_16b_sel          = dcfMode_q;
  assign s1To2Sel_16b_x            = c8To16_0_y;
  assign s1To2Sel_16b_x_fe         = ~c8To16_0_y_or;
  assign c8To16_0_y_ff             = ~s1To2Sel_16b_x_ir;

  assign fifoIf_0_rx               = s1To2Sel_16b_y1;
  assign fifoIf_0_rx_fe            = ~s1To2Sel_16b_y1_or;
  assign s1To2Sel_16b_y1_ff        = ~fifoIf_0_rx_ir;

  assign txPhy                     = c16To8_0_y;
  assign txPhy_or                  = c16To8_0_y_or;
  assign c16To8_0_y_ff             = txPhy_ff;

  assign c8To16_0_x                = rxPhy;
  assign c8To16_0_x_fe             = rxPhy_fe;
  assign rxPhy_ir                  = c8To16_0_x_ir;


  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | s1To2Sel_16a_regWe | s2To1Sel_16a_regWe | s2To1Sel_16b_regWe
                      | s1To2Sel_16b_regWe | dataBuf_dcfRx_regWe | dataBuf_dcfTx_regWe
                      | fifoIf_0_regWe | c16To8_0_regWe | c8To16_0_regWe;
  assign regReOut = 0 | s1To2Sel_16a_regRe | s2To1Sel_16a_regRe | s2To1Sel_16b_regRe
                      | s1To2Sel_16b_regRe | dataBuf_dcfRx_regRe | dataBuf_dcfTx_regRe
                      | fifoIf_0_regRe | c16To8_0_regRe | c8To16_0_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Assign IRQ outputs
  assign irqRx = fifoIf_0_irqRx;
  assign irqTx = fifoIf_0_irqTx;
  
  // Connect this manually to make sure input data is coming
  assign s2To1Sel_16b_x0           = s1To2Sel_16a_y0;
  assign s2To1Sel_16b_x0_fe        = 0; //~s1To2Sel_16a_y0_or;
  assign s1To2Sel_16a_y0_ff        = ~s2To1Sel_16b_x0_ir;


endmodule
//=========================================================================================

