//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   dataGen
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module dataGen(y, y_or, y_ff, y_we, 
               regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;


  parameter run1_w            = 0;
  parameter run1_r            = 0;
  parameter run1_s            = 0;
  parameter R_run1            = 0;
  parameter outVal_w          = 0;
  parameter outVal_r          = 0;
  parameter outVal_s          = 0;
  parameter R_outVal          = 0;
  parameter numBytes_w        = 0;
  parameter numBytes_r        = 0;
  parameter numBytes_s        = 0;
  parameter R_numBytes        = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;


  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire           [run1_w-1:0]  run1_q;
  wire           [run1_w-1:0]  run1_d;
  wire                         run1_weint;
  assign                       run1_weint = 0;

  wire         [outVal_w-1:0]  outVal_q;
  wire         [outVal_w-1:0]  outVal_d;
  wire                         outVal_weint;

  wire       [numBytes_w-1:0]  numBytes_q;
  wire       [numBytes_w-1:0]  numBytes_d;
  wire                         numBytes_weint;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg run1(run1_q, regBus, run1_d, run1_weint, regWe, regRe, clk, reset);
  defparam run1.w    = run1_w;
  defparam run1.rval = run1_r;
  defparam run1.sgn  = run1_s;
  defparam run1.adr  = R_run1;

  ereg outVal(outVal_q, regBus, outVal_d, outVal_weint, regWe, regRe, clk, reset);
  defparam outVal.w    = outVal_w;
  defparam outVal.rval = outVal_r;
  defparam outVal.sgn  = outVal_s;
  defparam outVal.adr  = R_outVal;

  ereg numBytes(numBytes_q, regBus, numBytes_d, numBytes_weint, regWe, regRe, clk, reset);
  defparam numBytes.w    = numBytes_w;
  defparam numBytes.rval = numBytes_r;
  defparam numBytes.sgn  = numBytes_s;
  defparam numBytes.adr  = R_numBytes;

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  

//-----------------------------------------------------------------------------------------
  // Assign output enables and FSM run
  assign y              = numBytes_q<=4 ? 0 : outVal_q;
  assign y_or           = numBytes_q!=0 & run1_q;

  // Assign feedback to eregs
  assign outVal_weint   = y_we;
  assign outVal_d       = outVal_q + 1;
  
  assign numBytes_weint = y_we;
  assign numBytes_d     = numBytes_q - 1;

endmodule
//=========================================================================================

