//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter cxMulAvg_0_x_w             = 20;

  // Outputs
  parameter cxMulAvg_0_ySh_w           = 9;
  parameter cxMulAvg_0_yC_w            = 26;

  // Input control lines
  parameter cxMulAvg_0_run1_w          = 3;

  // Output control lines
  parameter cxMulAvg_0_irqDone_w       = 1;

  // Eregs
  parameter cxMulAvg_0_numSmpl_w       = 7;
  parameter cxMulAvg_0_numSmpl_r       = 0;
  parameter cxMulAvg_0_numSmpl_s       = 0;
  parameter cxMulAvg_0_yReLo_w         = 16;
  parameter cxMulAvg_0_yReLo_r         = 0;
  parameter cxMulAvg_0_yReLo_s         = 0;
  parameter cxMulAvg_0_yImHi_w         = 16;
  parameter cxMulAvg_0_yImHi_r         = 0;
  parameter cxMulAvg_0_yImHi_s         = 0;

  // Parameters
  parameter cxMulAvg_0_wx              = 10;
  parameter cxMulAvg_0_wy              = 9;
  parameter cxMulAvg_0_wc              = 13;
  parameter cxMulAvg_0_sh1             = 9;
  parameter cxMulAvg_0_sh2             = 6;
  parameter cxMulAvg_0_sh3             = 9;
  parameter cxMulAvg_0_sh4             = 7;
  parameter cxMulAvg_0_cxMulModeFfe    = 2;
  parameter cxMulAvg_0_cxMulModeAmpEst = 3;
  parameter cxMulAvg_0_cxMulModeChEst  = 4;
  parameter cxMulAvg_0_cxMulModeChCor  = 5;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam cxMulAvg_0.x_w             = cxMulAvg_0_x_w;
  defparam cxMulAvg_0.ySh_w           = cxMulAvg_0_ySh_w;
  defparam cxMulAvg_0.yC_w            = cxMulAvg_0_yC_w;
  defparam cxMulAvg_0.run1_w          = cxMulAvg_0_run1_w;
  defparam cxMulAvg_0.irqDone_w       = cxMulAvg_0_irqDone_w;
  defparam cxMulAvg_0.numSmpl_w       = cxMulAvg_0_numSmpl_w;
  defparam cxMulAvg_0.numSmpl_r       = cxMulAvg_0_numSmpl_r;
  defparam cxMulAvg_0.numSmpl_s       = cxMulAvg_0_numSmpl_s;
  defparam cxMulAvg_0.yReLo_w         = cxMulAvg_0_yReLo_w;
  defparam cxMulAvg_0.yReLo_r         = cxMulAvg_0_yReLo_r;
  defparam cxMulAvg_0.yReLo_s         = cxMulAvg_0_yReLo_s;
  defparam cxMulAvg_0.yImHi_w         = cxMulAvg_0_yImHi_w;
  defparam cxMulAvg_0.yImHi_r         = cxMulAvg_0_yImHi_r;
  defparam cxMulAvg_0.yImHi_s         = cxMulAvg_0_yImHi_s;
  defparam cxMulAvg_0.wx              = cxMulAvg_0_wx;
  defparam cxMulAvg_0.wy              = cxMulAvg_0_wy;
  defparam cxMulAvg_0.wc              = cxMulAvg_0_wc;
  defparam cxMulAvg_0.sh1             = cxMulAvg_0_sh1;
  defparam cxMulAvg_0.sh2             = cxMulAvg_0_sh2;
  defparam cxMulAvg_0.sh3             = cxMulAvg_0_sh3;
  defparam cxMulAvg_0.sh4             = cxMulAvg_0_sh4;
  defparam cxMulAvg_0.cxMulModeFfe    = cxMulAvg_0_cxMulModeFfe;
  defparam cxMulAvg_0.cxMulModeAmpEst = cxMulAvg_0_cxMulModeAmpEst;
  defparam cxMulAvg_0.cxMulModeChEst  = cxMulAvg_0_cxMulModeChEst;
  defparam cxMulAvg_0.cxMulModeChCor  = cxMulAvg_0_cxMulModeChCor;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_cxMulAvg_0_numSmpl                                         = 0;
  defparam  cxMulAvg_0.R_numSmpl                                         = R_cxMulAvg_0_numSmpl;
  parameter R_cxMulAvg_0_yReLo                                           = 1;
  defparam  cxMulAvg_0.R_yReLo                                           = R_cxMulAvg_0_yReLo;
  parameter R_cxMulAvg_0_yImHi                                           = 2;
  defparam  cxMulAvg_0.R_yImHi                                           = R_cxMulAvg_0_yImHi;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire              [cxMulAvg_0_ySh_w-1:0]  cxMulAvg_0_ySh;
  wire                                      cxMulAvg_0_ySh_or;
  wire                                      cxMulAvg_0_ySh_ff;
  wire                                      cxMulAvg_0_ySh_we;

  wire               [cxMulAvg_0_yC_w-1:0]  cxMulAvg_0_yC;
  wire                                      cxMulAvg_0_yC_or;
  wire                                      cxMulAvg_0_yC_ff;
  wire                                      cxMulAvg_0_yC_we;

  wire                [cxMulAvg_0_x_w-1:0]  cxMulAvg_0_x;
  wire                                      cxMulAvg_0_x_ir;
  wire                                      cxMulAvg_0_x_fe;
  wire                                      cxMulAvg_0_x_re;

  wire          [cxMulAvg_0_irqDone_w-1:0]  cxMulAvg_0_irqDone;

  wire             [cxMulAvg_0_run1_w-1:0]  cxMulAvg_0_run1;

  wire                                      cxMulAvg_0_regWe;
  wire                                      cxMulAvg_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  cxMulAvg cxMulAvg_0(cxMulAvg_0_ySh, cxMulAvg_0_ySh_or, cxMulAvg_0_ySh_ff, cxMulAvg_0_ySh_we,
                      cxMulAvg_0_yC, cxMulAvg_0_yC_or, cxMulAvg_0_yC_ff, cxMulAvg_0_yC_we,
                      cxMulAvg_0_x, cxMulAvg_0_x_ir, cxMulAvg_0_x_fe, cxMulAvg_0_x_re, 
                      cxMulAvg_0_irqDone, 
                      cxMulAvg_0_run1, 
                      regBus, regWe, regRe, cxMulAvg_0_regWe, cxMulAvg_0_regRe, clk, clk2, reset);


//==============================================================================
