//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   cutN
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module cutN(y, y_or, y_ff, y_we, 
            x, x_ir, x_fe, x_re, 
            run1, 
            regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter x_w               = 0;

  parameter run1_w            = 0;

  parameter numCut_w          = 0;
  parameter numCut_r          = 0;
  parameter numCut_s          = 0;
  parameter R_numCut          = 0;

  parameter w                 = 0;

  parameter cntCut_w          = 0;
  parameter cntCut_n          = 0;
  parameter cntCut_m          = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  input          [run1_w-1:0]  run1;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire         [numCut_w-1:0]  numCut_q;
  wire         [numCut_w-1:0]  numCut_d;
  wire                         numCut_weint;
  assign                       numCut_weint = 0;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg numCut(numCut_q, regBus, numCut_d, numCut_weint, regWe, regRe, clk, reset);
  defparam numCut.w    = numCut_w;
  defparam numCut.rval = numCut_r;
  defparam numCut.sgn  = numCut_s;
  defparam numCut.adr  = R_numCut;

  // --------------------------------------------------------------------------------------
  // Internal status registers
  reg          [cntCut_w-1:0]  cntCut;

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------
  // Assign input and output enable
  assign x_ir = run1 & (~y_ff | cntCut!=0);
  assign y_or = run1 & (~x_fe & cntCut==0);
  assign y    = x;
  
  // --------------------------------------------------------------------------
  // FSM
  always @(posedge clk) begin
    
    // Reset
    if (run1==0) begin
      cntCut <= numCut_q;
      
    // Normal operation
    end else begin
      
      // Update internal counter
      if (x_re & cntCut!=0) begin
        cntCut <= cntCut-1;
      end

    end // if (run1_q==0) ... else
  end // always

endmodule
//=========================================================================================

