//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter ctfeMulSum_0_x_w             = 10;

  // Outputs
  parameter ctfeMulSum_0_y_w             = 10;

  // Input control lines
  parameter ctfeMulSum_0_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter ctfeMulSum_0_wx              = 5;
  parameter ctfeMulSum_0_wy              = 10;
  parameter ctfeMulSum_0_sh              = 5;

  // Iregs
  parameter ctfeMulSum_0_xD_w            = 10;
  parameter ctfeMulSum_0_xD_n            = 17;
  parameter ctfeMulSum_0_xD_m            = `CLOG2(17);
  parameter ctfeMulSum_0_x8D_w           = 13;
  parameter ctfeMulSum_0_x8D_n           = 6;
  parameter ctfeMulSum_0_x8D_m           = `CLOG2(6);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam ctfeMulSum_0.x_w             = ctfeMulSum_0_x_w;
  defparam ctfeMulSum_0.y_w             = ctfeMulSum_0_y_w;
  defparam ctfeMulSum_0.run1_w          = ctfeMulSum_0_run1_w;
  defparam ctfeMulSum_0.wx              = ctfeMulSum_0_wx;
  defparam ctfeMulSum_0.wy              = ctfeMulSum_0_wy;
  defparam ctfeMulSum_0.sh              = ctfeMulSum_0_sh;
  defparam ctfeMulSum_0.xD_w            = ctfeMulSum_0_xD_w;
  defparam ctfeMulSum_0.xD_n            = ctfeMulSum_0_xD_n;
  defparam ctfeMulSum_0.xD_m            = ctfeMulSum_0_xD_m;
  defparam ctfeMulSum_0.x8D_w           = ctfeMulSum_0_x8D_w;
  defparam ctfeMulSum_0.x8D_n           = ctfeMulSum_0_x8D_n;
  defparam ctfeMulSum_0.x8D_m           = ctfeMulSum_0_x8D_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire              [ctfeMulSum_0_y_w-1:0]  ctfeMulSum_0_y;
  wire                                      ctfeMulSum_0_y_or;
  wire                                      ctfeMulSum_0_y_ff;
  wire                                      ctfeMulSum_0_y_we;

  wire              [ctfeMulSum_0_x_w-1:0]  ctfeMulSum_0_x;
  wire                                      ctfeMulSum_0_x_ir;
  wire                                      ctfeMulSum_0_x_fe;
  wire                                      ctfeMulSum_0_x_re;

  wire           [ctfeMulSum_0_run1_w-1:0]  ctfeMulSum_0_run1;

  wire                                      ctfeMulSum_0_regWe;
  wire                                      ctfeMulSum_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  ctfeMulSum ctfeMulSum_0(ctfeMulSum_0_y, ctfeMulSum_0_y_or, ctfeMulSum_0_y_ff, ctfeMulSum_0_y_we,
                          ctfeMulSum_0_x, ctfeMulSum_0_x_ir, ctfeMulSum_0_x_fe, ctfeMulSum_0_x_re, 
                          ctfeMulSum_0_run1, 
                          regBus, regWe, regRe, ctfeMulSum_0_regWe, ctfeMulSum_0_regRe, clk, clk2, reset);


//==============================================================================
