//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter ctfeCordic_0_x_w             = 8;

  // Outputs
  parameter ctfeCordic_0_yAbs_w          = 8;
  parameter ctfeCordic_0_yPh_w           = 8;

  // Input control lines
  parameter ctfeCordic_0_run1_w          = 1;

  // Output control lines

  // Eregs
  parameter ctfeCordic_0_thr_w           = 6;
  parameter ctfeCordic_0_thr_r           = 32;
  parameter ctfeCordic_0_thr_s           = 0;

  // Parameters
  parameter ctfeCordic_0_wx              = 8;
  parameter ctfeCordic_0_w               = 8;
  parameter ctfeCordic_0_numIt           = 7;
  parameter ctfeCordic_0_ph0             = 64;
  parameter ctfeCordic_0_ph1             = 32;
  parameter ctfeCordic_0_ph2             = 19;
  parameter ctfeCordic_0_ph3             = 10;
  parameter ctfeCordic_0_ph4             = 5;
  parameter ctfeCordic_0_ph5             = 3;
  parameter ctfeCordic_0_ph6             = 1;
  parameter ctfeCordic_0_ph7             = 1;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam ctfeCordic_0.x_w             = ctfeCordic_0_x_w;
  defparam ctfeCordic_0.yAbs_w          = ctfeCordic_0_yAbs_w;
  defparam ctfeCordic_0.yPh_w           = ctfeCordic_0_yPh_w;
  defparam ctfeCordic_0.run1_w          = ctfeCordic_0_run1_w;
  defparam ctfeCordic_0.thr_w           = ctfeCordic_0_thr_w;
  defparam ctfeCordic_0.thr_r           = ctfeCordic_0_thr_r;
  defparam ctfeCordic_0.thr_s           = ctfeCordic_0_thr_s;
  defparam ctfeCordic_0.wx              = ctfeCordic_0_wx;
  defparam ctfeCordic_0.w               = ctfeCordic_0_w;
  defparam ctfeCordic_0.numIt           = ctfeCordic_0_numIt;
  defparam ctfeCordic_0.ph0             = ctfeCordic_0_ph0;
  defparam ctfeCordic_0.ph1             = ctfeCordic_0_ph1;
  defparam ctfeCordic_0.ph2             = ctfeCordic_0_ph2;
  defparam ctfeCordic_0.ph3             = ctfeCordic_0_ph3;
  defparam ctfeCordic_0.ph4             = ctfeCordic_0_ph4;
  defparam ctfeCordic_0.ph5             = ctfeCordic_0_ph5;
  defparam ctfeCordic_0.ph6             = ctfeCordic_0_ph6;
  defparam ctfeCordic_0.ph7             = ctfeCordic_0_ph7;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_ctfeCordic_0_thr                                           = 0;
  defparam  ctfeCordic_0.R_thr                                           = R_ctfeCordic_0_thr;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire           [ctfeCordic_0_yAbs_w-1:0]  ctfeCordic_0_yAbs;
  wire                                      ctfeCordic_0_yAbs_or;
  wire                                      ctfeCordic_0_yAbs_ff;
  wire                                      ctfeCordic_0_yAbs_we;

  wire            [ctfeCordic_0_yPh_w-1:0]  ctfeCordic_0_yPh;
  wire                                      ctfeCordic_0_yPh_or;
  wire                                      ctfeCordic_0_yPh_ff;
  wire                                      ctfeCordic_0_yPh_we;

  wire              [ctfeCordic_0_x_w-1:0]  ctfeCordic_0_x;
  wire                                      ctfeCordic_0_x_ir;
  wire                                      ctfeCordic_0_x_fe;
  wire                                      ctfeCordic_0_x_re;

  wire           [ctfeCordic_0_run1_w-1:0]  ctfeCordic_0_run1;

  wire                                      ctfeCordic_0_regWe;
  wire                                      ctfeCordic_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  ctfeCordic ctfeCordic_0(ctfeCordic_0_yAbs, ctfeCordic_0_yAbs_or, ctfeCordic_0_yAbs_ff, ctfeCordic_0_yAbs_we,
                          ctfeCordic_0_yPh, ctfeCordic_0_yPh_or, ctfeCordic_0_yPh_ff, ctfeCordic_0_yPh_we,
                          ctfeCordic_0_x, ctfeCordic_0_x_ir, ctfeCordic_0_x_fe, ctfeCordic_0_x_re, 
                          ctfeCordic_0_run1, 
                          regBus, regWe, regRe, ctfeCordic_0_regWe, ctfeCordic_0_regRe, clk, clk2, reset);


//==============================================================================
