//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   ctfe
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module ctfe(yAbs, yAbs_or, yAbs_ff, yAbs_we, 
            yPh, yPh_or, yPh_ff, yPh_we, 
            x, x_ir, x_fe, x_re, 
            run1, 
            regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter yAbs_w            = 0;
  parameter yPh_w             = 0;
  parameter x_w               = 0;

  parameter run1_w            = 0;

  parameter wx                = 0;
  parameter wc                = 0;
  parameter wy                = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output         [yAbs_w-1:0]  yAbs;
  output                       yAbs_or;
  input                        yAbs_ff;
  output                       yAbs_we;
  assign                       yAbs_we = yAbs_or & ~yAbs_ff;

  output          [yPh_w-1:0]  yPh;
  output                       yPh_or;
  input                        yPh_ff;
  output                       yPh_we;
  assign                       yPh_we = yPh_or & ~yPh_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  input          [run1_w-1:0]  run1;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  // --------------------------------------------------------------------------------------
  // Included instances
  `include "ctfeMulSum_0.v"
  `include "ctfeCordic_0.v"

  // --------------------------------------------------------------------------------------
  // Define connections
  assign ctfeMulSum_0_x            = x;
  assign ctfeMulSum_0_x_fe         = x_fe;
  assign x_ir                      = ctfeMulSum_0_x_ir;

  assign yAbs                      = ctfeCordic_0_yAbs;
  assign yAbs_or                   = ctfeCordic_0_yAbs_or;
  assign ctfeCordic_0_yAbs_ff      = yAbs_ff;

  assign yPh                       = ctfeCordic_0_yPh;
  assign yPh_or                    = ctfeCordic_0_yPh_or;
  assign ctfeCordic_0_yPh_ff       = yPh_ff;


  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | ctfeMulSum_0_regWe | ctfeCordic_0_regWe;
  assign regReOut = 0 | ctfeMulSum_0_regRe | ctfeCordic_0_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // Cut the input data of the Cordic
  assign ctfeCordic_0_x    = ctfeMulSum_0_y[wc-1:0];
  assign ctfeCordic_0_x_fe = ~ctfeMulSum_0_y_or;

  assign ctfeMulSum_0_run1 = run1;
  assign ctfeCordic_0_run1 = run1;

endmodule
//=========================================================================================

