//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter crc32_0_x_w             = 1;

  // Outputs
  parameter crc32_0_y_w             = 1;

  // Input control lines
  parameter crc32_0_run1_w          = 1;

  // Output control lines

  // Eregs
  parameter crc32_0_numBits_w       = 15;
  parameter crc32_0_numBits_r       = 0;
  parameter crc32_0_numBits_s       = 0;

  // Parameters

  // Iregs
  parameter crc32_0_s_w             = 32;
  parameter crc32_0_s_n             = 1;
  parameter crc32_0_s_m             = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam crc32_0.x_w             = crc32_0_x_w;
  defparam crc32_0.y_w             = crc32_0_y_w;
  defparam crc32_0.run1_w          = crc32_0_run1_w;
  defparam crc32_0.numBits_w       = crc32_0_numBits_w;
  defparam crc32_0.numBits_r       = crc32_0_numBits_r;
  defparam crc32_0.numBits_s       = crc32_0_numBits_s;
  defparam crc32_0.s_w             = crc32_0_s_w;
  defparam crc32_0.s_n             = crc32_0_s_n;
  defparam crc32_0.s_m             = crc32_0_s_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_crc32_0_numBits                                            = 0;
  defparam  crc32_0.R_numBits                                            = R_crc32_0_numBits;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                   [crc32_0_y_w-1:0]  crc32_0_y;
  wire                                      crc32_0_y_or;
  wire                                      crc32_0_y_ff;
  wire                                      crc32_0_y_we;

  wire                   [crc32_0_x_w-1:0]  crc32_0_x;
  wire                                      crc32_0_x_ir;
  wire                                      crc32_0_x_fe;
  wire                                      crc32_0_x_re;

  wire                [crc32_0_run1_w-1:0]  crc32_0_run1;

  wire                                      crc32_0_regWe;
  wire                                      crc32_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  crc32 crc32_0(crc32_0_y, crc32_0_y_or, crc32_0_y_ff, crc32_0_y_we,
                crc32_0_x, crc32_0_x_ir, crc32_0_x_fe, crc32_0_x_re, 
                crc32_0_run1, 
                regBus, regWe, regRe, crc32_0_regWe, crc32_0_regRe, clk, clk2, reset);


//==============================================================================
