//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   crc32
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module crc32(y, y_or, y_ff, y_we, 
             x, x_ir, x_fe, x_re, 
             run1, 
             regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter x_w               = 0;

  parameter run1_w            = 0;

  parameter numBits_w         = 0;
  parameter numBits_r         = 0;
  parameter numBits_s         = 0;
  parameter R_numBits         = 0;

  parameter s_w               = 0;
  parameter s_n               = 0;
  parameter s_m               = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  input          [run1_w-1:0]  run1;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire        [numBits_w-1:0]  numBits_q;
  wire        [numBits_w-1:0]  numBits_d;
  wire                         numBits_weint;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg numBits(numBits_q, regBus, numBits_d, numBits_weint, regWe, regRe, clk, reset);
  defparam numBits.w    = numBits_w;
  defparam numBits.rval = numBits_r;
  defparam numBits.sgn  = numBits_s;
  defparam numBits.adr  = R_numBits;

  // --------------------------------------------------------------------------------------
  // Internal status registers
  reg               [s_w-1:0]  s;

  // --------------------------------------------------------------------------------------
  // Included instances
  `include "buf2_1.v"

  // --------------------------------------------------------------------------------------
  // Define connections
  assign y                         = buf2_1_y;
  assign y_or                      = buf2_1_y_or;
  assign buf2_1_y_ff               = y_ff;


  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | buf2_1_regWe;
  assign regReOut = 0 | buf2_1_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================
  
  // --------------------------------------------------------------------------------------
  // Register definitions
  reg          [s_w-1:0]  s_nxt;
  reg                     fb;
  reg                     yOut;
  
  wire         [y_w-1:0]  yP;                   // Preliminary output
  wire                    yP_we, yP_or, yP_ff;  // before buffering
  
  // --------------------------------------------------------------------------------------
  // Copy this autogenerated stuff to avoid non-causal use of yP
  assign buf2_1_x                  = yP;
  assign buf2_1_x_fe               = ~yP_or;
  assign yP_ff                     = ~buf2_1_x_ir;

  // --------------------------------------------------------------------------------------
  // Assign input and output enable, use output buffer
  assign x_ir  = run1 & (numBits_q!=0) & yP_ff==0;  
  assign yP_or = run1 & (numBits_q!=0) &  x_fe==0;
  assign yP_we = yP_or & ~yP_ff;
  assign yP    = yOut;
  
  // Output buffer control
  assign buf2_1_run1 = run1;
  
  // --------------------------------------------------------------------------------------
  // Signal processing behaviour
  always @(*) begin

    // Normal CRC operation
    if (numBits_q>32) begin
      yOut  = x;
      fb    = x^s[31];
    end else begin
      yOut  = x^!s[31];
      fb    = 0;
    end
    if (fb)
      s_nxt = (s<<1) ^ 32'h04C11DB7;
    else
      s_nxt = s<<1;
  end

  // Count down number of bits whenever data is read
  assign numBits_d      = numBits_q-1;
  assign numBits_weint  = x_re;
    
  // --------------------------------------------------------------------------------------
  // FSM
  always @(posedge clk) begin

    // Reset
    if (run1==0) begin
      s <= 32'hFFFFFFFF;   // Initialize the CRC state

   // Normal operation
    end else begin
      if (x_re) begin
        s <= s_nxt;  
      end
    
    end //if (run_q==0)
  end //always
  
endmodule
//=========================================================================================
