//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter cpExt_0_x_w             = 20;

  // Outputs
  parameter cpExt_0_y_w             = 20;

  // Input control lines
  parameter cpExt_0_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter cpExt_0_w               = 10;

  // Iregs

  // Single ported memories
  parameter cpExt_0_cpBuf_w         = 20;
  parameter cpExt_0_cpBuf_n         = 16;
  parameter cpExt_0_cpBuf_m         = `CLOG2(16);

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam cpExt_0.x_w             = cpExt_0_x_w;
  defparam cpExt_0.y_w             = cpExt_0_y_w;
  defparam cpExt_0.run1_w          = cpExt_0_run1_w;
  defparam cpExt_0.w               = cpExt_0_w;
  defparam cpExt_0.cpBuf_w         = cpExt_0_cpBuf_w;
  defparam cpExt_0.cpBuf_n         = cpExt_0_cpBuf_n;
  defparam cpExt_0.cpBuf_m         = cpExt_0_cpBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                   [cpExt_0_y_w-1:0]  cpExt_0_y;
  wire                                      cpExt_0_y_or;
  wire                                      cpExt_0_y_ff;
  wire                                      cpExt_0_y_we;

  wire                   [cpExt_0_x_w-1:0]  cpExt_0_x;
  wire                                      cpExt_0_x_ir;
  wire                                      cpExt_0_x_fe;
  wire                                      cpExt_0_x_re;

  wire                [cpExt_0_run1_w-1:0]  cpExt_0_run1;

  wire                                      cpExt_0_regWe;
  wire                                      cpExt_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  cpExt cpExt_0(cpExt_0_y, cpExt_0_y_or, cpExt_0_y_ff, cpExt_0_y_we,
                cpExt_0_x, cpExt_0_x_ir, cpExt_0_x_fe, cpExt_0_x_re, 
                cpExt_0_run1, 
                regBus, regWe, regRe, cpExt_0_regWe, cpExt_0_regRe, clk, clk2, reset);


//==============================================================================
