//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter cordicRot_0_x_w             = 20;

  // Outputs
  parameter cordicRot_0_y_w             = 20;

  // Input control lines
  parameter cordicRot_0_runOut_w        = 2;
  parameter cordicRot_0_numOut_w        = 7;
  parameter cordicRot_0_fftWrap_w       = 4;

  // Output control lines
  parameter cordicRot_0_irqRxDatRd_w    = 1;

  // Eregs
  parameter cordicRot_0_ph_w            = 16;
  parameter cordicRot_0_ph_r            = 0;
  parameter cordicRot_0_ph_s            = 0;
  parameter cordicRot_0_dph_w           = 16;
  parameter cordicRot_0_dph_r           = 0;
  parameter cordicRot_0_dph_s           = 0;

  // Parameters
  parameter cordicRot_0_wx              = 10;
  parameter cordicRot_0_wy              = 10;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam cordicRot_0.x_w             = cordicRot_0_x_w;
  defparam cordicRot_0.y_w             = cordicRot_0_y_w;
  defparam cordicRot_0.runOut_w        = cordicRot_0_runOut_w;
  defparam cordicRot_0.numOut_w        = cordicRot_0_numOut_w;
  defparam cordicRot_0.fftWrap_w       = cordicRot_0_fftWrap_w;
  defparam cordicRot_0.irqRxDatRd_w    = cordicRot_0_irqRxDatRd_w;
  defparam cordicRot_0.ph_w            = cordicRot_0_ph_w;
  defparam cordicRot_0.ph_r            = cordicRot_0_ph_r;
  defparam cordicRot_0.ph_s            = cordicRot_0_ph_s;
  defparam cordicRot_0.dph_w           = cordicRot_0_dph_w;
  defparam cordicRot_0.dph_r           = cordicRot_0_dph_r;
  defparam cordicRot_0.dph_s           = cordicRot_0_dph_s;
  defparam cordicRot_0.wx              = cordicRot_0_wx;
  defparam cordicRot_0.wy              = cordicRot_0_wy;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_cordicRot_0_ph                                             = 0;
  defparam  cordicRot_0.R_ph                                             = R_cordicRot_0_ph;
  parameter R_cordicRot_0_dph                                            = 1;
  defparam  cordicRot_0.R_dph                                            = R_cordicRot_0_dph;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [cordicRot_0_y_w-1:0]  cordicRot_0_y;
  wire                                      cordicRot_0_y_or;
  wire                                      cordicRot_0_y_ff;
  wire                                      cordicRot_0_y_we;

  wire               [cordicRot_0_x_w-1:0]  cordicRot_0_x;
  wire                                      cordicRot_0_x_ir;
  wire                                      cordicRot_0_x_fe;
  wire                                      cordicRot_0_x_re;

  wire      [cordicRot_0_irqRxDatRd_w-1:0]  cordicRot_0_irqRxDatRd;

  wire          [cordicRot_0_runOut_w-1:0]  cordicRot_0_runOut;
  wire          [cordicRot_0_numOut_w-1:0]  cordicRot_0_numOut;
  wire         [cordicRot_0_fftWrap_w-1:0]  cordicRot_0_fftWrap;

  wire                                      cordicRot_0_regWe;
  wire                                      cordicRot_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  cordicRot cordicRot_0(cordicRot_0_y, cordicRot_0_y_or, cordicRot_0_y_ff, cordicRot_0_y_we,
                        cordicRot_0_x, cordicRot_0_x_ir, cordicRot_0_x_fe, cordicRot_0_x_re, 
                        cordicRot_0_irqRxDatRd, 
                        cordicRot_0_runOut, 
                        cordicRot_0_numOut, 
                        cordicRot_0_fftWrap, 
                        regBus, regWe, regRe, cordicRot_0_regWe, cordicRot_0_regRe, clk, clk2, reset);


//==============================================================================
