//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter ccEnc_0_x_w             = 1;

  // Outputs
  parameter ccEnc_0_y_w             = 2;

  // Input control lines
  parameter ccEnc_0_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters

  // Iregs
  parameter ccEnc_0_s_w             = 6;
  parameter ccEnc_0_s_n             = 1;
  parameter ccEnc_0_s_m             = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam ccEnc_0.x_w             = ccEnc_0_x_w;
  defparam ccEnc_0.y_w             = ccEnc_0_y_w;
  defparam ccEnc_0.run1_w          = ccEnc_0_run1_w;
  defparam ccEnc_0.s_w             = ccEnc_0_s_w;
  defparam ccEnc_0.s_n             = ccEnc_0_s_n;
  defparam ccEnc_0.s_m             = ccEnc_0_s_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                   [ccEnc_0_y_w-1:0]  ccEnc_0_y;
  wire                                      ccEnc_0_y_or;
  wire                                      ccEnc_0_y_ff;
  wire                                      ccEnc_0_y_we;

  wire                   [ccEnc_0_x_w-1:0]  ccEnc_0_x;
  wire                                      ccEnc_0_x_ir;
  wire                                      ccEnc_0_x_fe;
  wire                                      ccEnc_0_x_re;

  wire                [ccEnc_0_run1_w-1:0]  ccEnc_0_run1;

  wire                                      ccEnc_0_regWe;
  wire                                      ccEnc_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  ccEnc ccEnc_0(ccEnc_0_y, ccEnc_0_y_or, ccEnc_0_y_ff, ccEnc_0_y_we,
                ccEnc_0_x, ccEnc_0_x_ir, ccEnc_0_x_fe, ccEnc_0_x_re, 
                ccEnc_0_run1, 
                regBus, regWe, regRe, ccEnc_0_regWe, ccEnc_0_regRe, clk, clk2, reset);


//==============================================================================
