//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   ccEnc
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module ccEnc(y, y_or, y_ff, y_we, 
             x, x_ir, x_fe, x_re, 
             run1, 
             regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter x_w               = 0;

  parameter run1_w            = 0;

  parameter s_w               = 0;
  parameter s_n               = 0;
  parameter s_m               = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  input          [run1_w-1:0]  run1;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  // --------------------------------------------------------------------------------------
  // Internal status registers
  reg               [s_w-1:0]  s;

  // --------------------------------------------------------------------------------------
  // Included instances
  `include "buf2_2.v"

  // --------------------------------------------------------------------------------------
  // Define connections
  assign y                         = buf2_2_y;
  assign y_or                      = buf2_2_y_or;
  assign buf2_2_y_ff               = y_ff;


  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | buf2_2_regWe;
  assign regReOut = 0 | buf2_2_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Register definitions
  wire                    y0, y1;  
  wire            [s_w:0] sAll;
  wire          [s_w-1:0] s_nxt;

  wire         [y_w-1:0]  yP;                   // Preliminary output
  wire                    yP_we, yP_or, yP_ff;  // before buffering

  // --------------------------------------------------------------------------------------
  // Copy this autogenerated stuff to avoid non-causal use of yP
  assign buf2_2_x                  = yP;
  assign buf2_2_x_fe               = ~yP_or;
  assign yP_ff                     = ~buf2_2_x_ir;

  // --------------------------------------------------------------------------------------
  // Assign input and output enable
  assign x_ir  = run1 & yP_ff==0;  
  assign yP_or = run1 &  x_fe==0;
  assign yP_we = yP_or & ~yP_ff;
  assign yP    = {y1, y0};
  
  // Output buffer control
  assign buf2_2_run1 = run1;
  
  // --------------------------------------------------------------------------------------
  // Signal processing behaviour
  assign sAll  = {s, x};
  assign y0    = ^(sAll & 7'b1101101);
  assign y1    = ^(sAll & 7'b1001111);
  assign s_nxt = sAll[5:0];

  // --------------------------------------------------------------------------------------
  // FSM
  always @(posedge clk) begin
    
    // Reset
    if (run1==0) begin
      s <= 0;
      
    // Normal operation
    end else begin
      
      // Register update 
      if (x_re) begin
        s <= s_nxt;
      end
      

    end // if (run1_q==0) ... else
  end // always

endmodule
//=========================================================================================

