//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter cDeIntlv_0_x_w             = 20;

  // Outputs
  parameter cDeIntlv_0_y_w             = 20;

  // Input control lines
  parameter cDeIntlv_0_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter cDeIntlv_0_w               = 10;

  // Iregs

  // Single ported memories

  // Dual ported memories
  parameter cDeIntlv_0_cBuf_w          = 20;
  parameter cDeIntlv_0_cBuf_n          = 52;
  parameter cDeIntlv_0_cBuf_m          = `CLOG2(52);

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam cDeIntlv_0.x_w             = cDeIntlv_0_x_w;
  defparam cDeIntlv_0.y_w             = cDeIntlv_0_y_w;
  defparam cDeIntlv_0.run1_w          = cDeIntlv_0_run1_w;
  defparam cDeIntlv_0.w               = cDeIntlv_0_w;
  defparam cDeIntlv_0.cBuf_w          = cDeIntlv_0_cBuf_w;
  defparam cDeIntlv_0.cBuf_n          = cDeIntlv_0_cBuf_n;
  defparam cDeIntlv_0.cBuf_m          = cDeIntlv_0_cBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                [cDeIntlv_0_y_w-1:0]  cDeIntlv_0_y;
  wire                                      cDeIntlv_0_y_or;
  wire                                      cDeIntlv_0_y_ff;
  wire                                      cDeIntlv_0_y_we;

  wire                [cDeIntlv_0_x_w-1:0]  cDeIntlv_0_x;
  wire                                      cDeIntlv_0_x_ir;
  wire                                      cDeIntlv_0_x_fe;
  wire                                      cDeIntlv_0_x_re;

  wire             [cDeIntlv_0_run1_w-1:0]  cDeIntlv_0_run1;

  wire                                      cDeIntlv_0_regWe;
  wire                                      cDeIntlv_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  cDeIntlv cDeIntlv_0(cDeIntlv_0_y, cDeIntlv_0_y_or, cDeIntlv_0_y_ff, cDeIntlv_0_y_we,
                      cDeIntlv_0_x, cDeIntlv_0_x_ir, cDeIntlv_0_x_fe, cDeIntlv_0_x_re, 
                      cDeIntlv_0_run1, 
                      regBus, regWe, regRe, cDeIntlv_0_regWe, cDeIntlv_0_regRe, clk, clk2, reset);


//==============================================================================
