//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter c8To16_0_x_w             = 8;

  // Outputs
  parameter c8To16_0_y_w             = 16;

  // Input control lines

  // Output control lines

  // Eregs
  parameter c8To16_0_run1_w          = 1;
  parameter c8To16_0_run1_r          = 0;
  parameter c8To16_0_run1_s          = 0;
  parameter c8To16_0_nByte_w         = 12;
  parameter c8To16_0_nByte_r         = 0;
  parameter c8To16_0_nByte_s         = 0;

  // Parameters

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam c8To16_0.x_w             = c8To16_0_x_w;
  defparam c8To16_0.y_w             = c8To16_0_y_w;
  defparam c8To16_0.run1_w          = c8To16_0_run1_w;
  defparam c8To16_0.run1_r          = c8To16_0_run1_r;
  defparam c8To16_0.run1_s          = c8To16_0_run1_s;
  defparam c8To16_0.nByte_w         = c8To16_0_nByte_w;
  defparam c8To16_0.nByte_r         = c8To16_0_nByte_r;
  defparam c8To16_0.nByte_s         = c8To16_0_nByte_s;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_c8To16_0_run1                                              = 0;
  defparam  c8To16_0.R_run1                                              = R_c8To16_0_run1;
  parameter R_c8To16_0_nByte                                             = 1;
  defparam  c8To16_0.R_nByte                                             = R_c8To16_0_nByte;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                  [c8To16_0_y_w-1:0]  c8To16_0_y;
  wire                                      c8To16_0_y_or;
  wire                                      c8To16_0_y_ff;
  wire                                      c8To16_0_y_we;

  wire                  [c8To16_0_x_w-1:0]  c8To16_0_x;
  wire                                      c8To16_0_x_ir;
  wire                                      c8To16_0_x_fe;
  wire                                      c8To16_0_x_re;

  wire                                      c8To16_0_regWe;
  wire                                      c8To16_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  c8To16 c8To16_0(c8To16_0_y, c8To16_0_y_or, c8To16_0_y_ff, c8To16_0_y_we,
                  c8To16_0_x, c8To16_0_x_ir, c8To16_0_x_fe, c8To16_0_x_re, 
                  regBus, regWe, regRe, c8To16_0_regWe, c8To16_0_regRe, clk, clk2, reset);


//==============================================================================
