//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   byte2Bit
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module byte2Bit(y, y_or, y_ff, y_we, 
                x, x_ir, x_fe, x_re, 
                run1, 
                regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter x_w               = 0;

  parameter run1_w            = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  input          [run1_w-1:0]  run1;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Register definitions
  reg     [6:0]  xD;
  reg     [2:0]  cnt;
  
  // --------------------------------------------------------------------------------------
  // Assign input and output enable
  assign x_ir = y_we & cnt==0;
  assign y_or = run1;
  assign y    = cnt==0 ? x[0] : xD[0];
  
  // --------------------------------------------------------------------------------------
  // FSM
  always @(posedge clk) begin
    
    // Reset
    if (run1==0) begin
      cnt <= 0;
      
    // Normal operation
    end else begin
      
      if (y_we) begin
        cnt <= cnt+1;
        if (cnt==0) begin
          xD <= x[7:1];
        end else begin
          xD <= xD >> 1;
        end
      end

    end // if (run1==0) ... else
  end // always

endmodule
//=========================================================================================

