//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter bufNormRot_0_x_w             = 20;

  // Outputs
  parameter bufNormRot_0_y_w             = 20;
  parameter bufNormRot_0_yu_w            = 20;

  // Input control lines
  parameter bufNormRot_0_run1_w          = 1;
  parameter bufNormRot_0_ssAcqHalt_w     = 1;

  // Output control lines
  parameter bufNormRot_0_irqRxDatWr_w    = 1;
  parameter bufNormRot_0_irqRxDatRd_w    = 1;

  // Eregs
  parameter bufNormRot_0_numOut_w        = 7;
  parameter bufNormRot_0_numOut_r        = 0;
  parameter bufNormRot_0_numOut_s        = 0;
  parameter bufNormRot_0_runOut_w        = 2;
  parameter bufNormRot_0_runOut_r        = 0;
  parameter bufNormRot_0_runOut_s        = 0;
  parameter bufNormRot_0_fftWrap_w       = 4;
  parameter bufNormRot_0_fftWrap_r       = 0;
  parameter bufNormRot_0_fftWrap_s       = 0;

  // Parameters
  parameter bufNormRot_0_wx              = 10;
  parameter bufNormRot_0_wy              = 10;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam bufNormRot_0.x_w             = bufNormRot_0_x_w;
  defparam bufNormRot_0.y_w             = bufNormRot_0_y_w;
  defparam bufNormRot_0.yu_w            = bufNormRot_0_yu_w;
  defparam bufNormRot_0.run1_w          = bufNormRot_0_run1_w;
  defparam bufNormRot_0.ssAcqHalt_w     = bufNormRot_0_ssAcqHalt_w;
  defparam bufNormRot_0.irqRxDatWr_w    = bufNormRot_0_irqRxDatWr_w;
  defparam bufNormRot_0.irqRxDatRd_w    = bufNormRot_0_irqRxDatRd_w;
  defparam bufNormRot_0.numOut_w        = bufNormRot_0_numOut_w;
  defparam bufNormRot_0.numOut_r        = bufNormRot_0_numOut_r;
  defparam bufNormRot_0.numOut_s        = bufNormRot_0_numOut_s;
  defparam bufNormRot_0.runOut_w        = bufNormRot_0_runOut_w;
  defparam bufNormRot_0.runOut_r        = bufNormRot_0_runOut_r;
  defparam bufNormRot_0.runOut_s        = bufNormRot_0_runOut_s;
  defparam bufNormRot_0.fftWrap_w       = bufNormRot_0_fftWrap_w;
  defparam bufNormRot_0.fftWrap_r       = bufNormRot_0_fftWrap_r;
  defparam bufNormRot_0.fftWrap_s       = bufNormRot_0_fftWrap_s;
  defparam bufNormRot_0.wx              = bufNormRot_0_wx;
  defparam bufNormRot_0.wy              = bufNormRot_0_wy;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_bufNormRot_0_numOut                                        = 0;
  defparam  bufNormRot_0.R_numOut                                        = R_bufNormRot_0_numOut;
  parameter R_bufNormRot_0_runOut                                        = 1;
  defparam  bufNormRot_0.R_runOut                                        = R_bufNormRot_0_runOut;
  parameter R_bufNormRot_0_fftWrap                                       = 2;
  defparam  bufNormRot_0.R_fftWrap                                       = R_bufNormRot_0_fftWrap;
  parameter R_bufNormRot_0_rxBuf_0_wrAdr                                 = 3;
  defparam  bufNormRot_0.R_rxBuf_0_wrAdr                                 = R_bufNormRot_0_rxBuf_0_wrAdr;
  parameter R_bufNormRot_0_rxBuf_0_rdAdr0                                = 4;
  defparam  bufNormRot_0.R_rxBuf_0_rdAdr0                                = R_bufNormRot_0_rxBuf_0_rdAdr0;
  parameter R_bufNormRot_0_rxBuf_0_irqAdr                                = 5;
  defparam  bufNormRot_0.R_rxBuf_0_irqAdr                                = R_bufNormRot_0_rxBuf_0_irqAdr;
  parameter R_bufNormRot_0_rxBuf_0_agcDoneAdr                            = 6;
  defparam  bufNormRot_0.R_rxBuf_0_agcDoneAdr                            = R_bufNormRot_0_rxBuf_0_agcDoneAdr;
  parameter R_bufNormRot_0_normX_0_amp                                   = 7;
  defparam  bufNormRot_0.R_normX_0_amp                                   = R_bufNormRot_0_normX_0_amp;
  parameter R_bufNormRot_0_cordicRot_0_ph                                = 8;
  defparam  bufNormRot_0.R_cordicRot_0_ph                                = R_bufNormRot_0_cordicRot_0_ph;
  parameter R_bufNormRot_0_cordicRot_0_dph                               = 9;
  defparam  bufNormRot_0.R_cordicRot_0_dph                               = R_bufNormRot_0_cordicRot_0_dph;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire              [bufNormRot_0_y_w-1:0]  bufNormRot_0_y;
  wire                                      bufNormRot_0_y_or;
  wire                                      bufNormRot_0_y_ff;
  wire                                      bufNormRot_0_y_we;

  wire             [bufNormRot_0_yu_w-1:0]  bufNormRot_0_yu;
  wire                                      bufNormRot_0_yu_or;
  wire                                      bufNormRot_0_yu_ff;
  wire                                      bufNormRot_0_yu_we;

  wire              [bufNormRot_0_x_w-1:0]  bufNormRot_0_x;
  wire                                      bufNormRot_0_x_ir;
  wire                                      bufNormRot_0_x_fe;
  wire                                      bufNormRot_0_x_re;

  wire     [bufNormRot_0_irqRxDatWr_w-1:0]  bufNormRot_0_irqRxDatWr;
  wire     [bufNormRot_0_irqRxDatRd_w-1:0]  bufNormRot_0_irqRxDatRd;

  wire           [bufNormRot_0_run1_w-1:0]  bufNormRot_0_run1;
  wire      [bufNormRot_0_ssAcqHalt_w-1:0]  bufNormRot_0_ssAcqHalt;

  wire                                      bufNormRot_0_regWe;
  wire                                      bufNormRot_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  bufNormRot bufNormRot_0(bufNormRot_0_y, bufNormRot_0_y_or, bufNormRot_0_y_ff, bufNormRot_0_y_we,
                          bufNormRot_0_yu, bufNormRot_0_yu_or, bufNormRot_0_yu_ff, bufNormRot_0_yu_we,
                          bufNormRot_0_x, bufNormRot_0_x_ir, bufNormRot_0_x_fe, bufNormRot_0_x_re, 
                          bufNormRot_0_irqRxDatWr, 
                          bufNormRot_0_irqRxDatRd, 
                          bufNormRot_0_run1, 
                          bufNormRot_0_ssAcqHalt, 
                          regBus, regWe, regRe, bufNormRot_0_regWe, bufNormRot_0_regRe, clk, clk2, reset);


//==============================================================================
