//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   bufNormRot
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module bufNormRot(y, y_or, y_ff, y_we, 
                  yu, yu_or, yu_ff, yu_we, 
                  x, x_ir, x_fe, x_re, 
                  irqRxDatWr, 
                  irqRxDatRd, 
                  run1, 
                  ssAcqHalt, 
                  regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter yu_w              = 0;
  parameter x_w               = 0;

  parameter irqRxDatWr_w      = 0;
  parameter irqRxDatRd_w      = 0;
  parameter run1_w            = 0;
  parameter ssAcqHalt_w       = 0;

  parameter numOut_w          = 0;
  parameter numOut_r          = 0;
  parameter numOut_s          = 0;
  parameter R_numOut          = 0;
  parameter runOut_w          = 0;
  parameter runOut_r          = 0;
  parameter runOut_s          = 0;
  parameter R_runOut          = 0;
  parameter fftWrap_w         = 0;
  parameter fftWrap_r         = 0;
  parameter fftWrap_s         = 0;
  parameter R_fftWrap         = 0;

  parameter wx                = 0;
  parameter wy                = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  output           [yu_w-1:0]  yu;
  output                       yu_or;
  input                        yu_ff;
  output                       yu_we;
  assign                       yu_we = yu_or & ~yu_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  output   [irqRxDatWr_w-1:0]  irqRxDatWr;
  output   [irqRxDatRd_w-1:0]  irqRxDatRd;
  input          [run1_w-1:0]  run1;
  input     [ssAcqHalt_w-1:0]  ssAcqHalt;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire         [numOut_w-1:0]  numOut_q;
  wire         [numOut_w-1:0]  numOut_d;
  wire                         numOut_weint;
  assign                       numOut_weint = 0;

  wire         [runOut_w-1:0]  runOut_q;
  wire         [runOut_w-1:0]  runOut_d;
  wire                         runOut_weint;

  wire        [fftWrap_w-1:0]  fftWrap_q;
  wire        [fftWrap_w-1:0]  fftWrap_d;
  wire                         fftWrap_weint;
  assign                       fftWrap_weint = 0;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg numOut(numOut_q, regBus, numOut_d, numOut_weint, regWe, regRe, clk, reset);
  defparam numOut.w    = numOut_w;
  defparam numOut.rval = numOut_r;
  defparam numOut.sgn  = numOut_s;
  defparam numOut.adr  = R_numOut;

  ereg runOut(runOut_q, regBus, runOut_d, runOut_weint, regWe, regRe, clk, reset);
  defparam runOut.w    = runOut_w;
  defparam runOut.rval = runOut_r;
  defparam runOut.sgn  = runOut_s;
  defparam runOut.adr  = R_runOut;

  ereg fftWrap(fftWrap_q, regBus, fftWrap_d, fftWrap_weint, regWe, regRe, clk, reset);
  defparam fftWrap.w    = fftWrap_w;
  defparam fftWrap.rval = fftWrap_r;
  defparam fftWrap.sgn  = fftWrap_s;
  defparam fftWrap.adr  = R_fftWrap;

  // --------------------------------------------------------------------------------------
  // Included instances
  `include "rxBuf_0.v"
  `include "normX_0.v"
  `include "cordicRot_0.v"
  `include "s1To2And_20.v"

  // --------------------------------------------------------------------------------------
  // Define connections
  assign rxBuf_0_x                 = x;
  assign rxBuf_0_x_fe              = x_fe;
  assign x_ir                      = rxBuf_0_x_ir;

  assign s1To2And_20_x             = rxBuf_0_y;
  assign s1To2And_20_x_fe          = ~rxBuf_0_y_or;
  assign rxBuf_0_y_ff              = ~s1To2And_20_x_ir;

  assign normX_0_x                 = s1To2And_20_y0;
  assign normX_0_x_fe              = ~s1To2And_20_y0_or;
  assign s1To2And_20_y0_ff         = ~normX_0_x_ir;

  assign cordicRot_0_x             = normX_0_y;
  assign cordicRot_0_x_fe          = ~normX_0_y_or;
  assign normX_0_y_ff              = ~cordicRot_0_x_ir;

  assign y                         = cordicRot_0_y;
  assign y_or                      = cordicRot_0_y_or;
  assign cordicRot_0_y_ff          = y_ff;

  assign yu                        = s1To2And_20_y1;
  assign yu_or                     = s1To2And_20_y1_or;
  assign s1To2And_20_y1_ff         = yu_ff;


  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | rxBuf_0_regWe | normX_0_regWe | cordicRot_0_regWe
                      | s1To2And_20_regWe;
  assign regReOut = 0 | rxBuf_0_regRe | normX_0_regRe | cordicRot_0_regRe
                      | s1To2And_20_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================
  
  // --------------------------------------------------------------------------------------
  // Automatically reset runOut register when finished
  assign runOut_d     = 0;
  assign runOut_weint = cordicRot_0_irqRxDatRd;

  // --------------------------------------------------------------------------------------
  // Connect control lines
  assign rxBuf_0_run1         = run1;
  
  assign rxBuf_0_runOut       = runOut_q;
  assign normX_0_runOut       = runOut_q!=0;
  assign cordicRot_0_runOut   = runOut_q;
  
  assign rxBuf_0_numOut       = numOut_q;
  assign cordicRot_0_numOut   = numOut_q;
  
  assign rxBuf_0_fftWrap      = fftWrap_q;
  assign cordicRot_0_fftWrap  = fftWrap_q;

  // Connect IRQ output lines
  assign irqRxDatWr = rxBuf_0_irqRxDatWr;
  assign irqRxDatRd = cordicRot_0_irqRxDatRd;

  // Connect ssAcqHalt
  assign rxBuf_0_ssAcqHalt = ssAcqHalt;

endmodule
//=========================================================================================

